#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "otl.h"
#include "gen_thread.h"
#include "CosNaming.h"
#include "example_COBS_.h"

#ifdef HAVE_WINDOWS_H
#include <windows.h>
#define sleep(x) Sleep(1000)
#else
extern int sleep();
#endif

object_ref
init_func()
{
    CosNaming_NamingContext context = 
	COBS_CosNaming_NamingContext_object_create();
    return context;
}

void
nls(prefix, context, recursive, ev)
char* prefix;
CosNaming_NamingContext context;
int recursive;
CORBA_Environment *ev;
{
    CosNaming_BindingIterator bi;
    CosNaming_BindingList bl;
    CosNaming_Binding b;

    CosNaming_BindingList_Init(&bl, 0, NULL);
    CosNaming_NamingContext_list(context, 0, &bl, &bi, ev);

    CosNaming_Name_Init(&b.binding_name, 0, NULL);

    while(CosNaming_BindingIterator_next_one(bi, &b, ev)) {
	int i;
	int length = strlen(prefix) + 1;
	printf("%s", prefix);
	for (i=0;i<b.binding_name._length; i++) {
	    length += strlen(b.binding_name._buffer[i].id);
	    printf("/%s", b.binding_name._buffer[i].id);
	}
	printf("\n");
	if (recursive && (b.binding_type == ncontext)) {
	    char *new_pre = malloc(length);
	    CosNaming_NamingContext subcontext;
	    strcpy(new_pre, prefix);
	    for (i=0;i<b.binding_name._length; i++) {
		strcat(new_pre, b.binding_name._buffer[i].id);
	    }
	    subcontext = (CosNaming_NamingContext) 
		CosNaming_NamingContext_resolve(context, &b.binding_name,
ev);
	    nls(new_pre, subcontext, recursive, ev);
	}
    }
    CosNaming_BindingIterator_destroy(bi, ev);
}




void
main(argc, argv)
int argc;
char **argv;
{
    /*  
     * the main function for cobs_test.  We'll follow through the flow.
     */
  CosNaming_Name n;
  CosNaming_NamingContext init_obj, obj_ref;
  CORBA_Environment *ev;
  int poll = 0;

#ifdef USE_CTHREADS
    /*  
     * if we're using Cthreads, this is a good idea.
     */ 
    argc = cthread_parse_args(argc, argv);
#endif
#ifdef USE_WIN32THREADS
    gen_win32thread_init();
#elseif USE_PTHREADS
    gen_pthread_init();
#else
    gen_null_init();
    poll++;
#endif
    /*  
     *  Init_func only gets called in the process that
     *  creates the group.  But in *every* process the return value of
     *  init_cobs() is the reference that was created in that one call to
     *  init_func...
     */
    gen_pthread_init();
    init_obj = init_cobs("name_server", init_func);
    COBS_create_Environment_object(&ev);

    n._length = 1;
    n._buffer = malloc(n._length * sizeof(n._buffer[0]));
    n._buffer[0].id = "example";
    n._buffer[0].kind = NULL;
    
    obj_ref = COBS_example_object_create();
    CosNaming_NamingContext_bind(init_obj, &n, obj_ref, ev);
    
    n._buffer[0].id = "Inventory";
    CosNaming_NamingContext_bind_new_context(init_obj, &n, ev);

    n._length = 2;
    n._buffer = malloc(n._length * sizeof(n._buffer[0]));
    n._buffer[0].id = "Inventory";
    n._buffer[0].kind = NULL;
    if(argc == 1)
      n._buffer[1].id = "Inventory2";
    else
      n._buffer[1].id = argv[1];
    n._buffer[1].kind = NULL;
    CosNaming_NamingContext_bind(init_obj, &n, obj_ref, ev);
    
    printf("Registration END\n");

    nls("", init_obj, 1, ev);
    printf("before nls call\n");
    /* I'm supposed to be the server, so lets just hang out forever */
    while (1) {
	if (poll) {
	    cobs_blocking_poll();
	} else {
	    sleep(1);
	}
    }
}
