/*Client.c*/

#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "otl.h"
#include "gen_thread.h"
#include "CosNaming.h"

#ifdef HAVE_WINDOWS_H
#include <windows.h>
#define sleep(x) Sleep(1000)
#else
extern unsigned sleep(unsigned);
#endif
#include "example_COBS_.h"
 
object_ref
init_func()
{
    printf("start the server first, we shouldn't have the initial object\n");
    exit(1);
}


void
main(argc, argv)
int argc;
char **argv;
{
    /*  
     * the main function for cobs_test.  We'll follow through the flow.
     */
  int i;
  CosNaming_NamingContext  init_obj, obj_ref, obj_ref1;
  CORBA_Environment *ev;
  CosNaming_Name n; 
  CosNaming_BindingIterator bi;
  CosNaming_BindingList bl;
  CosNaming_Binding b;
  
#ifdef USE_CTHREADS
  /*  
     * if we're using Cthreads, this is a good idea.
     */
  argc = cthread_parse_args(argc, argv);
#endif
#ifdef USE_WIN32THREADS
    gen_win32thread_init();
#elseif USE_PTHREADS
    gen_pthread_init();
#else
    gen_null_init();
#endif
  /*  
   *  init_func only gets called in the process that creates the group
   *  That shouldn't be us.  But in *every* process the return value of 
   *  init_cobs() is the reference that was created in that one call to
   *  init_func, presumably in the server.
   */
  init_obj = init_cobs("name_server", init_func);
  COBS_create_Environment_object(&ev);
  
  
  CosNaming_Name_Init(&n, 0, NULL);  
  n._length = 1;
  n._buffer = malloc(n._length * sizeof(n._buffer[0]));
  n._buffer[0].id = "Inventory";
  n._buffer[0].kind = NULL;
  n._maximum = 1;
  
  obj_ref1 = (CosNaming_NamingContext)
      CosNaming_NamingContext_resolve(init_obj, &n, ev) ;
  
  CosNaming_BindingList_Init(&bl, 0, NULL);
  CosNaming_NamingContext_list(obj_ref1, 0, &bl, &bi, ev);
  CosNaming_Name_Init(&b.binding_name, 0, NULL);
  
  while(CosNaming_BindingIterator_next_one(bi, &b, ev)) {
    char Str[20];
    for (i=0;i<b.binding_name._length; i++) {
      
      printf("/%s", b.binding_name._buffer[i].id);
      printf("\n");
      strcpy(Str,b.binding_name._buffer[i].id); 
      
      n._length = 2;
      n._buffer = malloc(n._length * sizeof(n._buffer[0]));
      n._buffer[0].id = "Inventory";
      n._buffer[1].id =  Str;
      n._buffer[0].kind =  NULL;
      n._buffer[1].kind =  NULL;
      n._maximum = 2;
      obj_ref = (CosNaming_NamingContext)
	  CosNaming_NamingContext_resolve(init_obj, &n, ev);
      
      
      if(obj_ref== NULL)
	printf("Object Reference is NULL\n");
      else{
	for (i = 0; i< 5; i++) {
	  CORBA_long a = lrand48() % 20;
	  CORBA_long b = lrand48() % 20;
	  CORBA_long total;
	  total = example_getSum(obj_ref, a, b, ev);
	  if (ev->_major != CORBA_NO_EXCEPTION) {
	      fprintf(stderr, "Operation raised exception \"%s\"\n",
		      CORBA_exception_id(ev));
	      if (strcmp(CORBA_exception_id(ev), "CORBA_COMM_FAILURE") == 0) {
		  fprintf(stderr, "Application could handle this failure and take steps to recreate the\n now-inaccessible object\n");
	      }
	      exit(1);
	  }
	  printf("Total %ld \n", total);
	  printf("-------\n");
#ifdef USE_CTHREADS
	  thr_thread_yield();
#endif
	  
	}
      }
    }
  }
  CosNaming_BindingIterator_destroy(bi, ev);
  
}
