
#include "otl.h"
#include "gen_thread.h"
#include <CosNaming.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

object_ref
init_func()
{
    return NULL;
}

void
nls(prefix, context, recursive, ev)
char* prefix;
CosNaming_NamingContext context;
int recursive;
CORBA_Environment *ev;
{
    CosNaming_BindingIterator bi;
    CosNaming_BindingList bl;
    CosNaming_Binding b;

    CosNaming_BindingList_Init(&bl, 0, NULL);
    CosNaming_NamingContext_list(context, 0, &bl, &bi, ev);

    CosNaming_Name_Init(&b.binding_name, 0, NULL);

    while(CosNaming_BindingIterator_next_one(bi, &b, ev)) {
	int i;
	int length = strlen(prefix) + 1;
	printf("%s", prefix);
	for (i=0;i<b.binding_name._length; i++) {
	    length += strlen(b.binding_name._buffer[i].id);
	    printf("/%s", b.binding_name._buffer[i].id);
	}
	printf("\n");
	if (recursive && (b.binding_type == ncontext)) {
	    char *new_pre = malloc(length);
	    CosNaming_NamingContext subcontext;
	    strcpy(new_pre, prefix);
	    for (i=0;i<b.binding_name._length; i++) {
		strcat(new_pre, b.binding_name._buffer[i].id);
	    }
	    subcontext = (CosNaming_NamingContext) 
		CosNaming_NamingContext_resolve(context, &b.binding_name, ev);
	    nls(new_pre, subcontext, recursive, ev);
	}
    }
    CosNaming_BindingIterator_destroy(bi, ev);
}

void
namify(str, n)
char *str;
CosNaming_Name *n;
{
    char *next_slash;
    int len;

    if (str == NULL) {
	return;
    }
    if (*str == '/') {
	/* skip slash */
	str++;
    }
    next_slash = strchr(str, '/');
    if (next_slash == NULL) {
	len = strlen(str);
    } else {
	len = next_slash - str;
    }
    if (len == 0) return;
    if (n->_length == 0) {
	n->_buffer = malloc(sizeof(n[0]));
	n->_maximum = 1;
    } else {
	n->_buffer = realloc(n->_buffer, sizeof(n[0]) * (n->_length + 1));
	n->_maximum = n->_length + 1;
    }
    n->_buffer[n->_length].id = malloc(len+1);
    strncpy(n->_buffer[n->_length].id, str, len);
    n->_buffer[n->_length].id[len] = 0; /* terminate string */
    n->_buffer[n->_length].kind = NULL;
    n->_length++;
    str += len;
    /* recurse */
    namify(str, n);
}

int main(argc, argv) 
int argc;
char **argv;
{
    int i;
    CORBA_Environment *ev;
    CosNaming_NamingContext root_context, context = NULL;
    char prefix[256];
    CosNaming_Name n;
    int recursive = 0;

#ifdef USE_WIN32THREADS
    gen_win32thread_init();
#elseif USE_PTHREADS
    gen_pthread_init();
#else
    gen_null_init();
#endif
    /*  
     *  init_func only gets called in the process that creates the group
     *  That shouldn't be us.  But in *every* process the return value of 
     *  init_cobs() is the reference that was created in that one call to
     *  init_func, presumably in the server.
     */
    root_context = init_cobs("name_server", init_func);
    COBS_create_Environment_object(&ev);
    CosNaming_Name_Init(&n, 0, NULL);

    for (i=1; i< argc; i++) {
	if (strcmp(argv[i], "-R") == 0) {
	    recursive++;
	} else if (strcmp(argv[i], "-S") == 0) {
	    root_context = obj_ref_from_string(argv[i+1]);
	    i++;
	} else {
	    namify(argv[i], &n);
	    context = (CosNaming_NamingContext) CosNaming_NamingContext_resolve(root_context, &n, ev);
	    if (context == NULL) {
		fprintf(stderr, "%s - Not Found\n", argv[i]);
		exit(1);
	    }
	    strcpy(prefix, argv[i]);
	    strcat(prefix, "/");
	}
    }
    if (root_context == NULL) {
	printf("No name server specified on command line or found through cobs_init().\n");
	exit(1);
    }
    if (context == NULL) {
	context = root_context;
	strcpy(prefix, "/");
    }

    nls(prefix, root_context, recursive, ev);

    return 0;
}
