
#include "otl.h"
#include "gen_thread.h"
#include <CosNaming.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

object_ref
init_func()
{
    CosNaming_NamingContext root_context = 
	COBS_CosNaming_NamingContext_object_create();

/*    printf("start the name_server first, we shouldn't have the initial object\n");
    exit(1);*/
    return root_context;
}

void
nls(prefix, context, recursive, ev)
char* prefix;
CosNaming_NamingContext context;
int recursive;
CORBA_Environment *ev;
{
    CosNaming_BindingIterator bi;
    CosNaming_BindingList bl;
    CosNaming_Binding b;

    CosNaming_BindingList_Init(&bl, 0, NULL);
    CosNaming_NamingContext_list(context, 0, &bl, &bi, ev);

    CosNaming_Name_Init(&b.binding_name, 0, NULL);

    while(CosNaming_BindingIterator_next_one(bi, &b, ev)) {
	int i;
	int length = strlen(prefix) + 1;
	printf("%s", prefix);
	for (i=0;i<b.binding_name._length; i++) {
	    length += strlen(b.binding_name._buffer[i].id);
	    printf("/%s", b.binding_name._buffer[i].id);
	}
	printf("\n");
	if (recursive && (b.binding_type == ncontext)) {
	    char *new_pre = malloc(length);
	    CosNaming_NamingContext subcontext;
	    strcpy(new_pre, prefix);
	    for (i=0;i<b.binding_name._length; i++) {
		strcat(new_pre, b.binding_name._buffer[i].id);
	    }
	    subcontext = (CosNaming_NamingContext) 
		CosNaming_NamingContext_resolve(context, &b.binding_name, ev);
	    nls(new_pre, subcontext, recursive, ev);
	}
    }
    CosNaming_BindingIterator_destroy(bi, ev);
}

int main(argc, argv) 
int argc;
char **argv;
{
    CORBA_Environment *ev;
    CosNaming_NamingContext root_context;
    CosNaming_Name n;
#ifdef USE_CTHREADS
    /*  
     * if we're using Cthreads, this is a good idea.
     */
    argc = cthread_parse_args(argc, argv);
#endif
    /*  
     *  init_func only gets called in the process that creates the group
     *  That shouldn't be us.  But in *every* process the return value of 
     *  init_cobs() is the reference that was created in that one call to
     *  init_func, presumably in the server.
     */
#ifdef USE_WIN32THREADS
    gen_win32thread_init();
#elseif USE_PTHREADS
    gen_pthread_init();
#else
    gen_null_init();
#endif

    root_context = init_cobs("name_server", init_func);
    if (argc > 1) {
	root_context = obj_ref_from_string(argv[1]);
    }
    COBS_create_Environment_object(&ev);

    n._length = 1;
    n._buffer = malloc(n._length * sizeof(n._buffer[0]));
    n._buffer[0].id = "test_name";
    n._buffer[0].kind = NULL;
    
    root_context = iiop_to_obj_ref(obj_ref_to_iiop(root_context));
    CosNaming_NamingContext_bind(root_context, &n, root_context, ev);

    n._buffer[0].id = "blort";
    CosNaming_NamingContext_bind(root_context, &n, root_context, ev);

    n._buffer[0].id = "subdir";
    CosNaming_NamingContext_bind_new_context(root_context, &n, ev);

    n._length = 2;
    n._buffer = malloc(n._length * sizeof(n._buffer[0]));
    n._buffer[0].id = "subdir";
    n._buffer[0].kind = NULL;
    n._buffer[1].id = "blort2";
    n._buffer[1].kind = NULL;
    CosNaming_NamingContext_bind(root_context, &n, root_context, ev);

    nls("", root_context, 1, ev);
}
