
#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>

#include "io.h"
#include "otl.h"
#include "gen_thread.h"
#include "CosNaming.h"

#ifdef _MSC_VER
#include <windows.h>
#define sleep(x) Sleep(1000)
#define srand48(x) srand(x)
#define lrand48() rand()
#define drand48() (((double) rand())/ (double) RAND_MAX)
#else
extern int sleep();
#endif

object_ref
init_func()
{
    CosNaming_NamingContext context = 
	COBS_CosNaming_NamingContext_object_create();
    char *istr;
    object_ref ref;
    printf("IIOP name is %s\n", obj_ref_to_iiop(context));
    printf("IOR name is %s\n", obj_ref_to_ior(context));
    istr = obj_ref_to_ior(context);
    ref = obj_ref_from_string(istr);
    
    printf("Ref is %lx\n", ref);
    printf("String is %s\n", obj_ref_to_string(ref));
    return context;
}

int
main(argc, argv)
int argc;
char **argv;
{
    /*  
     * the main function for cobs_test.  We'll follow through the flow.
     */
    object_ref init_obj;
    int poll = 0;

#ifdef USE_CTHREADS
    /*  
     * if we're using Cthreads, this is a good idea.
     */
    argc = cthread_parse_args(argc, argv);
#endif
#ifdef USE_WIN32THREADS
    gen_win32thread_init();
#elseif USE_PTHREADS
    gen_pthread_init();
#else
    gen_null_init();
    poll++;
#endif

    init_obj = init_cobs("name_server", init_func);

    /* I'm supposed to be the server, so lets just hang out forever */
    while (1) {
	if (poll) {
	    cobs_blocking_poll();
	} else {
	    sleep(1);
	}
    }
    /*NOTREACHED*/
    return 0;
}
