/** $Id: nbind.c,v 1.2 1999/09/14 18:54:39 eisen Exp $
 BeginILUCopyright

 Copyright (c) 1991-1998 Xerox Corporation.  All Rights Reserved.

 Unlimited use, reproduction, modification, and distribution of this
 software and modified versions thereof is permitted.  Permission is
 granted to make derivative works from this software or a modified
 version thereof.  Any copy of this software, a modified version
 thereof, or a derivative work must include both the above copyright
 notice of Xerox Corporation and this paragraph.  Any distribution of
 this software, a modified version thereof, or a derivative work must
 comply with all applicable United States export control laws.  This
 software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, AND NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY
 LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 NEGLIGENCE) OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGES.

 EndILUCopyright
*/
/* Last edited by Mike Spreitzer October 8, 1998 11:09 pm PDT */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include "CosNaming.h"

void
nls(prefix, context, recursive, ev)
char* prefix;
CosNaming_NamingContext context;
int recursive;
CORBA_Environment *ev;
{
    CosNaming_BindingIterator bi;
    CosNaming_BindingList *bl;
    CosNaming_Binding *b;

    bl = CosNaming_BindingList_Create(0, NULL);
    CosNaming_NamingContext_list(context, 0, &bl, &bi, ev);

    while(CosNaming_BindingIterator_next_one(bi, &b, ev)) {
	int i;
	int length = strlen(prefix) + 1;
	printf("%s", prefix);
	for (i=0;i<b->binding_name._length; i++) {
	    length += strlen(b->binding_name._buffer[i].id);
	    printf("/%s", b->binding_name._buffer[i].id);
	}
	printf("\n");
	if (recursive && (b->binding_type == CosNaming_ncontext)) {
	    char *new_pre = malloc(length);
	    CosNaming_NamingContext subcontext;
	    strcpy(new_pre, prefix);
	    for (i=0;i<b->binding_name._length; i++) {
		strcat(new_pre, b->binding_name._buffer[i].id);
	    }
	    subcontext = (CosNaming_NamingContext) 
		CosNaming_NamingContext_resolve(context, &b->binding_name, ev);
	    nls(new_pre, subcontext, recursive, ev);
	}
    }
    CosNaming_BindingIterator_destroy(bi, ev);
}

int main(int ac, char **av)
{
  CosNaming_NamingContext	obj;
  CORBA_Environment env;
  int i = 1;
  int erroffset = -1;
  ilu_string ior = ILU_NIL;
  long repeatcount = 1;
  struct CosNaming_NameComponent test_name = {"test_name", NULL};
  struct CosNaming_NameComponent in_subdir = {"blort2", NULL};
  CosNaming_Name *n;

  CosNaming__Initialize();

  while (i < ac) {
    if (strcmp(av[i], "-O") == 0) {
      if (i++ < ac)
	ior = av[i++];
      else
	goto usage;
    } else
      goto usage;
  }

  if (ior != ILU_NIL)
    {
      obj = CosNaming_NamingContext__CreateFromSBH (ior, &env);
      if (!ILU_C_SUCCESSFUL(&env))
	goto noobject;
    }
  else
    {
	printf("Supply name\n");
	exit(1);
    }

  n = CosNaming_Name_Create(0, NULL);
  CosNaming_Name_Append(n, &test_name);
    
  CosNaming_NamingContext_bind(obj, n, NULL, &env);

  n->_buffer[0].id = "blort";
  CosNaming_NamingContext_bind(obj, n, NULL, &env);


  n->_buffer[0].id = "subdir";
  CosNaming_NamingContext_bind_new_context(obj, n, &env);

  CosNaming_Name_Append(n, &in_subdir);
  CosNaming_NamingContext_bind(obj, n, NULL, &env);
  nls("", obj, 1, &env);

  return 0;

 usage:
  fprintf (stderr, "Usage:  %s [-n REPEATCOUNT] [-O STRINGIFIED-OBJREF] [-e ERR-OFFSET]\n",
	   av[0]);
  return 1;

 noobject:
  fprintf(stderr, "%s:  Unable to import object!\n", av[0]);
  return 1;
}
