#include <gen_thread.h>
#include <otl.h>
#include <CosEventChannelAdmin.h>

object_ref
init_func()
{
    printf("start the server first, we shouldn't have the initial object\n");
    exit(1);
}

void main() 
{
    /*  
     * the main function for cobs_test.  We'll follow through the flow.
     */
    int i;
    CORBA_Environment *ev;
    CosEventChannelAdmin_EventChannel channel;
    CosEventChannelAdmin_SupplierAdmin supplierAdmin;
    CosEventChannelAdmin_ProxyPushConsumer proxyPushConsumer;

#ifdef USE_CTHREADS
    /*  
     * if we're using Cthreads, this is a good idea.
     */
    argc = cthread_parse_args(argc, argv);
    gen_cthread_init();
    cthread_start(1);
#elif NON_THREADED
    gen_null_init();
#else 
    gen_pthread_init();
#endif
    /*  
     *  init_func only gets called in the process that creates the group
     *  That shouldn't be us.  But in *every* process the return value of 
     *  init_cobs() is the reference that was created in that one call to
     *  init_func, presumably in the server.
     */
    channel = init_cobs("event_channel", init_func);
    COBS_create_Environment_object(&ev);

    /* Obtain a reference to an event channel */
    /* Obtain a supplier administration object*/
    supplierAdmin = CosEventChannelAdmin_EventChannel_for_suppliers(channel, 
								    ev);

    /*  Obtain a proxy push consumer: */
    proxyPushConsumer = CosEventChannelAdmin_SupplierAdmin_obtain_push_consumer(supplierAdmin, ev);

    /* Omit optional step to connect push supplier to 
     * proxy push consumer in this example.*/

    for (i=0; i<50; i++) {
	/* Code to obtain time of day not shown.*/
	CORBA_any a;
	char string[20];
	sprintf(string, "stuff_%d", i);
	a._value = string; /* A string containing current time. */
	a._type.length = strlen(string);

	/* Push data into the event channel (which is acting
	 * as a push consumer): */
	printf("Pushing\n");
	CosEventChannelAdmin_ProxyPushConsumer_push(proxyPushConsumer, a, ev);

#ifdef USE_CTHREADS
	thr_thread_yield();
#endif
    }
    exit(0);
}
