#include <gen_thread.h>
#include <otl.h>
#include <CosEventChannelAdmin.h>
#include <consumer.h>

object_ref
init_func()
{
    printf("start the server first, we shouldn't have the initial object\n");
    exit(1);
}

void main() 
{
    /*  
     * the main function for cobs_test.  We'll follow through the flow.
     */
    CORBA_Environment *ev;
    CosEventChannelAdmin_EventChannel channel;
    CosEventChannelAdmin_ConsumerAdmin consumerAdmin;
    CosEventChannelAdmin_ProxyPushSupplier proxyPushSupplier;
    MyPushConsumer consumer;
#ifdef USE_CTHREADS
    /*  
     * if we're using Cthreads, this is a good idea.
     */
    argc = cthread_parse_args(argc, argv);
    gen_cthread_init();
    cthread_start(1);
#elif NON_THREADED
    gen_null_init();
#else
    gen_pthread_init();
#endif
    /*  
     *  init_func only gets called in the process that creates the group
     *  That shouldn't be us.  But in *every* process the return value of 
     *  init_cobs() is the reference that was created in that one call to
     *  init_func, presumably in the server.
     */
    channel = init_cobs("event_channel", init_func);
    COBS_create_Environment_object(&ev);

    consumer = COBS_MyPushConsumer_object_create();

    /* Obtain a reference to an event channel */
    /* Obtain a consumer administration object*/
    consumerAdmin = CosEventChannelAdmin_EventChannel_for_consumers(channel, 
								    ev);

    /*  Obtain a proxy push supplier: */
    proxyPushSupplier = CosEventChannelAdmin_ConsumerAdmin_obtain_push_supplier(consumerAdmin, ev);

    CosEventChannelAdmin_ProxyPushSupplier_connect_push_consumer(proxyPushSupplier, consumer, ev);

    /* I'm supposed to be the server, so lets just hang out forever */
    while (1) {
	sleep(1);
#ifdef USE_CTHREADS
	thr_thread_yield();
#endif
    }
}
