
#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>

#include "io.h"
#include "otl.h"
#include "gen_thread.h"
#include "CosEventChannelAdmin.h"

#ifdef _MSC_VER
#include <windows.h>
#define sleep(x) Sleep(1000)
#define srand48(x) srand(x)
#define lrand48() rand()
#define drand48() (((double) rand())/ (double) RAND_MAX)
#else
extern int sleep();
#endif

object_ref
init_func()
{
    CORBA_Environment ev;
    CosEventChannelAdmin_EventChannel chan = 
	COBS_CosEventChannelAdmin_EventChannel_object_create();
    COBS_init_Environment_object(&ev);
    CosEventChannelAdmin_EventChannel_initialize(chan, &ev);
    return chan;
}

void
main(argc, argv)
int argc;
char **argv;
{
    /*  
     * the main function for cobs_test.  We'll follow through the flow.
     */
    object_ref init_obj;

#ifdef USE_CTHREADS
    /*  
     * if we're using Cthreads, this is a good idea.
     */
    argc = cthread_parse_args(argc, argv);
    gen_cthread_init();
    cthread_start(1);
#elif NON_THREADED
    gen_null_init();
#else
    gen_pthread_init();
#endif
    /*  
     *  Init_func only gets called in the process that
     *  creates the group.  But in *every* process the return value of
     *  init_cobs() is the reference that was created in that one call to
     *  init_func...
     */
    init_obj = init_cobs("event_channel", init_func);

    /* I'm supposed to be the server, so lets just hang out forever */
    while (1) {
	sleep(1);
#ifdef USE_CTHREADS
	thr_thread_yield();
#endif
    }
}
