
#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "IDLtoC.h"
#include "../otl/config.h"
#include "io.h"
#include "otl.h"
#include "gen_thread.h"
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#define sleep(x) Sleep(1000)
#define srand48(x) srand(x)
#define lrand48() rand()
#define drand48() (((double) rand())/ (double) RAND_MAX)
#else
extern unsigned sleep(unsigned);
#endif
#include "CosEventChannelAdmin.h"

object_ref
init_func()
{
    printf("start the server first, we shouldn't have the initial object\n");
    exit(1);
}

void
main(argc, argv)
int argc;
char **argv;
{
    /*  
     * the main function for cobs_test.  We'll follow through the flow.
     */
    int i;
    CORBA_Object channel;

#ifdef USE_CTHREADS
    /*  
     * if we're using Cthreads, this is a good idea.
     */
    argc = cthread_parse_args(argc, argv);
#endif
    /*  
     *  init_func only gets called in the process that creates the group
     *  That shouldn't be us.  But in *every* process the return value of 
     *  init_cobs() is the reference that was created in that one call to
     *  init_func, presumably in the server.
     */
    channel = init_cobs("event_channel", init_func);

    /* seed the random numbers */
    srand48(getpid());

    if (lrand48() % 2 == 1) {
	CosEventChannelAdmin_SupplierAdmin supplier_admin;
	CosEventChannelAdmin_ProxyPushConsumer proxy_push_consumer;
	supplier_admin = CosEventChannelAdmin_EventChannel_for_suppliers(channel, ev);
	proxy_push_consumer = CosEventChannelAdmin_SupplierAdmin_obtain_push_consumer(supplier_admin, ev);
	CosEventChannelAdmin_ProxyPushConsumer_connect_push_supplier(proxy_push_consumer, doc_side_connection, ev);
	for (i = 0; i< 5; i++) {
	    CORBA_any a;
	    long val = lrand48() % 20;
	    a._type.length = sizeof(long);
	    a._value = &val;
	    CosEventChannelAdmin_ProxyPushConsumer_push(proxy_push_consumer, a, ev);
	    sleep(1);
	}
#ifdef USE_CTHREADS
	thr_thread_yield();
#endif
    }
}
