/*
 * code_generation.h
 */

#ifndef CODE_GENERATION_H
#define CODE_GENERATION_H

#include <stdio.h>

#define PARAMETERS_PER_LINE    3

#define FALSE 0
#define TRUE  1

typedef enum {
  NT_enum, 
  NT_pre_defined, 
  NT_struct,
  NT_string,   
  NT_sequence,   
  NT_array,
  NT_interface,
  NT_not_known
} TypeCode; 
  

typedef struct {
  int maximum;
} type_string;

typedef struct {
  int      maximum;
  char     *basetypename;
  TypeCode basetypecode;
} type_sequence;

typedef struct {
  int      ndims;
  int      *dims;
  char     *basetypename;
  TypeCode basetypecode;
} type_array;

typedef struct {
  int  nb_fields;
  char **array_field_name;
  char **array_field_type;
  TypeCode *array_field_typecode;
} type_struct;

  
typedef union {
  type_string        tstring;
  type_sequence      tsequence;
  type_array         tarray;
  type_struct        tstruct;
} Complex_Type;

/* The following type has been defined for use in the generation
** of subtype list. It is used only in the file code_generation.c
**/
typedef enum {
  undefined,
  visited, 
  expanded,
  marked
} NodeType;


typedef struct _Type_Description {
  char              *name;
  TypeCode           code;
  Complex_Type      *type;
  struct _Type_Description  *typedef_of;
  struct _Type_Description  **list_subtypes;  /* we keep track here only 
					      ** of direct subtypes */
  int               nb_subtypes; 
  NodeType          node_info;               /* This information is
					      ** used when traversing the
					      ** list of subtypes.
					      */
  char              has_variable_size;
} Type_Description;

/* The next type specifies a linked list of subtypes */
typedef struct _subtypecell {
  Type_Description *type;
  struct _subtypecell *next;
} subtype_list, *subtype_list_t;


typedef struct {
  char           *name;
  TypeCode       typecode;
  char           *typename;
  Complex_Type   *parameters;
  char           readonly;
  int            mirror;
} Attribute;

typedef struct attrib_list {
  Attribute         *att;
  struct attrib_list *next;
} Attribute_list_cell;

typedef enum {
  D_IN, D_OUT, D_INOUT
} Argument_direction;

typedef struct {
  char               *name;
  Argument_direction direction;
  char               *typename;
  TypeCode           typecode;
  Complex_Type       *type_parameters;
} Argument;

typedef struct argument_list{
  Argument   *arg;
  struct argument_list *next;
} Argument_list_cell;

typedef struct {
  int nb_elems;
  char **list;    /* list of ids */
} Context_Info;
  
typedef struct {
  char               *name;
  int                id;
  char               *rettypename;
  TypeCode           rettypecode;
  Complex_Type       *rettype_parameters;
  Argument_list_cell *arg_list;
  int                nb_context_elems;
  Context_Info       *context;
  int		     mirror;
  char               hasINarguments;
  char               hasOUTarguments;
  char               hasINOUTarguments;
} Operation;

typedef struct op_list {
  Operation      *op;
  struct op_list *next;
} Operation_list_cell;

typedef struct {
  char                *name;
  Attribute_list_cell *att_list;
  Operation_list_cell *op_list;
  int                 nb_of_operations;
  char 		      *mirror_name;
} Interface;

typedef struct itfc_list {
  Interface         *itfc;
  struct itfc_list  *next;
} Interface_list_cell;


extern int mirror_objects;

extern void code_generate(Interface_list_cell *, 
			  Type_Description **,
			  int,
			  FILE *, char *);

extern void code_for_attributes(Type_Description **types_array,
				int type_size,
				Interface *itfc, 
				FILE *cout, FILE *hout, char *fname);

extern void code_for_operations(Type_Description **types_array,
				int type_size,
				Interface *itfc, 
				FILE *cout, FILE *hout, char *fname);

extern void early_code_for_operations(Type_Description **types_array,
				int type_size,
				Interface *itfc, 
				FILE *cout, FILE *hout, char *fname);

extern void code_for_obj_creation(Type_Description **typelist_array,
				  int typelist_size,
				  Interface *itfc, 
				  FILE *cout, FILE *hout, 
				  char *fname);

void code_for_object_storage(Type_Description **typelist_array, 
			     int typelist_size,
			     Interface *itfc, FILE *cout);

extern void code_for_early_decls(Interface *itfc, FILE *cout);

extern void code_for_otl_ref_use(Interface *itfc, 
				 FILE *otl_out, FILE *hout, 
				 char *fname);

extern void code_for_otl_preambles(FILE *otl_out, char *fname);

void generate_call_for_remote(char *itfcname, Operation *op,
					  FILE *cout, FILE *hout);
void code_for_object_state (Interface *itfc, FILE *cout, char *fname, char
			    *fname_clean);  

void code_for_io_formats(Type_Description **typelist_array,
			 int typelist_size,
			 FILE *cout, FILE *hout);

void generate_io_formats_for_operations(char *itfcname, Operation *op,
					FILE *cout, FILE *hout);
void generate_io_formats_for_state(Interface *itfc, FILE *cout);

void gen_mirror_class_init(FILE* hout, FILE* cout, char *fname);
Type_Description* searchTypeDescription(char *name,
					Type_Description **typelist_array,
					int typelist_size);

void
dumpTypeList(Type_Description **typelist_array, int typelist_size);

subtype_list_t get_subtype_list_return(Type_Description **typelist_array,
				       int typelist_size,
				       Operation *op);
subtype_list_t get_subtype_list_all_ops(Type_Description **typelist_array,
				       int typelist_size,
				       Operation_list_cell *op_list);
subtype_list_t get_subtype_list_state(Type_Description **typelist_array,
				       int typelist_size,
				       Interface *itfc);
subtype_list_t get_subtype_list_op(Type_Description **typelist_array,
				   int typelist_size,
				   Operation *op);
void free_subtype_list(subtype_list_t list);
int count_subtype_list(subtype_list_t list);

int op_has_internal_return(Operation *op);
extern int is_object(TypeCode tp, char *type_name);
extern int
has_dynamic_substructure(char *typename, Type_Description **typelist_array,
			 int typelist_size);

extern int
is_string(char *typename, Type_Description **typelist_array,
	  int typelist_size);

#ifndef OUT
extern void OUT(int indent, FILE *cout, char *format, ...);
#endif
#endif


