/* File code_for_otl.c */

#include "unix_defs.h"
#include "code_generation.h"

void code_for_otl_ref_use(Interface *itfc, 
			  FILE *otl_out, FILE *hout, 
			  char *fname)
{
  Operation_list_cell *opl;

  fprintf(hout, "/* OTL related code for interface %s */\n", itfc->name);
  fprintf(hout, "extern cobs_result _COBS_OTL_build_virtual_table_%s(",
	  itfc->name);
  fprintf(hout, "object_ref);\n");
  fprintf(otl_out, "/* Code for interface %s */\n", itfc->name);
  fprintf(otl_out, "cobs_result _COBS_OTL_build_virtual_table_%s(",
	  itfc->name);
  fprintf(otl_out, "object_ref tmp)\n{\n");
  fprintf(otl_out, "  void (**vf_table) ();\n");
/*  fprintf(otl_out, "  assert(tmp != NULL);\n");*/
  fprintf(otl_out, "  vf_table=(void (**)())malloc(sizeof(vf_table[0])*%d);\n",
	  itfc->nb_of_operations);
  fprintf(otl_out, "  if (vf_table == NULL) {\n");
  fprintf(otl_out, "    printf(\"In _COBS_OTL_build_virtual_table_%s:",
	  itfc->name);
  fprintf(otl_out, " can't allocate vf_table\\n\");\n");
  fprintf(otl_out, "    return(COBS_NOMEMORY);\n");
  fprintf(otl_out, "  }\n");
  
  /* fill in virtual table */
  opl = itfc->op_list; 
  while (opl != NULL) {
    fprintf(otl_out, "  vf_table[COBS_method_id_%s_%s] =",itfc->name,
	    opl->op->name);
    fprintf(otl_out, "(void (*)())_COBS_through_pb_PACKED_%s_%s;\n", 
	    itfc->name, opl->op->name);
    opl=opl->next;
  }
  fprintf(otl_out,"  _COBS_init_objref(tmp, vf_table);\n");
  fprintf(otl_out,"  return(COBS_SUCCEED);\n");
  fprintf(otl_out, "} /* end of _COBS_OTL_build_virtual_table_%s */\n\n",
	  itfc->name);

}

void code_for_otl_preambles(FILE *otl_out, char *fname)
{
  fprintf(otl_out, "/* File %s_COBS_OTL_CODE_.c  */\n\n", fname);
  fprintf(otl_out, "#include <malloc.h>\n");
  fprintf(otl_out, "#include <otl.h>\n");
  fprintf(otl_out, "#include \"general.h\"\n");
  fprintf(otl_out, "#include \"%s_COBS_.h\"\n\n", fname);
  fprintf(otl_out, "\n");
}


