/*
 * File code_for_operations.c
 */

#include <stdio.h>
#include "assert.h"
#include "code_generation.h"
#include "config.h"
#include "unix_defs.h"
#ifndef _MSC_VER
#include <unistd.h>
#endif
#include <stdarg.h>


#ifdef DEBUGGING_LIST_SUBTYPES
static void test_list_subtypes(Type_Description **types_array,
			       int types_size, 
			       Operation *op, char *itfcname)
{
  subtype_list_t list;

  printf("Nested types for operation %s_%s:\n\t", itfcname,op->name);
  list = get_subtype_list_op(types_array, types_size, op);
  if (list==NULL) 
    printf("NONE\n");
  else 
    while (list != NULL) {
      printf("%s ", list->type->name);
      list = list->next;
    }
  printf("\n");
  if (op_has_return(op) {
  if (strcmp(op->rettypename, "CORBA_void") != 0) {
      list = get_subtype_list_return(types_array, types_size, op);
      printf("Nested types for return %s_%s:\n\t", itfcname,op->name);
      if (list==NULL) 
	  printf("NONE\n");
      else 
	  while (list != NULL) {
	      printf("%s ", list->type->name);
	      list = list->next;
	  }
      printf("\n");
  }
}
#endif

static
void pre_process_for_typedefs(Type_Description **typelist_array, 
			      int typelist_size, Operation *op);
			      
static
void generate_stub_for_remote(char *itfcname, Operation *op,
			      FILE *cout, FILE *hout);

static void
generate_impl_for_mirror(Operation *op, char *itfcname, char *mirror_name,
			 FILE *cout);

static Type_Description **typelist_array;
static int typelist_size;

int
op_has_internal_return(Operation *op)
{
    return ((strcmp(op->rettypename, "CORBA_void") != 0) ||
	    ((op->hasOUTarguments || op->hasINOUTarguments) && 
	     (op->arg_list != NULL)));
}

void
early_code_for_operations (Type_Description **types_array,
		     int types_size,
		     Interface *itfc, FILE *cout, FILE *hout, char *fname)
{
  Operation_list_cell *oplist = itfc->op_list;
  int               method_id = 0;

  typelist_array = types_array;
  typelist_size = types_size;


  /* generate method ids for operation */
  fprintf(hout, "/* Associating method names with numbers */\n");
  while (oplist != NULL) {
    oplist->op->id = method_id;    /* assign id to method in data struct*/
    fprintf(hout,"#define COBS_method_id_%s_%s   %d\n",
	    itfc->name, oplist->op->name, method_id++);
    oplist = oplist->next;
  }
  itfc->nb_of_operations = method_id;
  oplist = itfc->op_list;
  while (oplist != NULL) {
    /* The following will clean up argument information regarding
    ** their subtypes, i.e., if the subtype is a "typedef of", the
    ** actual type information is stored in the argument, so it can
    ** be used in the IOFormat generation.
    */
    pre_process_for_typedefs(typelist_array, typelist_size, oplist->op);
    generate_io_formats_for_operations(itfc->name, oplist->op, cout, hout);
    oplist = oplist->next;
  }
}

void
code_for_operations (Type_Description **types_array,
		     int types_size,
		     Interface *itfc, FILE *cout, FILE *hout, char *fname)
{
  Operation_list_cell *oplist = itfc->op_list;

  typelist_array = types_array;
  typelist_size = types_size;


  while (oplist != NULL) {
    generate_call_for_remote(itfc->name, oplist->op, cout, hout);
    generate_stub_for_remote(itfc->name, oplist->op, cout, hout);
    if (oplist->op->mirror) {
	generate_impl_for_mirror(oplist->op, itfc->name, itfc->mirror_name, 
				 cout);
    }
#ifdef DEBUGGING_LIST_SUBTYPES
    test_list_subtypes(types_array, types_size, oplist->op, itfc->name);
#endif
    oplist = oplist->next;
  }
}

static int
return_by_reference(Operation *op)
{
    switch (op->rettypecode) {
    case NT_array:
    case NT_sequence: 
	return 1;
    default:
	return 0;
    }
}

void
OUT(int indent, FILE *cout, char *format, ...)
{
    int i;
    va_list args;
    va_start(args, format);
    for(i=0;i<indent;i++)
	fprintf(cout, "    ");
    vfprintf(cout, format, args);
    va_end(args);
}

void generate_call_for_remote(char *itfcname, Operation *op,
					  FILE *cout, FILE *hout)
{
    int indent =0;
    Argument_list_cell	*alist = op->arg_list;
    Argument		*arg;

  /* Now generate the prototype of this call in .h, so object_create can
     use  it to allocate fields for methods information */

  if (strcmp(op->rettypename, "CORBA_void") != 0) {
      fprintf(hout, "extern %s %s%s_%s(%s self", 
	      op->rettypename,
	      return_by_reference(op) ? "*":"",
	      itfcname, op->name, itfcname);
  } else {
      fprintf(hout, "extern void %s_%s(%s self", 
	      itfcname, op->name, itfcname);
  }
  alist = op->arg_list;
  while (alist != NULL) {
      arg = alist->arg;
      switch (arg->direction) {
      case D_IN: {
	  switch (arg->typecode) {
	  case NT_enum:
	  case NT_pre_defined:
	  case NT_string:
	  case NT_interface:
	      fprintf(hout, ", %s %s", arg->typename, arg->name);
	      break;
	  case NT_struct:
	  case NT_sequence:
	  case NT_array:
	      fprintf(hout, ", %s *%s", arg->typename, arg->name);
	  default:
	      ;
	  }
	  break;
      }
      case D_OUT:
      case D_INOUT:
	  fprintf(hout, ", %s *%s", arg->typename, arg->name);
	  break;
      }
      alist = alist->next;
  }
  fprintf(hout, ", CORBA_Environment *ev);\n");

  if (strcmp(op->rettypename, "CORBA_void") != 0) {
      OUT(indent, cout, "extern %s %s%s_%s(%s self", op->rettypename,
	      return_by_reference(op) ? "*":"",
	      itfcname, op->name, itfcname);
  } else {
      OUT(indent, cout, "extern void %s_%s(%s self", 
	      itfcname, op->name, itfcname);
  }
  alist = op->arg_list;
  while (alist != NULL) {
      arg = alist->arg;
      switch (arg->direction) {
      case D_IN: {
	  switch (arg->typecode) {
	  case NT_enum:
	  case NT_pre_defined:
	  case NT_string:
	  case NT_interface:
	      fprintf(cout, ", %s %s", arg->typename, arg->name);
	      break;
	  case NT_struct:
	  case NT_sequence:
	  case NT_array:
	      fprintf(cout, ", %s *%s", arg->typename, arg->name);
	      break;
	  case NT_not_known:
	  default:
	    printf("typecode for argument %s is %d: not known\n", 
		   arg->typename, arg->typecode);
	    assert(1==0);      
	  }
	  break;
      }
      case D_OUT:
      case D_INOUT:
	  fprintf(cout, ", %s *%s", arg->typename, arg->name);
	  break; 
     }
      alist = alist->next;
  }
  fprintf(cout, ", CORBA_Environment *ev)\n");

  
  OUT(indent, cout, "{\n    /* invoke the %s method */\n\n", op->name);
  indent++;
  OUT(indent, cout, "attr_list method_attrs;\n");
  OUT(indent, cout, "otl_handle tmp_handle;\n");
  OUT(indent, cout, "IOEncodeVector encoded_params;\n");
  if ((op->hasINarguments || op->hasINOUTarguments) && (op->arg_list != NULL)) {
      OUT(indent, cout, "void *encode_free_block;\n");
  }
  if (op_has_internal_return(op)) {
      if (strcmp(op->rettypename, "CORBA_void") != 0) {
	  OUT(indent, cout, "%s %sreturn_value;\n", op->rettypename,
	      return_by_reference(op) ? "*" : "");
      }
      OUT(indent, cout, "void *return_block;\n");
      OUT(indent, cout, "%s_%s__return_p decoded_return = NULL;\n", itfcname, op->name);
      OUT(indent, cout, "int return_length = 0;\n");
  }
  OUT(indent, cout, "static atom_t otl_method_id_atom = 0;\n");
  OUT(indent, cout, "static atom_t otl_interface_atom = 0;\n");
  OUT(indent, cout, "static atom_t otl_self_atom = 0;\n");
  OUT(indent, cout, "static atom_t this_interface_atom = 0;\n");
  OUT(indent, cout, "static atom_t method_cache_atom = 0;\n");
  if (op->arg_list != NULL) {
      if (op->hasINarguments || op->hasINOUTarguments){
	  OUT(indent, cout, "struct %s_%s_params p;\n", itfcname, op->name);
      }
  }
  fprintf(cout, "\n");
  OUT(indent, cout, "if (otl_method_id_atom == 0) {\n");
  indent++;
  OUT(indent, cout, "otl_method_id_atom = attr_atom_from_string(\"OTL:METHOD_ID\");\n");
  OUT(indent, cout, "otl_interface_atom = attr_atom_from_string(\"OTL:INVOKE_INTERFACE\");\n");
  OUT(indent, cout, "this_interface_atom = attr_atom_from_string(\"%s\");\n", itfcname);
  OUT(indent, cout, "method_cache_atom = attr_atom_from_string(\"%s_%s_cache\");\n", itfcname, op->name);
  OUT(indent, cout, "otl_self_atom = attr_atom_from_string(\"OTL:OBJECT_SELF\");\n");
  indent--;
  OUT(indent, cout, "}\n");
  OUT(indent, cout, "if (query_attr(self->name_trans_cache, method_cache_atom,\n");
  OUT(indent, cout, "              NULL, (void**)&method_attrs) == 0) {\n");

  indent++;
  OUT(indent, cout, "method_attrs = create_attr_list();\n");

  /* has to set method id for the call */
  OUT(indent, cout, "add_attr(method_attrs, otl_method_id_atom,\n");
  OUT(indent, cout, "         Attr_Int4, (attr_value) COBS_method_id_%s_%s);\n",
	  itfcname, op->name);
  OUT(indent, cout, "add_attr(method_attrs, otl_interface_atom,\n");
  OUT(indent, cout, "         Attr_Atom, (attr_value) this_interface_atom);\n",
	  itfcname, op->name);
  
  OUT(indent, cout, "add_attr(self->name_trans_cache, method_cache_atom,\n");
  OUT(indent, cout, "         Attr_List, (attr_value) method_attrs);\n",
	  itfcname, op->name);
  
  indent--;
  OUT(indent, cout, "}\n");
  OUT(indent, cout, "if (otl_direct_call(self->obj_name, method_attrs)) {\n");
  indent++;
  OUT(indent, cout, "void **oldinstDataAddr = ev->instanceDataSaveAddr;\n");
  if (strcmp(op->rettypename, "CORBA_void") != 0) {
      OUT(indent, cout, "%s %stmp_ret;\n", op->rettypename,
	  return_by_reference(op) ? "*" : "");
  }
  OUT(indent, cout, "_IDLtoC_%s_attrib_struct *state;\n", itfcname);
  OUT(indent, cout, "query_attr(self->obj_name, otl_self_atom,\n");
  OUT(indent, cout, "           NULL, (void**)&state);\n\n");
  OUT(indent, cout, "if (oldinstDataAddr) *oldinstDataAddr = ev->instanceData;\n");
  OUT(indent, cout, "ev->instanceData = state->instanceData;\n");
  OUT(indent, cout, "ev->instanceDataSaveAddr = &state->instanceData;\n");
  if (strcmp(op->rettypename, "CORBA_void") != 0) {
      OUT(indent, cout, "tmp_ret = impl_%s_%s(self", itfcname, op->name);
  } else {
      OUT(indent, cout, "impl_%s_%s(self", itfcname, op->name);
  }
  alist = op->arg_list;  
  while (alist != NULL) {
      arg = alist->arg;
      fprintf(cout, ", %s", arg->name);
      alist = alist->next;
  }
  fprintf(cout, ", ev);\n");
  OUT(indent, cout, "state->instanceData = ev->instanceData;\n");
  OUT(indent, cout, "ev->instanceDataSaveAddr = oldinstDataAddr;\n");
  OUT(indent, cout, "if (oldinstDataAddr) ev->instanceData = *oldinstDataAddr;\n");
  if (strcmp(op->rettypename, "CORBA_void") != 0) {
      OUT(indent, cout, "return tmp_ret;\n");
  }
  indent--;
  OUT(indent, cout, "} else {\n");
  indent++;
  if ((op->hasINarguments || op->hasINOUTarguments) && (op->arg_list != NULL)) {
      subtype_list_t subtypes = get_subtype_list_op(typelist_array,
						    typelist_size, op);
      subtype_list_t tmp_list = subtypes;
      OUT(indent, cout, "if (%s_%s_format == NULL) {\n", itfcname, op->name);
      indent++;
      while(tmp_list != NULL) {
	  
	  if (tmp_list->type->code != NT_string) {
	      OUT(indent, cout, "otl_set_pbio_type(&%s_format, \"%s\", %s_fields);\n",
		  tmp_list->type->name, tmp_list->type->name, tmp_list->type->name);
	  }
	  tmp_list = tmp_list->next;
      }
      free_subtype_list(subtypes);
      OUT(indent, cout, "otl_set_pbio_type(&%s_%s_format, \"%s\", %s_%s_fields);\n",
	      itfcname, op->name, op->name, itfcname, op->name);
      indent--;
      OUT(indent, cout, "}\n");
      alist = op->arg_list;
      while (alist != NULL) {
	  arg = alist->arg;
	  switch (arg->direction) {
	  case D_IN: {
	      switch (arg->typecode) {
	      case NT_enum:
	      case NT_pre_defined:
	      case NT_string:
	      case NT_interface:
		  if (is_object(arg->typecode, arg->typename)) {
		      OUT(indent, cout, "p.%s = obj_ref_to_string(%s);\n",
			  arg->name, arg->name);
		  } else {
		      OUT(indent, cout, "p.%s = %s;\n", arg->name, arg->name);
		  }
		  break;
	      case NT_array:
		  OUT(indent, cout, "p._%s_size = sizeof(%s)/sizeof(%s);\n",
		      arg->name, arg->typename,
		      arg->type_parameters->tarray.basetypename);
		  OUT(indent, cout, "p.%s = (%s *)%s;\n", 
		      arg->name, arg->type_parameters->tarray.basetypename,
		      arg->name);
		  break;
	      case NT_struct:
	      case NT_sequence:
	      default:
		  OUT(indent, cout, "p.%s = *%s;\n", arg->name, arg->name);
		  break;
	      }
	      break;
	  }
	  case D_INOUT:
	      switch (arg->typecode) {
	      case NT_enum:
	      case NT_pre_defined:
	      case NT_string:
	      case NT_interface:
		  if (is_object(arg->typecode, arg->typename)) {
		      OUT(indent, cout, "p.%s = obj_ref_to_string(%s);\n",
			  arg->name, arg->name);
		  } else {
		      OUT(indent, cout, "p.%s = *%s;\n", arg->name, arg->name);
		  }
		  break;
	      case NT_array:
		  OUT(indent, cout, "p._%s_size = sizeof(%s)/sizeof(%s);\n",
		      arg->name, arg->typename,
		      arg->type_parameters->tarray.basetypename);
		  OUT(indent, cout, "p.%s = (%s *)%s;\n", 
		      arg->name, arg->type_parameters->tarray.basetypename,
		      arg->name);
		  break;
	      case NT_struct:
	      case NT_sequence:
	      default:
		  OUT(indent, cout, "p.%s = *%s;\n", arg->name, arg->name);
		  break;
	      }
	      break;
	  case D_OUT:
	      break;
	  }
	  alist = alist->next;
      }
  }
/*GSE  OUT(indent, cout, "if (!otl_protocol_invoke(self->obj_name)) {\n");
  indent++;
  OUT(indent, cout, "otl_alternative_invoke();\n");
  indent--;
  OUT(indent, cout, "} else {\n"); 
  indent++;*/
  if ((op->hasINarguments || op->hasINOUTarguments) && (op->arg_list != NULL)) {
      OUT(indent, cout, "encoded_params = otl_pbio_type_encodev(%s_%s_format, &p, &encode_free_block);\n",
	      itfcname, op->name);
  } else {
      OUT(indent, cout, "encoded_params = NULL;\n");
  }
   /* for debugging */
  OUT(indent, cout, "tmp_handle =\n");
  OUT(indent, cout, "    otl_invokev(self->obj_name,NULL,\n");
  OUT(indent, cout, "                method_attrs, &%s_obj_info_table, \n", 
      itfcname);
  if ((op->arg_list != NULL) && (op->hasINarguments || op->hasINOUTarguments)){
	  OUT(indent, cout, "                encoded_params, &p, sizeof(p));\n");
  } else {
      OUT(indent, cout, "                encoded_params, NULL, 0);\n");
  }
/*GSE  indent--;
  OUT(indent, cout, "}\n");*/
  OUT(indent, cout, "otl_wait(tmp_handle);\n");
  if ((op->hasINarguments || op->hasINOUTarguments) && (op->arg_list != NULL)) {
      OUT(indent, cout, "free(encode_free_block);\n");
  }
  OUT(indent, cout, "otl_get_exception(tmp_handle, ev);\n");
  if (op_has_internal_return(op)) {
      subtype_list_t subtypes = get_subtype_list_return(typelist_array,
							typelist_size, op);
      subtype_list_t tmp_list = subtypes;
      alist = op->arg_list;
      OUT(indent, cout, "otl_get_return_block(tmp_handle, &return_block, &return_length);\n");
      OUT(indent, cout, "if (return_length != 0) {\n");
      indent++;
      OUT(indent, cout, "if (return_length != -1) {\n");
      indent++;
      OUT(indent, cout, "if (!otl_check_conversion(return_block)) {\n");
      indent++;
      OUT(indent, cout, "otl_list_of_formats format_list[] = {\n");
      while(tmp_list != NULL) {
	  if (tmp_list->type->code != NT_string) {
	      OUT(indent, cout, "      {\"%s\", %s_fields},\n",
		  tmp_list->type->name, tmp_list->type->name);
	  }
	  tmp_list = tmp_list->next;
      }
      free_subtype_list(subtypes);
      OUT(indent, cout, "      {\"%s_return\", %s_%s_return_fields},\n",
	  op->name, itfcname, op->name);
      OUT(indent, cout, "      {NULL, NULL}\n");
      OUT(indent, cout, "  };\n\n");
      OUT(indent, cout, "otl_set_pbio_types(return_block, format_list);\n");
      indent--;
      OUT(indent, cout, "}\n");
      OUT(indent, cout, "decoded_return = otl_pbio_type_decode(return_block, return_length);\n");
      indent--;
      OUT(indent, cout, "} else {\n");
      indent++;
      OUT(indent, cout, "decoded_return = return_block;\n");
      indent--;
      OUT(indent, cout, "}\n");
      while (alist != NULL) {
	  arg = alist->arg;
	  if (arg->direction != D_IN) {
	      switch(arg->typecode) {
	      case NT_array:
	      case NT_sequence:
	      case NT_struct:
		  if (has_dynamic_substructure(arg->typename, typelist_array,
					       typelist_size)) {
		      OUT(indent, cout, "if (return_length != -1) {\n");
		      indent++;
		      OUT(indent, cout, "%s_Copy(%s, &decoded_return->%s);\n",
			  arg->typename, arg->name, arg->name);
		      indent--;
		      OUT(indent, cout, "} else {\n");
		      indent++;
		      OUT(indent, cout, "memcpy(%s, &decoded_return->%s, sizeof(%s));\n",
			  arg->name, arg->name, arg->typename);
		      indent--;
		      OUT(indent, cout, "}\n");
		  } else {
		      OUT(indent, cout, "memcpy(%s, &decoded_return->%s, sizeof(%s));\n",
			  arg->name, arg->name, arg->typename);
		  }
		  break;
	      case NT_string:
		  OUT(indent, cout, "if (decoded_return->%s != NULL) {\n", 
		      arg->name);
		  indent++;
		  OUT(indent, cout, "*%s = strdup(decoded_return->%s);\n",
		      arg->name, arg->name);
		  indent--;
		  OUT(indent, cout, "} else {\n");
		  indent++;
		  OUT(indent, cout, "*%s = NULL;\n", arg->name);
		  indent--;
		  OUT(indent, cout, "}\n");
		  break;
	      default:
		  if (is_object(arg->typecode, arg->typename)) {
		      OUT(indent, cout, "*%s = obj_ref_from_string(decoded_return->%s);\n",
			  arg->name, arg->name);
		  } else {
		      OUT(indent, cout, "*%s = decoded_return->%s;\n",
			  arg->name, arg->name);
		  }
	      }
	  }
	  alist = alist->next;
      }
      if (strcmp(op->rettypename, "CORBA_void") != 0) {
	  switch(op->rettypecode) {
	  case NT_string:
	      OUT(indent, cout, "if (decoded_return->return_value != NULL) {\n");
	      indent++;
	      OUT(indent, cout, "return_value = strdup(decoded_return->return_value);\n");
	      indent--;
	      OUT(indent, cout, "} else {\n");
	      indent++;
	      OUT(indent, cout, "return_value = NULL;\n");
	      indent--;
	      OUT(indent, cout, "}\n");
	      break;
	  case NT_array:
	  case NT_sequence:
	  case NT_struct:
	      if (has_dynamic_substructure(op->rettypename, typelist_array,
					   typelist_size)) {
		  OUT(indent, cout, "if (return_length != -1) {\n");
		  indent++;
		  OUT(indent, cout, "%s_Copy(&return_value, &decoded_return->return_value);\n",
		      op->rettypename);
		  indent--;
		  OUT(indent, cout, "} else {\n");
		  indent++;
		  OUT(indent, cout, "memcpy(&return_value, &decoded_return->return_value, sizeof(%s));\n",
		      op->rettypename);
		  indent--;
		  OUT(indent, cout, "}\n");
	      } else {
		  OUT(indent, cout, "memcpy(&return_value, &decoded_return->return_value, sizeof(%s));\n",
		      op->rettypename);
	      }
	      break;
	  default:
	      if (is_object(op->rettypecode, op->rettypename)) {
		  OUT(indent, cout, "return_value = (%s)obj_ref_from_string(decoded_return->return_value);\n", op->rettypename);
	      } else {
		  OUT(indent, cout, "return_value = decoded_return->return_value;\n");
	      }
	  }
      }
      OUT(indent, cout, "free(decoded_return);\n");
      indent--;
      if (strcmp(op->rettypename, "CORBA_void") != 0) {
	  OUT(indent, cout, "} else {\n");
	  indent++;
	  OUT(indent, cout, "memset(&return_value, 0, sizeof(return_value));\n");
	  indent--;
      }
      OUT(indent, cout, "}\n");
      OUT(indent, cout, "otl_free_handle(tmp_handle);\n");
      if (strcmp(op->rettypename, "CORBA_void") != 0) {
	  OUT(indent, cout, "return return_value;\n");
      } else {
	  OUT(indent, cout, "return;\n");
      }
  } else {
      OUT(indent, cout, "otl_free_handle(tmp_handle);\n");
  }
  indent--;
  OUT(indent, cout, "}\n");
  indent--;
  fprintf(cout, "}\n\n");
}

static
void generate_stub_for_remote(char *itfcname, Operation *op,
					  FILE *cout, FILE *hout)
{
    int indent = 0;
    Argument_list_cell	*alist = op->arg_list;
    Argument		*arg;

  /* Now generate the prototype of this call in .h, so object_create can
     use  it to allocate fields for methods information */

  if (strcmp(op->rettypename, "CORBA_void") != 0) {
      fprintf(hout, "extern %s %simpl_%s_%s(%s self", op->rettypename, 
	      return_by_reference(op) ? "*" : "",
	      itfcname, op->name, itfcname);
  } else {
      fprintf(hout, "extern void impl_%s_%s(%s self", itfcname, op->name,
	      itfcname);
  }
  while (alist != NULL) {
      arg = alist->arg;
      switch (arg->direction) {
      case D_IN: {
	  switch (arg->typecode) {
	  case NT_enum:
	  case NT_pre_defined:
	  case NT_string:
	  case NT_interface:
	      fprintf(hout, ", %s %s", arg->typename, arg->name);
	      break;
	  case NT_struct:
	  case NT_sequence:
	  case NT_array:
	  default:
	      fprintf(hout, ", %s *%s", arg->typename, arg->name);
	  }
	  break;
      }
      case D_OUT:
      case D_INOUT:
	  fprintf(hout, ", %s *%s", arg->typename, arg->name);
	  break;
      }
      alist = alist->next;
  }
  fprintf(hout, ", CORBA_Environment *ev);\n");

  fprintf(hout, "extern void STUB_%s_%s(void *self, void *pblock, int plen, IOEncodeVector pvector, otl_handle handle);\n",
	  itfcname, op->name);
  fprintf(cout, "extern void STUB_%s_%s(self, pblock, plen, pvector, handle)\n",
	  itfcname, op->name);
  fprintf(cout, "void *self;\n");
  fprintf(cout, "void *pblock;\n");
  fprintf(cout, "int plen;\n");
  fprintf(cout, "IOEncodeVector pvector;\n");
  fprintf(cout, "otl_handle handle;\n");

  
  fprintf(cout, "{\n    /* handle the %s method */\n\n", op->name);
  indent++;
  OUT(indent, cout, "object_ref_struct this_obj_ref;\n");
  OUT(indent, cout, "CORBA_Environment *ev = otl_ev_handle(handle);\n");
  OUT(indent, cout, "void **oldinstDataAddr = ev->instanceDataSaveAddr;\n");
  alist = op->arg_list;  
  while (alist != NULL) {
      arg = alist->arg;
      if (is_object(arg->typecode, arg->typename)) {
	  OUT(indent, cout, "%s tmp_%s;\n",
	      arg->typename, arg->name);
      }
      alist = alist->next;
  }
  if (op_has_internal_return(op)) {
      OUT(indent, cout, "struct %s_%s__return internal_return;\n", 
	  itfcname, op->name);
      OUT(indent, cout, "IOEncodeVector encoded_return;\n");
      OUT(indent, cout, "void *free_block;\n");
  }
  if (op->hasINarguments || op->hasINOUTarguments) {
      subtype_list_t subtypes = get_subtype_list_op(typelist_array,
						    typelist_size, op);
      subtype_list_t tmp_list = subtypes;
      OUT(indent, cout, "struct %s_%s_params *p;\n\n", itfcname, op->name);
      OUT(indent, cout, "if (plen == 0) {\n");
      indent++;
      OUT(indent, cout, "/* We have a local pblock! */\n");
      OUT(indent, cout, "otl_copy_local_pb((void**)&p, handle);\n");
      indent--;
      OUT(indent, cout, "} else {\n");
      indent++;
      OUT(indent, cout, "if (!otl_check_conversion(pblock)) {\n");
      indent++;
      OUT(indent, cout, "otl_list_of_formats format_list[] = {\n");
      
      while(tmp_list != NULL) {
	  if (tmp_list->type->code != NT_string) {
	      OUT(indent, cout, "    {\"%s\", %s_fields},\n",
		  tmp_list->type->name, tmp_list->type->name);
	  }
	  tmp_list = tmp_list->next;
      }
      free_subtype_list(subtypes);
      OUT(indent, cout, "  {\"%s\", %s_%s_fields},\n", op->name,
	      itfcname, op->name);
      OUT(indent, cout, "  {NULL, NULL}};\n");
      OUT(indent, cout, "otl_set_pbio_types(pblock, format_list);\n");
      indent--;
      OUT(indent, cout, "}\n");
      OUT(indent, cout, "p = otl_pbio_type_decode(pblock, plen);\n");
      indent--;
      OUT(indent, cout, "};\n\n");
  }
  OUT(indent, cout, "this_obj_ref.obj_name = otl_get_name(handle);\n");
  OUT(indent, cout, "this_obj_ref.name_trans_cache = create_attr_list();\n");
  OUT(indent, cout, "this_obj_ref.method_specific_cache = otl_get_cache(handle);\n");
  alist = op->arg_list;  
  while (alist != NULL) {
      arg = alist->arg;
      if (arg->direction != D_OUT) {
	  if (is_object(arg->typecode, arg->typename)) {
	      OUT(indent, cout, "tmp_%s = obj_ref_from_string(p->%s);\n",
		  arg->name, arg->name);
	  }
      }
      alist = alist->next;
  }
  OUT(indent, cout, "if (oldinstDataAddr) *oldinstDataAddr = ev->instanceData;\n");
  OUT(indent, cout, "ev->instanceData = ((_IDLtoC_%s_attrib_struct*)self)->instanceData;\n", itfcname);
  OUT(indent, cout, "ev->instanceDataSaveAddr = &((_IDLtoC_%s_attrib_struct*)self)->instanceData;\n", itfcname);
  if (strcmp(op->rettypename, "CORBA_void") != 0) {
      OUT(indent, cout, "{\n");
      indent++;
      OUT(indent, cout, "%s %sreturn_value;\n", op->rettypename,
	      return_by_reference(op) ? "*" : "");
      OUT(indent, cout, "return_value = impl_%s_%s(&this_obj_ref", itfcname, op->name);
  } else {
      OUT(indent, cout, "impl_%s_%s(&this_obj_ref", itfcname, op->name);
  }
  alist = op->arg_list;  
  while (alist != NULL) {
      arg = alist->arg;
      switch (arg->direction) {
      case D_INOUT:
      case D_IN: {
	  switch (arg->typecode) {
	  case NT_interface:
	  case NT_pre_defined:
	  if (is_object(arg->typecode, arg->typename)) {
	      fprintf(cout, ", %stmp_%s", (arg->direction == D_INOUT) ? "&":"",
		      arg->name);
	      break;
	  }
	  /* falling through */
	  case NT_enum:
	  case NT_string:
	      fprintf(cout, ", %sp->%s", (arg->direction == D_INOUT) ? "&":"",
		      arg->name);
	      break;
	  case NT_array:
	      fprintf(cout, ", (%s *) p->%s", arg->typename, arg->name);
	      break;
	  case NT_struct:
	  case NT_sequence:
	  default:
	      fprintf(cout, ", &p->%s", arg->name);
	  }
	  break;
      }
      case D_OUT:
	  switch (arg->typecode) {
	  case NT_interface:
	  case NT_pre_defined:
	  if (is_object(arg->typecode, arg->typename)) {
	      fprintf(cout, ", &tmp_%s", arg->name);
	      break;
	  }
	  /* falling through */
	  case NT_enum:
	  case NT_string:
	      fprintf(cout, ", &internal_return.%s", arg->name);
	      break;
	  case NT_array:
	      fprintf(cout, ", (%s *) &internal_return.%s", arg->typename, arg->name);
	      break;
	  case NT_struct:
	  case NT_sequence:
	  default:
	      fprintf(cout, ", &internal_return.%s", arg->name);
	  }
	  break;
      }
      alist = alist->next;
  }
  fprintf(cout, ", ev);\n");
  OUT(indent, cout, "((_IDLtoC_%s_attrib_struct*)self)->instanceData = ev->instanceData;\n", itfcname);
  OUT(indent, cout, "ev->instanceDataSaveAddr = oldinstDataAddr;\n");
  OUT(indent, cout, "if (oldinstDataAddr) ev->instanceData = *oldinstDataAddr;\n");
  if (strcmp(op->rettypename, "CORBA_void") != 0) {
      switch(op->rettypecode) {
      case NT_array:
	  OUT(indent, cout, "internal_return._return_size = sizeof(%s)/sizeof(%s);\n",
	      op->rettypename, op->rettype_parameters->tarray.basetypename);
	  OUT(indent, cout, "internal_return.return_value = (%s*)return_value;\n",
	      op->rettype_parameters->tarray.basetypename);

	  break;
      default:
	  if (is_object(op->rettypecode, op->rettypename)) {
	      OUT(indent, cout, "internal_return.return_value = obj_ref_to_string(return_value);\n");
	  } else {
	      OUT(indent, cout, "internal_return.return_value = %sreturn_value;\n",
		  return_by_reference(op) ? "*" : "");
	      if (return_by_reference(op)) {
		  OUT(indent, cout, "free(return_value);\n");
	      }
	  }
      }
      indent--;
      OUT(indent, cout, "}\n");
  }
  if (op_has_internal_return(op)) {
      subtype_list_t subtypes = get_subtype_list_return(typelist_array,
							typelist_size, op);
      subtype_list_t tmp_list = subtypes;
      OUT(indent, cout, "if (%s_%s_return_format == NULL) {\n", 
	      itfcname, op->name);
      indent++;
      while(tmp_list != NULL) {
	  if (tmp_list->type->code != NT_string) {
	      OUT(indent, cout, "otl_set_pbio_type(&%s_format, \"%s\", %s_fields);\n",
		  tmp_list->type->name, tmp_list->type->name, tmp_list->type->name);
	  }
	  tmp_list = tmp_list->next;
      }
      free_subtype_list(subtypes);
      OUT(indent, cout, "otl_set_pbio_type(&%s_%s_return_format, \"%s_return\", %s_%s_return_fields);\n",
	      itfcname, op->name, op->name, itfcname, op->name);
      indent--;
      OUT(indent, cout, "}\n");
      /* assign out parameters to internal return block */
      alist = op->arg_list;  
      while (alist != NULL) {
	  arg = alist->arg;
	  switch (arg->direction) {
	  case D_INOUT:{
	      if (is_object(arg->typecode, arg->typename)) {
		  OUT(indent, cout, "internal_return.%s = obj_ref_to_string(p->%s);\n", arg->name, arg->name);
	      } else {
		  OUT(indent, cout, "internal_return.%s = p->%s;\n", arg->name,
		      arg->name);
	      }
	  }
	  case D_OUT:
	      if (is_object(arg->typecode, arg->typename)) {
		  OUT(indent, cout, "internal_return.%s = obj_ref_to_string(tmp_%s);\n",
		      arg->name, arg->name);
	      }
	  case D_IN:
	      break;
	  }
	  alist = alist->next;
      }
      /* done with out parameters */
      OUT(indent, cout, "encoded_return = otl_pbio_type_encodev(%s_%s_return_format,\n",
	  itfcname, op->name);
      OUT(indent, cout, "                 &internal_return, &free_block);\n");
      OUT(indent, cout, "otl_set_return_vector(handle, &internal_return, encoded_return, (void*)free_block);\n");
  }
  if (op->hasINarguments || op->hasINOUTarguments) {
      OUT(indent, cout, "free(p);\n");
  }
  OUT(indent, cout, "otl_do_call_termination(handle);\n");
  if (return_by_reference(op)) {
      if (has_dynamic_substructure(op->rettypename, typelist_array,
				   typelist_size)) {
	  switch(op->rettypecode) {
	  case NT_array:
	      OUT(indent, cout, "%s_Free((%s *)internal_return.return_value);\n", 
		  op->rettypename, op->rettypename);
	      break;
	  default:
	      OUT(indent, cout, "%s_Free(&internal_return.return_value);\n", 
		  op->rettypename);
	  }
      } else {
	  OUT(indent, cout, "free(internal_return.return_value);\n");
      }
  }
  OUT(indent, cout, "free_attr_list(this_obj_ref.name_trans_cache);\n");
  indent--;
  fprintf(cout, "}\n\n");
  
}


static void
generate_impl_for_mirror(Operation *op, char *itfcname, char *mirror_name, FILE* cout)
{
    int indent = 0;
    Argument_list_cell *alist;
    Argument *arg;
    if (strcmp(op->rettypename, "CORBA_void") != 0) {
	fprintf(cout, "extern %s %simpl_%s_%s(%s self", op->rettypename,
		return_by_reference(op) ? "*":"",
		itfcname, op->name, itfcname);
    } else {
	fprintf(cout, "extern void impl_%s_%s(%s self", 
		itfcname, op->name, itfcname);
    }
    alist = op->arg_list;
    while (alist != NULL) {
	arg = alist->arg;
	switch (arg->direction) {
	case D_IN: {
	    switch (arg->typecode) {
	    case NT_enum:
	    case NT_pre_defined:
	    case NT_string:
	    case NT_interface:
		fprintf(cout, ", %s %s", arg->typename, arg->name);
		break;
	    case NT_struct:
	    case NT_sequence:
	    case NT_array:
		fprintf(cout, ", %s *%s", arg->typename, arg->name);
		break;
	    case NT_not_known:
	    default:
		printf("typecode for argument %s is %d: not known\n", 
		       arg->typename, arg->typecode);
		assert(1==0);      
	    }
	    break;
	}
	case D_OUT:
	case D_INOUT:
	    fprintf(cout, ", %s *%s", arg->typename, arg->name);
	    break;
	}
	alist = alist->next;
    }
    fprintf(cout, ", CORBA_Environment *ev)\n");

  
    fprintf(cout, "{\n    /* invoke the %s method in mirror */\n\n", op->name);
    indent++;
    OUT(indent, cout, "%s mirror_object;\n", mirror_name);
    OUT(indent, cout, "char *remote_object_str = NULL;\n");
    OUT(indent, cout, "static atom_t otl_remote_object_atom = 0;\n");
    OUT(indent, cout, "if (otl_remote_object_atom == 0) {\n");
    indent++;
    OUT(indent, cout, "otl_remote_object_atom = attr_atom_from_string(\"OTL:REMOTE_OBJECT_STR\");\n");
    indent--;
    OUT(indent, cout, "}\n");
    OUT(indent, cout, "if (!query_attr(self->obj_name,\n");
    OUT(indent, cout, "                otl_remote_object_atom,\n");
    OUT(indent, cout, "                NULL, (void**)&remote_object_str)) return;\n\n");
    OUT(indent, cout, "mirror_object = obj_ref_from_string(remote_object_str);\n");

    if (strcmp(op->rettypename, "CORBA_void") != 0) {
	OUT(indent, cout, "return ");
    } else {
	OUT(indent, cout, "");
    }
    fprintf(cout, "%s_%s(mirror_object", mirror_name, op->name);
    alist = op->arg_list;
    while (alist != NULL) {
	arg = alist->arg;
	fprintf(cout, ", %s", arg->name);
	alist = alist->next;
    }
    fprintf(cout, ", ev);\n");
    OUT(indent, cout, "otl_free_obj_ref(mirror_object);\n");
    indent--;
    OUT(indent, cout, "}\n");
}

static
void pre_process_for_typedefs(Type_Description **typelist_array, 
			      int typelist_size, Operation *op)
{
    Argument_list_cell *alist = op->arg_list;
    Type_Description   *t, *base_t;

    while (alist != NULL) { 
      t = searchTypeDescription(alist->arg->typename,
				typelist_array, typelist_size);
      if (t == NULL) {
	  fprintf(stderr, "internal error, type \"%s\" not found in typelist.\n", alist->arg->typename);
	  dumpTypeList(typelist_array, typelist_size);
	  /* Even if it is a type like CORBA_long, it will be found
	   * in the array of types, since the initialization of this array
	   * has been modified to include all primitive types 
	   */ 
	  exit(1);
      }
      if (t->code != NT_pre_defined)
	if (t->typedef_of != NULL) {
	  base_t = t;
	  while (base_t->typedef_of != NULL) 
	    base_t = base_t->typedef_of;
	  alist->arg->typename = base_t->name;
	  alist->arg->typecode = base_t->code;
	}
      alist = alist->next;
    }
}

