/*
 * File code_for_obj_creation.c
 */

#include "config.h"
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "unix_defs.h"
#if defined(__STDC__)
void *malloc(size_t);
void free(void*);
void *realloc(void*, size_t);
#else
void *malloc();
void free();
void *realloc();
#endif	/* __STDC__ */
#include "code_generation.h"
#include "assert.h"

#ifndef _MSC_VER
#include <unistd.h>
#endif
#include <stdarg.h>
void OUT(int indent, FILE *cout, char *format, ...);

extern void generate_object_exists(FILE *cout);
static int has_update_method(Interface *itfc);

typedef struct {
    char *mirror_name;
    char *class_name;
} *mirror_class_list_t;

static mirror_class_list_t mirror_class_list = NULL;
static int mirror_class_count = 0;
static void
add_to_mirror_class_list(char *mirror_name, char *class_name)
{
    if (mirror_class_list == NULL) {
	mirror_class_list = malloc(sizeof(mirror_class_list[0]));
    } else {
	mirror_class_list = 
	    realloc(mirror_class_list, 
		    sizeof(mirror_class_list[0]) * (mirror_class_count +1));
    }
    mirror_class_list[mirror_class_count].mirror_name = mirror_name;
    mirror_class_list[mirror_class_count].class_name = class_name;
    mirror_class_count++;
}

void
gen_mirror_class_init(FILE* hout, FILE* cout, char *fname)
{
    int i;
    fprintf(hout, "#ifdef __DATAEXCHANGE__H__\n");
    fprintf(hout, "extern void MOSS_%s_Init(DExchange de);\n", fname);
    fprintf(hout, "#endif\n");

    fprintf(cout, "extern void MOSS_%s_Init(DExchange de)\n{\n", fname);
    for (i=0; i< mirror_class_count; i++) {
	fprintf(cout, "    MOSS_add_class(\"%s\", (void*)(long) COBS_%s_object_create, \n",
		mirror_class_list[i].mirror_name,
		mirror_class_list[i].class_name);
	fprintf(cout, "                   (void*)(long)%s_handle_update);\n", 
		mirror_class_list[i].class_name);
    }
    fprintf(cout, "}\n\n");
}

/*
 * code_for_obj_creation 
 *
 * Generation of function COBS_I_object_creation, where I is an interface.
 */


void 
code_for_obj_creation(Type_Description **typelist_array, int typelist_size,
		      Interface *itfc, FILE *cout, FILE *hout, char *fname)
{
    Operation_list_cell     *opl = itfc->op_list;
    subtype_list_t subtypes, tmp_list;
    int                     i;

    /* first generating protype in ".h" file */
    fprintf(hout, "extern %s  COBS_%s_object_create();\n",
	    itfc->name, itfc->name);

    fprintf(hout, "extern %s  %s__Create(void *instanceData);\n",
	    itfc->name, itfc->name);

    opl = itfc->op_list;
    /* create object info blocks */
    fprintf(cout, "static method_info %s_method_info[] = {\n", itfc->name);
    for (i=0; i < itfc->nb_of_operations; i++, opl = opl->next) {
	fprintf(cout, "    {\"%s\", ",opl->op->name);
	if ((opl->op->hasINarguments || opl->op->hasINOUTarguments) && 
	    (opl->op->arg_list != NULL)) {
	    fprintf(cout, "%s_%s_fields, %s_%s_iiop, ",
		    itfc->name, opl->op->name, itfc->name, opl->op->name);
	} else {
	    fprintf(cout, "NULL, NULL, ");
	}
	if (op_has_internal_return(opl->op)) {
	    fprintf(cout, "%s_%s_return_fields, %s_%s_return_iiop},\n",
		    itfc->name, opl->op->name, itfc->name, opl->op->name);
	} else {
	    fprintf(cout, "NULL, NULL},\n");
	}
    }
    fprintf(cout, "{NULL, NULL, NULL, NULL, NULL}\n");
    fprintf(cout, "};\n");
    fprintf(cout, "\n%s COBS_%s_object_create()\n{\n",
	    itfc->name, itfc->name);
    fprintf(cout, "    return %s__Create(NULL);\n", itfc->name);
    fprintf(cout, "}\n\n");
    fprintf(cout, "void *%s_vf_table[] = {\n", itfc->name);
    opl = itfc->op_list;
    for (i=0; i < itfc->nb_of_operations; i++, opl = opl->next) {
	fprintf(cout, "    (void*)(long)STUB_%s_%s, \n", itfc->name, opl->op->name);
    }
    fprintf(cout, "    NULL\n};\n");

    subtypes =  get_subtype_list_all_ops(typelist_array, typelist_size,
					 itfc->op_list);
    fprintf(cout, "struct type_info_s %s_type_info_table[] = {\n", itfc->name);
    tmp_list = subtypes;
    i=0;

    while (subtypes != NULL) {
	if ((subtypes->type->code != NT_string) &&
	    (subtypes->type->typedef_of == NULL)) {
	    fprintf(cout, "    {\"%s\", %s_fields, %s_iiop},\n", 
		    subtypes->type->name, subtypes->type->name, 
		    subtypes->type->name);
	}
	i++;
	subtypes = subtypes->next;
    }
    fprintf(cout, "    {NULL, NULL, NULL}\n};\n");
    free(tmp_list);

    fprintf(cout, "struct obj_info_s %s_obj_info_table = {\n", itfc->name);
    fprintf(cout, "    (void (**)())%s_vf_table, %s_type_info_table, \n    NULL, %s_method_info};\n", itfc->name, itfc->name, itfc->name);

    /* now generate the code */
    fprintf(hout, "\n%s  %s__Create(void *instanceData);\n",
	    itfc->name, itfc->name);

    fprintf(cout, "\n%s %s__Create(instanceData)\nvoid *instanceData;\n{\n",
	    itfc->name, itfc->name);
    fprintf(cout, "    object_ref tmp;\n");
    fprintf(cout, "    static atom_t otl_dispatch_style_atom = 0;\n");
    fprintf(cout, "    static atom_t otl_vf_table_style_atom = 0;\n");
    fprintf(cout, "    static atom_t otl_vf_table_atom = 0;\n");
    fprintf(cout, "    static atom_t otl_is_threaded_atom = 0;\n");
    fprintf(cout, "    static atom_t otl_chan_handle_atom = 0;\n");
    fprintf(cout, "    static atom_t otl_self_atom = 0;\n");
    fprintf(cout, "    static atom_t otl_interface_atom = 0;\n");
    fprintf(cout, "    static atom_t this_interface_atom = 0;\n");
    fprintf(cout, "    static atom_t iiop_object_key_atom = 0;\n");
    fprintf(cout, "    attr_opaque *op;\n");
    fprintf(cout, "    _IDLtoC_%s_attrib_struct *state;\n", itfc->name);
    fprintf(cout, "    /* create a generic object reference on this machine */\n");
    fprintf(cout, "    tmp = otl_local_obj_ref();\n");
    fprintf(cout, "    /* allocate space for the vf table (could be done per class) */\n");
    
    fprintf(cout, "    add_ref_attr_list(tmp->obj_name);\n");
    fprintf(cout, "    state = malloc(sizeof(_IDLtoC_%s_attrib_struct));\n", 
	    itfc->name);
    fprintf(cout, "    memset(state, 0, sizeof(_IDLtoC_%s_attrib_struct));\n", 
	    itfc->name);
    fprintf(cout, "    state->instanceData = instanceData;\n");
    fprintf(cout, "    state->object_info = &%s_obj_info_table;\n", itfc->name);
    fprintf(cout, "    state->base_reference = tmp->obj_name;\n");
    fprintf(cout, "    if (otl_dispatch_style_atom == 0) {\n");
    fprintf(cout, "        /* first time here, init statics */\n");
    fprintf(cout, "        otl_dispatch_style_atom = attr_atom_from_string(\"OTL:DISPATCH_STYLE\");\n");
    fprintf(cout, "        otl_vf_table_style_atom = \n");
    fprintf(cout, "            attr_atom_from_string(\"OTL:DISPATCH_BY_VIRTUAL_FUNCTION\");\n");
    fprintf(cout, "        otl_vf_table_atom =\n");
    fprintf(cout, "            attr_atom_from_string(\"OTL:VIRTUAL_FUNCTION_TABLE_BASE\");\n");
    fprintf(cout, "        otl_self_atom = attr_atom_from_string(\"OTL:OBJECT_SELF\");\n");
    fprintf(cout, "        otl_chan_handle_atom =\n");
    fprintf(cout, "            attr_atom_from_string(\"OTL:MON_CHANNEL_HANDLE\");\n");
    fprintf(cout, "\n");
    fprintf(cout, "        /* all methods are threaded, so specify it here */\n");
    fprintf(cout, "        otl_is_threaded_atom = attr_atom_from_string(\"OTL:IS_THREADED\");\n");
    fprintf(cout, "        otl_interface_atom = attr_atom_from_string(\"OTL:OBJECT_INTERFACE\");\n");
    fprintf(cout, "        this_interface_atom = attr_atom_from_string(\"%s\");\n", itfc->name);
    fprintf(cout, "        iiop_object_key_atom = attr_atom_from_string(\"OTL:IIOP_OBJECT_KEY\");\n");
    fprintf(cout, "    }\n");
    fprintf(cout, "\n");
    fprintf(cout, "    add_attr(tmp->obj_name, otl_dispatch_style_atom, Attr_Atom,\n");
    fprintf(cout, "             (attr_value) otl_vf_table_style_atom);\n");
    fprintf(cout, "    add_attr(tmp->obj_name, otl_vf_table_atom, Attr_Int4,\n");
    fprintf(cout, "             (attr_value) %s_vf_table);\n", itfc->name);
    fprintf(cout, "    add_attr(tmp->obj_name, otl_is_threaded_atom, Attr_Int4,\n");
    fprintf(cout, "             (attr_value) 1);\n");
    fprintf(cout, "    add_attr(tmp->obj_name, otl_interface_atom, Attr_Atom,\n");
    fprintf(cout, "             (attr_value) this_interface_atom);\n");
    fprintf(cout, "    add_attr(tmp->obj_name, otl_self_atom, Attr_Int4,\n");
    fprintf(cout, "             (attr_value) state);\n");
    fprintf(cout, "    op = malloc(sizeof(attr_opaque));\n");
    fprintf(cout, "    op->length = 17;\n");
    fprintf(cout, "    op->buffer = malloc(17);\n");
    fprintf(cout, "    sprintf(op->buffer, \"%%16lx\", (unsigned long) state);\n");
    fprintf(cout, "    add_attr(tmp->obj_name, iiop_object_key_atom, Attr_Opaque, (attr_value)op);\n");
    fprintf(cout, "\n");
    if (mirror_objects) {
	fprintf(cout, "    {\n");
	fprintf(cout, "        extern DExchange otl_private_de;\n");
	fprintf(cout, "        EChannel chan = EChannel_create(otl_private_de);\n");
	fprintf(cout, "        ECSourceHandle handle = ECsource_subscribe(chan);\n");
	fprintf(cout, "        char *ref;\n");
	fprintf(cout, "        char *chan_id = ECglobal_id(chan);\n");
	fprintf(cout, "        add_attr(tmp->obj_name, otl_chan_handle_atom, Attr_Int4,\n");
	fprintf(cout, "                (attr_value) handle);\n");
	fprintf(cout, "        ref = obj_ref_to_string(tmp);\n");
	if (itfc->att_list != NULL) {
	    fprintf(cout, "        EChannel_subscribe_handler(chan, %s_subscribe_handler, tmp);\n",
		    itfc->name);
	}
	fprintf(cout, "        otl_mon_register_object(\"%s\", ref, chan_id);\n",
		itfc->name);
	fprintf(cout, "        free(ref); free(chan_id);\n");
	fprintf(cout, "    }\n");
    }
    fprintf(cout, "    return tmp;\n");
    fprintf(cout, "}\n");
    
    if (mirror_objects && (itfc->att_list != NULL)) {
	subtype_list_t subtypes = get_subtype_list_state(typelist_array,
							 typelist_size, 
							 itfc);
	subtype_list_t tmp_list = subtypes;
	int indent = 0;
	OUT(indent, cout, "static void %s_submit_state(event_handle, state)\n",
		itfc->name);
	OUT(indent, cout, "ECSourceHandle event_handle;\n");
	OUT(indent, cout, "_IDLtoC_%s_attrib_struct *state;\n", 
		itfc->name);
	OUT(indent, cout, "{\n");
	indent++;
	OUT(indent, cout, "IOEncodeVector encoded_statev;\n");
	OUT(indent, cout, "void *free_block;\n");
	OUT(indent, cout, "if (%s_state_format == NULL) {\n", 
		itfc->name);
	indent++;
	while(tmp_list != NULL) {
	    OUT(indent, cout, "otl_set_pbio_type(&%s_format, \"%s\", %s_fields);\n",
		    tmp_list->type->name, tmp_list->type->name, tmp_list->type->name);
	    tmp_list = tmp_list->next;
	}
	free_subtype_list(subtypes);
	OUT(indent, cout, "otl_set_pbio_type(&%s_state_format, \"%s_state\", %s_state_fields);\n", itfc->name, itfc->name, itfc->name);
	indent--;
	OUT(indent, cout, "}\n");
	OUT(indent, cout, "encoded_statev = otl_pbio_type_encodev(%s_state_format, state, &free_block);\n", itfc->name);
	OUT(indent, cout, "ECsubmit_eventV(event_handle, encoded_statev);\n");
	OUT(indent, cout, "free(free_block);\n");
	indent--;
	OUT(indent, cout, "}\n\n");

	OUT(indent, cout, "static void\n");
	OUT(indent, cout, "%s_subscribe_handler(int subscribe, int subscribe_count,\n",
		itfc->name);
	OUT(indent, cout, "                      void *client_data)\n");
	OUT(indent, cout, "{\n");
	indent++;
	OUT(indent, cout, "_IDLtoC_%s_attrib_struct *state;\n", itfc->name);
	OUT(indent, cout, "static atom_t otl_self_atom = 0;\n");
	OUT(indent, cout, "static atom_t otl_chan_handle_atom = 0;\n");
	OUT(indent, cout, "ECSourceHandle event_handle = NULL;\n");
	OUT(indent, cout, "%s o = (%s) client_data;\n", itfc->name,
		itfc->name);
	OUT(indent, cout, "if (otl_self_atom == 0) {\n");
	indent++;
	OUT(indent, cout, "otl_self_atom = attr_atom_from_string(\"OTL:OBJECT_SELF\");\n");
	OUT(indent, cout, "otl_chan_handle_atom =\n");
	OUT(indent, cout, "    attr_atom_from_string(\"OTL:MON_CHANNEL_HANDLE\");\n");
	indent--;
	OUT(indent, cout, "}\n");
	OUT(indent, cout, "query_attr(o->obj_name, otl_self_atom,\n");
	OUT(indent, cout, "           NULL, (void**)&state);\n\n");
	OUT(indent, cout, "query_attr(o->obj_name, otl_chan_handle_atom,\n");
	OUT(indent, cout, "           NULL, (void**)&event_handle);\n\n");
	OUT(indent, cout, "%s_submit_state(event_handle, state);\n",
		itfc->name);
	indent--;
	OUT(indent, cout, "}\n\n\n");
    }
    if (itfc->mirror_name != NULL) {
	Attribute_list_cell    *att_list;
	subtype_list_t subtypes, tmp_list;
	int indent = 0;

	add_to_mirror_class_list(itfc->mirror_name, itfc->name);
	OUT(indent, cout, "static void %s_handle_update(encoded_update, length, client_data)\n", 
		itfc->name);
	OUT(indent, cout, "void *encoded_update;\nint length;\nvoid *client_data;\n");
	OUT(indent, cout, "{\n");
	indent++;
	OUT(indent, cout, "_IDLtoC_%s_attrib_struct *state;\n", itfc->name);
	/*
	 * declaring the event structure as this rather than itfc->mirror_name
	 * is overkill.  Fields here are a superset of those in mirror_name.
	 */
	OUT(indent, cout, "_IDLtoC_%s_attrib_struct *event;\n", itfc->name);
	OUT(indent, cout, "%s object = (%s) client_data;\n", itfc->name,
		itfc->name);
	OUT(indent, cout, "static atom_t otl_self_atom = 0;\n");
	OUT(indent, cout, "if (otl_self_atom == 0) {\n");
	OUT(indent, cout, "    otl_self_atom = attr_atom_from_string(\"OTL:OBJECT_SELF\");\n");
	OUT(indent, cout, "}\n");
	OUT(indent, cout, "query_attr(object->obj_name, otl_self_atom,\n");
	OUT(indent, cout, "           NULL, (void**)&state);\n\n");
	
	subtypes = get_subtype_list_state(typelist_array,
					  typelist_size, itfc);
	tmp_list = subtypes;
	OUT(indent, cout, "if (!otl_check_conversion(encoded_update)) {\n");
	indent++;
	OUT(indent, cout, "otl_list_of_formats format_list[] = {\n");
	if (tmp_list != NULL) {
	    OUT(indent, cout, "/*\n");
	    OUT(indent, cout, " *  This is subtype list overkill.  The list for *this* interface,\n");
	    OUT(indent, cout, " *  rather than the mirrored interface.  Should be a superset of what we need.\n");
	    OUT(indent, cout, " */\n");
	}
	while(tmp_list != NULL) {
	    OUT(indent, cout, "    {\"%s\", %s_fields},\n",
		    tmp_list->type->name, tmp_list->type->name);
	    tmp_list = tmp_list->next;
	}
	free_subtype_list(subtypes);
	OUT(indent, cout, "    {\"%s_state\", %s_mirror_state_fields},\n",
		itfc->mirror_name, itfc->mirror_name);
	OUT(indent, cout, "    {NULL, NULL}\n");
	OUT(indent, cout, "};\n\n");
	OUT(indent, cout, "otl_set_pbio_types(encoded_update, format_list);\n");
	indent--;
	OUT(indent, cout, "}\n");
	OUT(indent, cout, "event = otl_pbio_type_decode(encoded_update, length);\n");
	att_list = itfc->att_list;
	while(att_list != NULL) {
	    Attribute *att = att_list->att;
	    if (att->mirror) {
		switch (att->typecode) {
		case NT_enum:
		case NT_pre_defined:
		case NT_interface:
		    /* In these three cases it is just a mere assignment */
		    OUT(indent, cout, "state->%s = event->%s;\n", att->name, 
			    att->name);
		    break;
		case NT_struct:   
		    OUT(indent, cout, "state->%s = event->%s;\n", att->name,
			    att->name);
		    break;
		case NT_string:
		    /* there may be allocation related to this ... it has to follow
		       IDL specification defined semantics */ 
		    fprintf(cout,"    COBS_assign_string( (char **)\n");
		    fprintf(cout,"\t&state->%s,", att->name);
		    fprintf(cout,"\n\t\t(char *) event->%s, %d);\n", att->name,
			    att->parameters->tstring.maximum);
		    break;
		case NT_sequence:
		    OUT(indent, cout, "{\n");
		    fprintf(cout,"\t%s *attv = ", att->typename);
		    fprintf(cout,"&state->%s;\n", att->name);
		    fprintf(cout,"\tCOBS_assign_sequence(\n");
		    fprintf(cout,"\t    (COBS_generic_sequence_struct *)attv,\n");
		    fprintf(cout,"\t    (COBS_generic_sequence_struct *)event->%s,\n", att->name);
		    fprintf(cout,"\t\tsizeof(%s));\n", 
			    att->parameters->tsequence.basetypename);
		    OUT(indent, cout, "}\n");
		    break;
		case NT_array:
		    OUT(indent, cout, "{\n");
		    fprintf(cout,"\t%s *attv = ", att->typename);
		    fprintf(cout,"&state->%s;\n", att->name);
		    fprintf(cout,"\tmemcpy(attv, event->%s, sizeof(%s));\n", 
			    att->name, att->typename);
		    OUT(indent, cout, "}\n");
		    break;
		default:
		    assert(FALSE);
		}
	    }
	    att_list = att_list->next;
	}
	OUT(indent, cout, "free(event);\n");
	if (has_update_method(itfc)) {
	    OUT(indent, cout, "{\n");
	    indent++;
	    OUT(indent, cout, "/* call update method */\n");
	    OUT(indent, cout, "call_handle handle = malloc(sizeof(*handle));\n");
	    OUT(indent, cout, "thr_thread_t thrd;\n");

	    OUT(indent, cout, "handle->dispatch_addr = impl_%s_update;\n",
		    itfc->name);
	    OUT(indent, cout, "COBS_init_Environment_object(&handle->ev);\n");
	    OUT(indent, cout, "handle->object = object;\n");
	    OUT(indent, cout, "thrd = thr_fork((void_arg_func)do_threaded_call, handle);\n");
	    OUT(indent, cout, "if (thrd == NULL) {\n");
	    OUT(indent, cout, "    printf(\"Fork failed!\\n\");\n");
	    OUT(indent, cout, "} else {\n");
	    OUT(indent, cout, "     thr_thread_detach(thrd);\n");
	    OUT(indent, cout, "}\n");
	    indent--;
	    OUT(indent, cout, "}\n");
	    indent--;
	}
	OUT(indent, cout, "}\n");
    }
}


static int
has_update_method(itfc)
Interface *itfc;
{
    Operation_list_cell     *opl = itfc->op_list;
    while (opl != NULL) {
	Operation *op = opl->op;
	if (strcmp(op->name, "update") == 0) {
	    if (!op->mirror && op->arg_list == NULL) {
		return 1;
	    }
	}
	opl = opl->next;
    }
    return 0;
}

extern
void code_for_early_decls(Interface *itfc, FILE *cout)
{
    static int done_already = 0;
    int indent = 0;
    if (mirror_objects && (itfc->att_list != NULL)) {
	OUT(indent, cout, "static void\n");
	OUT(indent, cout, "%s_submit_state ARGS((", itfc->name);
	OUT(indent, cout, "ECSourceHandle event_handle,\n");
	OUT(indent, cout, "\t\t\t_IDLtoC_%s_attrib_struct *state));\n", 
		itfc->name);
	OUT(indent, cout, "static void %s_subscribe_handler(int subscribe, int subscribe_count,\n",
		itfc->name);
	OUT(indent, cout, "                      void *client_data);\n\n\n");
	if (has_update_method(itfc) && !done_already) {
	    done_already++;
	    OUT(indent, cout, "\ntypedef struct call_handle_s {\n");
	    OUT(indent, cout, "    void (*dispatch_addr) ();\n");
	    OUT(indent, cout, "    object_ref object;\n");
	    OUT(indent, cout, "    CORBA_Environment ev;\n");
	    OUT(indent, cout, "} *call_handle;\n");
	    OUT(indent, cout, "\n");
	    OUT(indent, cout, "static void\n");
	    OUT(indent, cout, "do_threaded_call(handle)\n");
	    OUT(indent, cout, "call_handle handle;\n");
	    OUT(indent, cout, "{\n");
	    OUT(indent, cout, "    handle->dispatch_addr(handle->object, handle->ev);\n");
	    OUT(indent, cout, "    free(handle);\n");
	    OUT(indent, cout, "}    \n");
	    OUT(indent, cout, "\n");
	}
    }
}

void code_for_object_storage(Type_Description **typelist_array, 
			     int typelist_size,
			     Interface *itfc, FILE *cout)
{
    subtype_list_t subtypes, tmp_list;
    int indent = 0;

    if (itfc->att_list == NULL) return;

    OUT(indent, cout, "\nextern void\n");
    OUT(indent, cout, "%s_state_store(%s object, IOFile store_file, int write_flag)\n",
	    itfc->name, itfc->name);
    OUT(indent, cout, "{\n");
    indent++;
    OUT(indent, cout, "IOFormat state_format;\n");
    OUT(indent, cout, "_IDLtoC_%s_attrib_struct *state;\n", itfc->name);
    OUT(indent, cout, "static atom_t otl_self_atom = 0;\n");
    OUT(indent, cout, "if (otl_self_atom == 0) {\n");
    indent++;
    OUT(indent, cout, "otl_self_atom = attr_atom_from_string(\"OTL:OBJECT_SELF\");\n");
    indent--;
    OUT(indent, cout, "}\n");
    OUT(indent, cout, "query_attr(object->obj_name, otl_self_atom,\n");
    OUT(indent, cout, "           NULL, (void**)&state);\n\n");
    OUT(indent, cout, "state_format = get_IOformat_by_name(store_file, \"%s_state\");\n",
	    itfc->name);
    OUT(indent, cout, "if (write_flag && (state_format == NULL)) {\n");

    indent++;

    subtypes = get_subtype_list_state(typelist_array,
				      typelist_size, itfc);
    tmp_list = subtypes;
    while(tmp_list != NULL) {
	  if (tmp_list->type->code != NT_string) {
	      OUT(indent, cout, "if (get_IOformat_by_name(store_file, \"%s\") == NULL) \n",
		  tmp_list->type->name);
	      indent++;
	      OUT(indent, cout, "register_IOrecord_format(\"%s\",\n",
		  tmp_list->type->name);
	      OUT(indent, cout, "                          %s_fields, store_file);\n",
		  tmp_list->type->name);
	      indent--;
	  }
	  tmp_list = tmp_list->next;
    }
    OUT(indent, cout, "state_format = register_IOrecord_format(\"%s_state\", %s_state_fields,\n",
	    itfc->name, itfc->name);
    OUT(indent, cout, "                                        store_file);\n");
    indent--;
    OUT(indent, cout, "} else if (!write_flag && !has_conversion_IOformat(state_format)) {\n");
    indent++;
    tmp_list = subtypes;
    while(tmp_list != NULL) {
	if (tmp_list->type->code != NT_string) {
	    OUT(indent, cout, "set_IOconversion(store_file, \"%s\",\n",
		tmp_list->type->name);
	    OUT(indent, cout, "                 %s_fields, sizeof(%s));\n",
		tmp_list->type->name, tmp_list->type->name);
	}
	tmp_list = tmp_list->next;
    }
    free_subtype_list(subtypes);
    OUT(indent, cout, "set_IOconversion(store_file, \"%s_state\", %s_state_fields,\n",
	    itfc->name, itfc->name);
    OUT(indent, cout, "                 sizeof(_IDLtoC_%s_attrib_struct));\n",
	    itfc->name);
    indent--;
    OUT(indent, cout, "}\n");
    OUT(indent, cout, "if (write_flag) {\n");
    OUT(indent, cout, "    write_IOfile(store_file, state_format, state);\n");
    OUT(indent, cout, "} else {\n");
    OUT(indent, cout, "    read_IOfile(store_file, state);\n");
    OUT(indent, cout, "}\n");
    indent--;
    OUT(indent, cout, "}\n\n");
}

void code_for_object_state (Interface *itfc, FILE *cout, char *fname, char *fname_clean)
{
  FILE *state_f;
  char *state_n = (char *) malloc (strlen(fname)+1+strlen("_STATE_COBS_.h"));

  assert(state_n != NULL);
  strcpy(state_n, fname);
  strcat(state_n, "_STATE_COBS_.h");
  if ((state_f = fopen(state_n, "w")) == NULL) {
    printf("Can't open file %s to ouput attribute definition\n",
	   state_n);
    exit(1);
  }
  fprintf(state_f, "/* File %s_STATE_COBS_.h  */\n\n", fname);
  fprintf(state_f, "#ifndef %s_STATE_COBS__H\n", fname_clean);
  fprintf(state_f, "#define %s_STATE_COBS__H\n", fname_clean);
  /* adding to header _COBS_.h file definition for state access and
     state allocation */
  fprintf(state_f, "\n/* definitions related to object state */\n");
  fprintf(state_f, "#define %s_STATE(o,st) ((%s_state_struct *)o->state)->st\n",
	  itfc->name, itfc->name);
  fprintf(state_f, "/* defining state related routine */\n");
  /* IMPORTANT NOTE:
  ** The following solution (ie, defining "state_size" function inside
  ** this include file) is not a good idea, since of course multiple
  ** modules could be including this file, specially if the implementation
  ** of an object is spread into different files ...).
  **
  ** I will leave this suboptimal solution here. If the user wants to
  ** have its object implementation in many files, it can just define
  ** the STATE macro and the impl_defined_state_size routine himself,
  ** instead of including this automatically generated file
  */
  fprintf(state_f, 
	  "int %s_impl_defined_state_size(){\n",itfc->name);
  fprintf(state_f, "   return(sizeof(%s_state_struct));\n}\n\n", itfc->name);
  fprintf(state_f, "#endif\n");
  free(state_n);
  fclose(state_f);
}

