#if !defined(_USEFUL_H_)

#include "assert.h"
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_STRING_H
#include <string.h>
#else
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#endif
#include <sys/types.h>

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE (!FALSE)
#endif


/* Generic return vaules for functions. */
#ifndef FAILURE
#define SUCCESS 0
#define FAILURE (!SUCCESS)
#endif

#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus)
#ifndef ARGS
#define ARGS(args) args
#endif
#ifndef	NULL
/* 
 * NULL --
 *      Null pointer.
 */
#define NULL	((void *) 0)
#endif
#else
#ifndef ARGS
#define ARGS(args) (/*args*/)
#endif
#ifndef	NULL
/* 
 * NULL --
 *      Null pointer.
 */
#define NULL	0
#endif
#endif
extern int de_debug_flag;
extern int de_data_debug_flag;

#define DBG(de, f) 		{if ((de_debug_flag || de->debug_flag) && !de->no_debug_flag) fprintf(stderr,f);}
#define DBG1(de, f,a)	{if ((de_debug_flag || de->debug_flag) && !de->no_debug_flag) fprintf(stderr,f,a);}
#define DBG2(de, f,a,b)	{if ((de_debug_flag || de->debug_flag) && !de->no_debug_flag) fprintf(stderr,f,a,b);}
#define DBG3(de, f,a,b,c)	{if ((de_debug_flag || de->debug_flag) && !de->no_debug_flag) fprintf(stderr,f,a,b,c);}
#define DBG4(de, f,a,b,c,d)	{if ((de_debug_flag || de->debug_flag) && !de->no_debug_flag) fprintf(stderr,f,a,b,c,d);}
#define DBG5(de, f,a,b,c,d,e) {if ((de_debug_flag || de->debug_flag) && !de->no_debug_flag) fprintf(stderr,f,a,b,c,d,e);}
#define DBG6(de, f,a,b,c,d,e,g) {if ((de_debug_flag || de->debug_flag) && !de->no_debug_flag) fprintf(stderr,f,a,b,c,d,e,g);}
#define DDBG(de, f) 		{if ((de_data_debug_flag || de->data_debug_flag) && !de->no_debug_flag) fprintf(stderr,f);}
#define DDBG1(de, f,a)	{if ((de_data_debug_flag || de->data_debug_flag) && !de->no_debug_flag) fprintf(stderr,f,a);}
#define DDBG2(de, f,a,b)	{if ((de_data_debug_flag || de->data_debug_flag) && !de->no_debug_flag) fprintf(stderr,f,a,b);}
#define DDBG3(de, f,a,b,c)	{if ((de_data_debug_flag || de->data_debug_flag) && !de->no_debug_flag) fprintf(stderr,f,a,b,c);}
#define DDBG4(de, f,a,b,c,d)	{if ((de_data_debug_flag || de->data_debug_flag) && !de->no_debug_flag) fprintf(stderr,f,a,b,c,d);}
#define DDBG5(de, f,a,b,c,d,e) {if ((de_data_debug_flag || de->data_debug_flag) && !de->no_debug_flag) fprintf(stderr,f,a,b,c,d,e);}

/* autodetected by ./configure.  Add more ifdef's when you hit them */
#ifndef PUTENV_DEFINED
extern int putenv ARGS((const char *));
#endif
#ifndef STRDUP_DEFINED
extern char *strdup();
#endif
extern void perror();
#ifndef BZERO_DEFINED
extern int bzero ARGS((void *s, size_t n));
#endif
#ifndef PRINTF_DEFINED
extern int printf ARGS((const char *,...));
#endif
#ifndef FPRINTF_DEFINED
extern int fprintf ARGS((FILE *, const char *,...));
#endif
#ifndef SPRINTF_DEFINED
extern int sprintf ARGS((char *, const char *,...));
#endif
#ifndef SSCANF_DEFINED
extern int sscanf ARGS((const char *, const char *,...));
#endif
extern int atoi();
extern void *memset ARGS((void *, int, size_t));
extern int de_debug_flag;

#define _USEFUL_H_ 1
#endif				/* _USEFUL_H_ */
