/* 
 * Defns for sample UDP client/server programs
 */

#include "useful.h"
#ifndef HAVE_WINDOWS_H
#include <sys/socket.h>
#include <netinet/in.h>
#else
#include "windows.h"
#include "winsock.h"
#endif
#include "io.h"
#include "DE.h"

typedef struct _first_rec {
    int int_field;
    double dbl_field;
    char *str_field;
} First_rec, *First_rec_ptr;

typedef struct _Client_data {
    /* 
     * name_str and port used when explicit write issued; sock_addr used  
     * for forwarding 
     */
    char *name_str;
    int port;
    struct sockaddr_in sock_addr;
    int fd;			/* file descriptor for socket */
} Client_data, *Client_data_ptr;



extern int dg_startup ARGS((DExchange, DEPort, void **));
extern int dg_read ARGS((char **msg, int *max_buf_size,
			 void **client_data_p));
extern int dg_write ARGS((char *mesg, int msg_size, void **client_data));
extern void dg_shutdown ARGS((void *client_data));
extern int dg_get_new_cli ARGS((void **));
extern int dg_addrCmp ARGS((void *, void *));
