
#include "config.h"
#include "io.h"
#include "useful.h"
#include "DE.h"
#include <fcntl.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <string.h>
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#define sleep(x) Sleep(1000)
#endif

typedef struct _first_rec {
    int integer_field;
    double double_field;
    char char_field;
} first_rec, *first_rec_ptr;

static IOField field_list[] =
{
    {"integer field", "integer",
     sizeof(int), IOOffset(first_rec_ptr, integer_field)},
    {"double field", "float",
     sizeof(double), IOOffset(first_rec_ptr, double_field)},
    {"char field", "char",
     sizeof(char), IOOffset(first_rec_ptr, char_field)},
    {NULL, NULL, 0, 0}
};

typedef struct _second_rec {
    int integer_field;
    short short_field;
    long long_field;
    char *string;
    double double_field;
    char char_field;
} second_rec, *second_rec_ptr;

static IOField field_list2[] =
{
    {"integer field", "integer",
     sizeof(int), IOOffset(second_rec_ptr, integer_field)},
    {"short field", "integer",
     sizeof(short), IOOffset(second_rec_ptr, short_field)},
    {"long field", "integer",
     sizeof(long), IOOffset(second_rec_ptr, long_field)},
    {"string field", "string",
     sizeof(char *), IOOffset(second_rec_ptr, string)},
    {"double field", "float",
     sizeof(double), IOOffset(second_rec_ptr, double_field)},
    {"char field", "char",
     sizeof(char), IOOffset(second_rec_ptr, char_field)},
    {NULL, NULL, 0, 0}
};

typedef enum {
    Red_Stripe, Paulaner, Pilsner
} enum_type;

typedef struct _third_rec {
    int integer_field;
    long long_field;
    unsigned int uint_field;
    unsigned long ulong_field;
    char *string;
    double double_field;
    char *string2;
    char char_field;
    enum_type enum_field;
} third_rec, *third_rec_ptr;

static IOField field_list3[] =
{
    {"integer field", "integer",
     sizeof(int), IOOffset(third_rec_ptr, integer_field)},
    {"long field", "integer",
     sizeof(long), IOOffset(third_rec_ptr, long_field)},
    {"uint field", "unsigned integer",
     sizeof(int), IOOffset(third_rec_ptr, uint_field)},
    {"ulong field", "unsigned integer",
     sizeof(long), IOOffset(third_rec_ptr, ulong_field)},
    {"string field", "string",
     sizeof(char *), IOOffset(third_rec_ptr, string)},
    {"double field", "float",
     sizeof(double), IOOffset(third_rec_ptr, double_field)},
    {"string field2", "string",
     sizeof(char *), IOOffset(third_rec_ptr, string2)},
    {"char field", "char",
     sizeof(char), IOOffset(third_rec_ptr, char_field)},
    {"enum field", "enumeration",
     sizeof(enum_type), IOOffset(third_rec_ptr, enum_field)},
    {NULL, NULL, 0, 0}
};

#define ARRAY_SIZE 14

typedef struct _fourth_rec {
    long ifield;
    int int_array[ARRAY_SIZE];
    double double_array[2][2];
} fourth_rec, *fourth_rec_ptr;

static IOField field_list4[] =
{
    {"ifield", "integer",
     sizeof(long), IOOffset(fourth_rec_ptr, ifield)},
    {"int_array", IOArrayDecl(integer, ARRAY_SIZE),
     sizeof(int) * ARRAY_SIZE, IOOffset(fourth_rec_ptr, int_array[0])},
    {"double field", "float[2][2]",
     sizeof(double) * 4, IOOffset(fourth_rec_ptr, double_array[0][0])},
    {NULL, NULL, 0, 0}
};

typedef struct _later_rec {
    int integer_field;
    char *string;
    double double_field;
} later_rec, *later_rec_ptr;

static IOField later_field_list[] =
{
    {"integer field", "integer",
     sizeof(int), IOOffset(later_rec_ptr, integer_field)},
    {"string field", "string",
     sizeof(char *), IOOffset(later_rec_ptr, string)},
    {"double field", "float",
     sizeof(double), IOOffset(later_rec_ptr, double_field)},
    {NULL, NULL, 0, 0}
};

typedef struct _later_rec2 {
#if SIZEOF_LONG_LONG > SIZEOF_LONG
    long long integer_field;
#else
    long integer_field;
#endif
    double double_field;
    char *string;
} later_rec2, *later_rec2_ptr;

int
main(argc, argv)
int argc;
char *argv[];
{
    DExchange de;
    DEPort dep;

    IOFile iofile;
    IOFormat first_rec_ioformat, second_rec_ioformat, third_rec_ioformat;
    IOFormat fourth_rec_ioformat, later_ioformat;
    first_rec rec1;
    second_rec rec2;
    third_rec rec3;
    fourth_rec rec4;
    later_rec rec5;
    int i;

    first_rec array1[10];
    printf("Write Client <%s,%d>\n", argv[1], atoi(argv[2]));
    de = DExchange_create();
    dep = DExchange_initiate_conn(de, argv[1], atoi(argv[2]), TRUE);
    if (dep == NULL) {
	fprintf(stderr, "connection to <%s, %d> failed\n",
		argv[1], atoi(argv[2]));
	exit(1);
    }
    printf("Client-server connection succeeded\n");
    iofile = DEport_to_port(dep);
    first_rec_ioformat = register_IOrecord_format("first format",
						  field_list,
						  iofile);
    second_rec_ioformat = register_IOrecord_format("string format",
						   field_list2,
						   iofile);
    third_rec_ioformat = register_IOrecord_format("two string format",
						  field_list3,
						  iofile);
    fourth_rec_ioformat = register_IOrecord_format("internal array format",
						   field_list4,
						   iofile);
    write_comment_IOfile(iofile, "this is a comment in the file");
    memset((char *) &rec1, 0, sizeof(rec1));
    rec1.integer_field = 14;
    rec1.double_field = 2.717;
    rec1.char_field = 'A';
    if (!write_IOfile(iofile, first_rec_ioformat, &rec1))
	printf("write failed\n");
    sleep(1);
    memset((char *) &rec2, 0, sizeof(rec2));
    rec2.integer_field = 14;
    rec2.short_field = 27;
    rec2.long_field = 987234;
    rec2.string = "toasters";
    rec2.double_field = 2.717;
    rec2.char_field = 'A';
    if (!write_IOfile(iofile, second_rec_ioformat, &rec2))
	printf("write failed\n");
    sleep(1);
    memset((char *) &rec2, 0, sizeof(rec2));
    rec2.integer_field = 14;
    rec2.short_field = 27;
    rec2.long_field = 987234;
    rec2.string = NULL;
    rec2.double_field = 2.717;
    rec2.char_field = 'A';
    if (!write_IOfile(iofile, second_rec_ioformat, &rec2))
	printf("write failed\n");
    sleep(1);
    memset((char *) &rec1, 0, sizeof(rec1));
    rec1.integer_field = 17;
    rec1.double_field *= 3.0;
    rec1.char_field = 'B';
    write_IOfile(iofile, first_rec_ioformat, &rec1);
    sleep(1);
    memset((char *) &rec2, 0, sizeof(rec2));
    rec2.integer_field = 14;
    rec2.short_field = 27;
    rec2.long_field = 987234;
    rec2.string = NULL;
    rec2.double_field = 2.717;
    rec2.char_field = 'A';
    if (!write_IOfile(iofile, second_rec_ioformat, &rec2))
	printf("write failed\n");
    sleep(1);
    memset((char *) &rec1, 0, sizeof(rec1));
    rec1.integer_field *= 2;
    rec1.double_field *= 2.717;
    rec1.char_field = 'C';
    write_comment_IOfile(iofile, "this is another comment in the file");
    write_IOfile(iofile, first_rec_ioformat, &rec1);
    sleep(1);
    memset((char *) &rec3, 0, sizeof(rec3));
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.uint_field = 0xf7e589ce;	/* = 4159015374 */
#if SIZEOF_LONG==64
    rec3.ulong_field = 0xf7e589ceec9dd130;
#else
    rec3.ulong_field = 0xec9dd130;	/* = 3969765680 */
#endif
    rec3.string = "toasters";
    rec3.double_field = 2.717;
    rec3.string2 = "jambalaya";
    rec3.char_field = 'A';
    rec3.enum_field = Red_Stripe;
    if (!write_IOfile(iofile, third_rec_ioformat, &rec3))
	printf("write failed\n");
    sleep(1);
    later_ioformat = register_IOrecord_format("later format",
					      later_field_list,
					      iofile);
    memset((char *) &rec3, 0, sizeof(rec3));
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.string = NULL;
    rec3.double_field = 2.717;
    rec3.string2 = "jambalaya";
    rec3.char_field = 'A';
    rec3.enum_field = Paulaner;
    if (!write_IOfile(iofile, third_rec_ioformat, &rec3))
	printf("write failed\n");
    sleep(1);
    memset((char *) &rec3, 0, sizeof(rec3));
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.string = "toasters";
    rec3.double_field = 2.717;
    rec3.string2 = NULL;
    rec3.char_field = 'A';
    rec3.enum_field = Pilsner;
    if (!write_IOfile(iofile, third_rec_ioformat, &rec3))
	printf("write failed\n");
    sleep(1);
    memset((char *) &rec3, 0, sizeof(rec3));
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.string = NULL;
    rec3.double_field = 2.717;
    rec3.string2 = NULL;
    rec3.char_field = 'A';
    rec3.enum_field = Red_Stripe;
    if (!write_IOfile(iofile, third_rec_ioformat, &rec3))
	printf("write failed\n");
    sleep(1);
    memset((char *) &rec5, 0, sizeof(rec5));
    rec5.integer_field = 9872346;
    rec5.string = "Irvine";
    rec5.double_field = 3.14159265358797323;
    if (!write_IOfile(iofile, later_ioformat, &rec5))
	printf("write failed\n");
    memset((char *) &rec3, 0, sizeof(rec3));
    rec3.integer_field = 14;
    rec3.long_field = 987234;
    rec3.string = "toasters";
    rec3.double_field = 2.717;
    rec3.string2 = "jambalaya";
    rec3.char_field = 'A';
    rec3.enum_field = Pilsner;
    if (!write_IOfile(iofile, third_rec_ioformat, &rec3))
	printf("write failed\n");
    memset((char *) &rec2, 0, sizeof(rec2));
    rec2.integer_field = 14;
    rec2.short_field = 27;
    rec2.long_field = 987234;
    rec2.string = "the end";
    rec2.double_field = 2.717;
    rec2.char_field = 'A';
    if (!write_IOfile(iofile, second_rec_ioformat, &rec2))
	printf("write failed\n");
    for (i = 0; i < 10; i++) {
	memset((char *) &array1[i], 0, sizeof(array1[i]));
	array1[i].integer_field = 2 * i * i;
	array1[i].double_field = 2.717 * i * i;
	array1[i].char_field = 'D' + i;
    }
    if (!write_array_IOfile(iofile, first_rec_ioformat, &array1[0],
			    10, sizeof(array1[0])))
	printf("write failed\n");

    memset((char *) &rec4, 0, sizeof(rec4));
    for (i = 0; i < ARRAY_SIZE; i++) {
	rec4.int_array[i] = 297 + i;
    }
    rec4.double_array[0][0] = 1.0;
    rec4.double_array[0][1] = 2.0;
    rec4.double_array[1][0] = 3.0;
    rec4.double_array[1][1] = 4.0;
    rec4.ifield = -rec4.int_array[ARRAY_SIZE - 1];
    if (!write_IOfile(iofile, fourth_rec_ioformat, &rec4))
	printf("write failed\n");
    printf("after all writes, closing connection \n");
    DExchange_close(de);
    DExchange_free(de);
    return 0;
}
