
#ifndef DOC
/* 
 * the includes below are just to get the typedefs for printf and sscanf
 * on machines where they are not in stdio.h 
 */
#include "config.h"
#include "useful.h"
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#endif
#endif
#include <stdio.h>
#include "DE.h"
#include "comm_group.h"

typedef struct _rec {
    int integer_field;
    char *string_field;
} rec, *rec_ptr;

static IOField field_list[] =
{
    {"integer_field", "integer", sizeof(int), IOOffset(rec_ptr, integer_field)},
    {"string_field", "string", sizeof(char *), IOOffset(rec_ptr, string_field)},
    {NULL, NULL, 0, 0}};

int
main(argc, argv)
int argc;
char **argv;
{
    DExchange de = DExchange_create();
    DEPort dep;
    int i, rec_format_id;
    comm_group_return groups;

    char *host = "aquarius.cc.gatech.edu";
    int port = 12345;

    DExchange_register_format(de, "my format", field_list);
    rec_format_id = DEget_format_id(de, "my format");

    switch (argc) {
    case 1:
	groups = matching_comm_groups("test", "test");
	dep = DExchange_initiate_first(de, groups, 0);
	if (dep == NULL) {
	    fprintf(stderr, "No host or port specified, but no group \"test,test\" found.\n");
	    exit(1);
	}
	break;
    case 2:
	host = argv[1];
	dep = DExchange_initiate_conn(de, host, port, TRUE);
	break;
    case 3:
    default:
	host = argv[1];
	sscanf(argv[2], "%d", &port);
	dep = DExchange_initiate_conn(de, host, port, TRUE);
	break;
    }
    if (dep == NULL) {
	fprintf(stderr, "No contact at host \"%s\", port %d.\n", host, port);
	exit(1);
    }
    for (i = 0; i < 10; i++) {
	rec buf;
	buf.integer_field = i;
	buf.string_field = "Hello World!";
	DEport_write_data(dep, rec_format_id, (char *) &buf);
#ifndef DOC
#ifndef HAVE_WINDOWS_H
	sleep(1);		/* take some time */
#else
	Sleep(1000);		/* this sleep in millisecs */
#endif
#else
	sleep(1);		/* take some time */
#endif
    }
    DExchange_shutdown_connection(de, dep, SHUTDOWN_SYSTEM, "");
    DEport_close(dep);
    DExchange_close(de);
    DExchange_free(de);
    return 0;
}
