/* 
 * upd_write_cli.c
 */
#include "config.h"
#include <fcntl.h>
#include "udp_cli.h"

#define MAXLINE 512

static IOField field_list[] =
{
{"int_field", "integer", sizeof(int), IOOffset(First_rec_ptr, int_field)},
    {"dbl_field", "float", sizeof(double), IOOffset(First_rec_ptr, dbl_field)},
    {"str_field", "string", sizeof(char *), IOOffset(First_rec_ptr, str_field)},
    {NULL, NULL, 0, 0}
};

int
main(argc, argv)
int argc;
char *argv[];
{

    First_rec rec1;
    int format_id = 0;
    int count = 1;
    char sendline[MAXLINE];
    DExchange de;
    DEPort dep;
    Client_data client_data;
    int done = FALSE;

    if (argc < 3) {
	printf("\t\tBad arg count:  progName <receiver_hostname> <receiver_port>\n");
	exit(1);
    } else {
	client_data.name_str = argv[1];
	client_data.port = atoi(argv[2]);
    }
    de = DExchange_create();

    /* 
     * init_conn does a handshake, but not an atomic one.  It is
     * possible that handlers will be called between the time this
     * routine is invoked and the time the port becomes available for
     * writing.  
     */
    dep = DExchange_dg_init_conn(de, FALSE, dg_startup,
				 (void *) &client_data);
    DExchange_register_format(de, "first format", field_list);
    format_id = DEget_format_id(de, "first format");

    /* DEport_set_format_block(dep, "first format", FALSE); */

    while (!done) {
	fgets(sendline, MAXLINE, stdin);
	sendline[strlen(sendline) - 1] = '\0';	/* remove newline char */
	if (!strcmp(sendline, ".")) {
	    done = TRUE;
	} else {
	    /* build message to pbio encode before sending */
	    memset((char *) &rec1, 0, sizeof(rec1));
	    rec1.int_field = 14 * count;
	    rec1.dbl_field = 2.717 * count++;
	    rec1.str_field = sendline;
	    DEport_write_data(dep, format_id, &rec1);
	}
    }
    DExchange_shutdown_connection(de, dep, SHUTDOWN_CONNECTION_INPUT,
				  "write client shutdown");
    DEport_close(dep);
    return 0;
}
