/* 
 * udp_read_cli.c
 *
 */
#include "config.h"
#include <fcntl.h>
#include "udp_cli.h"

#define MAXMESG 2048
#define NUM_TESTS 3

static IOField field_list[] =
{
{"int_field", "integer", sizeof(int), IOOffset(First_rec_ptr, int_field)},
    {"dbl_field", "float", sizeof(double), IOOffset(First_rec_ptr, dbl_field)},
    {"str_field", "string", sizeof(char *), IOOffset(First_rec_ptr, str_field)},
    {NULL, NULL, 0, 0}
};

IOFormat first_rec_ioformat;
static DExchange de;

static void
shutdown_handler(DExchange de, DEPort dep)
{
    printf("\t\tReader received shutdown message.  Shutting down.\n");
    DEport_close(dep);
    DExchange_close(de);
    DExchange_free(de);
    exit(0);
}

static int
first_rec_handler(DExchange de, DEPort dep, int format_id,
		  void *data, int data_length, void *client_data)
{
    First_rec *recvptr;

    recvptr = (First_rec *) data;
    printf("\t\tReader received:  %d, %g, %s\n", recvptr->int_field,
	   recvptr->dbl_field, recvptr->str_field);
    return 0;
}

void
show_usage(char *progname)
{
    fprintf(stderr, "usage: %s <hostname> <port>\n",
	    progname);
    fprintf(stderr, "\twhere\n");
    fprintf(stderr, "\t\t<hostname> is host from which to receive messages\n");
    fprintf(stderr, "\t\t<port> is the accompanying port\n");
}				/* end usage() */

int
main(argc, argv)
int argc;
char *argv[];
{
    Client_data client_data;
    DEPort dep;

    if (argc < 3) {
	show_usage(argv[0]);
	exit(1);
    } else {
	client_data.name_str = argv[1];
	client_data.port = atoi(argv[2]);
    }
    de = DExchange_create();

    /* 
     * init_conn does a handshake, but not an atomic one.  It is
     * possible that handlers will be called between the time this
     * routine is invoked and the time the port becomes available for
     * writing.  
     */

    dep = DExchange_dg_init_conn(de, FALSE, dg_startup, (void *) &client_data);

    DExchange_register_format(de, "first format", field_list);
    DExchange_register_function(de, "first format", first_rec_handler, NULL);
    DExchange_register_close_handler(de, shutdown_handler);
    /* DEport_set_format_block(dep, "first format", FALSE);     */

    while (1) {
	DExchange_poll_and_handle(de, TRUE);
    }
}
