#ifndef DOC
#include "config.h"
#include "io.h"
#include "DE.h"
#include "channel.h"
#include "gen_thread.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
static EChannel chan;

static void handler(event, length, client_data)
void *event;
int length;
void *client_data;
{
    printf("In the %s handler, thread (%lx), event is %ld\n", client_data, 
	   (long)thr_thread_self(), *(long *) event);
}

static void thread1_func(de)
DExchange de;
{
    ECsink_subscribe_context(chan, handler, "first", de);
    while(1) {	/* block waiting for events */
	DExchange_poll_and_handle(de, 1);
    }
}	

static void thread2_func(de)
DExchange de;
{
    ECsink_subscribe_context(chan, handler, "second", de);
    while(1) {	/* handle events every 10 sec */
	sleep(10);
	DExchange_poll_and_handle(de, 0);
    }
}	

void main()
{
    DExchange de, de1, de2;
    ECSourceHandle handle;
    long a = time(NULL) % 100;

    gen_pthread_init();
    de = DExchange_create();
    DExchange_listen(de, 0);
    chan = EChannel_create(de);
    handle = ECsource_subscribe(chan);

    de1 = DExchange_create();
    thr_fork((void_arg_func)thread1_func, (void*)de1);
    de2 = DExchange_create();
    thr_fork((void_arg_func)thread2_func, (void*)de2);

    while (1) {
	long *event = malloc(sizeof(long));
	*event = a++;
	printf("I'm submitting %ld\n", *event);
	ECsubmit_general_event(handle, event, sizeof(*event), free);
	DExchange_poll_and_handle_timeout(de, 0, 500000);
    }
}
