
#ifndef DOC
/* 
 * the includes below are just to get the typedefs for printf and sscanf
 * on machines where they are not in stdio.h 
 */
#include "config.h"
#include "useful.h"
#endif
#include <stdio.h>
#include "DE.h"

typedef struct _rec {
    int integer_field;
    char *string_field;
} rec, *rec_ptr;

static IOField field_list[] =
{
    {"integer_field", "integer", sizeof(int), IOOffset(rec_ptr, integer_field)},
    {"string_field", "string", sizeof(char *), IOOffset(rec_ptr, string_field)},
    {NULL, NULL, 0, 0}};

int
handler(de, dep, format_id, data, data_length, user_data)
DExchange de;
DEPort dep;
int format_id;
void *data;
int data_length;
void *user_data;
{
    rec_ptr recv = (rec_ptr) data;
    printf(" Received %d, %s\n", recv->integer_field, recv->string_field);
    return 1;			/* return value is ignored for functions */
}

int
main()
{
    DExchange de = DExchange_create();
    DEPort dep;

    DExchange_register_format(de, "my format", field_list);
    DExchange_register_function(de, "my format", handler, NULL);
    dep = DExchange_initiate_conn(de, "host.domain.org", 12345, TRUE);
    DEport_set_format_block(dep, "my format", FALSE);
    while (1) {
	DExchange_poll_and_handle(de, TRUE);
    }
}
