


#ifndef DOC
/* 
 * the includes below are just to get the typedefs for printf and sscanf
 * on machines where they are not in stdio.h 
 */
#include "config.h"
#include "useful.h"

#endif
#include <stdio.h>
#include "DE.h"
#include "comm_group.h"

typedef struct _rec {
    int integer_field;
    char *string_field;
} rec, *rec_ptr;

static IOField field_list[] =
{
    {"integer_field", "integer", sizeof(int), IOOffset(rec_ptr, integer_field)},
    {"string_field", "string", sizeof(char *), IOOffset(rec_ptr, string_field)},
    {NULL, NULL, 0, 0}};


int
main(argc, argv)
int argc;
char **argv;
{
    DExchange de = DExchange_create();
    DEPort dep;
    comm_group_return groups;
    char *host = "aquarius.cc.gatech.edu";
    int port = 12345;

    DExchange_register_format(de, "my format", field_list);
    switch (argc) {
    case 1:
	groups = matching_comm_groups("test", "test");
	dep = DExchange_initiate_first(de, groups, FALSE);
	if (dep == NULL) {
	    fprintf(stderr, "No host or port specified, but no group \"test,test\" found.\n");
	    exit(1);
	}
	break;
    case 2:
	host = argv[1];
	dep = DExchange_initiate_conn(de, host, port, FALSE);
	break;
    case 3:
    default:
	sscanf(argv[2], "%d", &port);
	host = argv[1];
	dep = DExchange_initiate_conn(de, host, port, FALSE);
	break;
    }
    if (dep == NULL) {
	fprintf(stderr, "No contact at host \"%s\", port %d.\n", host, port);
	exit(1);
    }
    while (1) {
	rec_ptr recv;
	int rcvd_format;
	recv = (rec_ptr) DEport_read_data(dep, &rcvd_format);
	printf(" Received %d, %s\n", recv->integer_field, recv->string_field);
    }
}
