

#include "config.h"
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#define sleep(x) Sleep(1000*x)
#else
#include <sys/time.h>
#endif
#include "io.h"
#ifndef NO_DERIVED
#include "ecl.h"
#endif
#include "DE.h"
#include "gen_thread.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <signal.h>
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#include <process.h>
#define srand48(s) srand(s)
double drand48() { return (((double)rand())/((double)RAND_MAX)); }
long lrand48(){ return rand(); }
#define kill(x,y) 
#else
extern double drand48();
extern long lrand48();
void srand48 ARGS((long seedval));
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/uio.h>
#include <fcntl.h>
#endif
#include "useful.h"

#ifndef NO_DERIVED
static int quiet = 0;


static int do_regression_master_test();

typedef struct _complex_rec {
    double r;
    double i;
} complex, *complex_ptr;

static IOField complex_field_list[] =
{
    {"r", "double", sizeof(double), IOOffset(complex_ptr, r)},
    {"i", "double", sizeof(double), IOOffset(complex_ptr, i)},
    {NULL, NULL, 0, 0}
};

typedef struct _simple_rec {
    int integer_field;
    short short_field;
    long long_field;
    complex complex_field;
    double double_field;
    char char_field;
    int scan_sum;
} simple_rec, *simple_rec_ptr;

static IOField simple_field_list[] =
{
    {"integer_field", "integer",
     sizeof(int), IOOffset(simple_rec_ptr, integer_field)},
    {"short_field", "integer",
     sizeof(short), IOOffset(simple_rec_ptr, short_field)},
    {"long_field", "integer",
     sizeof(long), IOOffset(simple_rec_ptr, long_field)},
    {"complex_field", "complex",
     sizeof(complex), IOOffset(simple_rec_ptr, complex_field)},
    {"double_field", "float",
     sizeof(double), IOOffset(simple_rec_ptr, double_field)},
    {"char_field", "char",
     sizeof(char), IOOffset(simple_rec_ptr, char_field)},
    {"scan_sum", "integer",
     sizeof(int), IOOffset(simple_rec_ptr, scan_sum)},
    {NULL, NULL, 0, 0}
};

static DEFormat simple_format_list[] =
{
    {"complex", complex_field_list},
    {NULL, NULL},
};

#define REPEAT_COUNT 10

static int global_cond;
static DExchange global_de = NULL;

static
void
typed_handler(vevent, client_data)
void *vevent;
void *client_data;
{
    simple_rec_ptr event = vevent;
    long sum = 0, scan_sum = 0;
    sum += event->integer_field % 100;
    sum += event->short_field % 100;
    sum += event->long_field % 100;
    sum += ((int)(event->complex_field.r * 100.0)) % 100;
    sum += ((int)(event->complex_field.i * 100.0)) % 100;
    sum += ((int)(event->double_field * 100.0)) % 100;
    sum += event->char_field;
    sum = sum % 100;
    scan_sum = event->scan_sum;
    if (sum != scan_sum) {
	printf("Received record checksum does not match. expected %d, got %d\n",
	       (int)sum, (int)scan_sum);
    }
    if (!quiet || (sum != scan_sum)) {
	printf("In the handler, event data is :\n");
	printf("	integer_field = %d\n", event->integer_field);
	printf("	short_field = %d\n", event->short_field);
	printf("	long_field = %ld\n", event->long_field);
	printf("	complex_field.r = %g\n", event->complex_field.r);
	printf("	complex_field.i = %g\n", event->complex_field.i);
	printf("	double_field = %g\n", event->double_field);
	printf("	char_field = %c\n", event->char_field);
	printf("	scan_sum = %d\n", event->scan_sum);
    }
    if (client_data != NULL) {
	int tmp = *((int*)client_data);
	if (tmp > 0) {
	    *((int*)client_data) = tmp - 1;
	}
	if (*((int*)client_data) == 0) {
	    DECondition_signal(global_de, global_cond);
	}
    }
}

static int regression = 0;

static void
do_source_side(de, chan, done_flag, count)
DExchange de;
EChannel chan;
int *done_flag;
int count;
{
#ifndef USE_PTHREADS
#endif
}

char *filter = "{\
    long sum = 0;\
    output.integer_field = lrand48() % 100;\n\
    sum = sum + output.integer_field % 100;\n\
    output.short_field = (lrand48());\n\
    sum = sum + output.short_field % 100;\n\
    output.long_field = (lrand48());\n\
    sum = sum + output.long_field % 100;\n\
\
    output.complex_field.r = drand48();\n\
    sum = sum + ((int)(output.complex_field.r * 100.0)) % 100;\n\
    output.complex_field.i = drand48();\n\
    sum = sum + ((int)(output.complex_field.i * 100.0)) % 100;\n\
\
    output.double_field = drand48();\n\
    sum = sum +((int)(output.double_field * 100.0)) % 100;\n\
    output.char_field = lrand48() % 128;\n\
    sum = sum + output.char_field;\n\
    sum = sum % 100;\n\
    output.scan_sum = sum;\n\
    return 1;\n\
}\0\0";

static int local_function();
static ecl_extern_entry externs[] = 
{
    {"printf", (void*)(long)printf},
    {"local_function", (void*)(long)local_function},
    {"lrand48", (void*)(long)lrand48},
    {"drand48", (void*)(long)drand48},
    {NULL, NULL}
};

static char extern_string[] = "int printf(string format, ...);\n\
int local_function();\n\
long lrand48();\n\
double drand48();";

static int stop_poll_thread = 0;
#ifdef USE_PTHREADS
static int
poll_thread(de)
void *de;
{
    while (!stop_poll_thread) {
	DExchange_poll_and_handle((DExchange)de, 1);
    }
    return 0;
}
#endif

int
main(argc, argv)
int argc;
char **argv;
{
    EChannel chan;
    double r = drand48();
    int consumer = 0;
    int both = 0;
    int regression_master = 1;
    DExchange de;

    srand48(1);
    if (argc <= 1) {
	/* 
	 * we're the first guy, create a couple of event channel and 
	 * print out the IDs. 
	 */
	ECproto proto;
	ecl_parse_context proto_context;


#ifdef USE_PTHREADS
	gen_pthread_init();
#endif
	de = DExchange_create();
	DExchange_listen(de, 0);
#ifdef USE_PTHREADS
	thr_fork(poll_thread, de);
#endif

	srand48(1);
	proto_context = new_ecl_parse_context();
	ecl_assoc_externs(proto_context, externs);
	ecl_parse_for_context(extern_string, proto_context);

	proto = ECproto_create(de, proto_context);
    
	if (!quiet) printf("  proto ID is %s\n", ECproto_id(proto));

	de_data_debug_flag = 1;
	de_debug_flag = 1;
	sleep(1200);
    }
    while (argv[1] && (argv[1][0] == '-')) {
	if (argv[1][1] == 'c') {
	    r = .9;
	    regression_master = 0;
	} else if (argv[1][1] == 's') {
	    r = 0;
	    regression_master = 0;
	} else if (argv[1][1] == 'b') {
	    both++;
	    regression_master = 0;
	} else if (argv[1][1] == 'q') {
	    quiet++;
	} else if (argv[1][1] == 'r') {
	    regression++;
	    quiet++;
	}
	argv++;
    }
    if (regression && regression_master) {
	return do_regression_master_test();
    }
    global_de = de = DExchange_create();
    DExchange_listen(de, 0);
    consumer = (r > 0.5);
    if (!quiet) printf("r is %g\n", r);
    if (both) {
	EChannel chan2;
	chan = EChannel_open(de, argv[1]);
	chan2 = EChannel_open(de, argv[1]);
	(void) ECsink_typed_subscribe(chan, simple_field_list, 
				      simple_format_list,
				      typed_handler, NULL);
	if (!quiet) printf("chan is %lx, chan2 is %lx\n", (long)chan, (long)chan2);
	/* do source side forever */
	do_source_side(de, chan, NULL, -1);
    } else if (consumer) {
	int repeat_count = REPEAT_COUNT;
	ECSinkHandle handle;
	EChannel new_chan;
	if (!quiet) printf("I'm a consumer\n");
	if (!quiet) printf("filter is:\n%s", filter);
	new_chan = ECproto_derive_periodic(de, argv[1], filter, 
					   simple_field_list, 
					   simple_format_list,
					   1000000);
	global_cond = DECondition_get(de, NULL);

	handle = ECsink_typed_subscribe(new_chan, simple_field_list,
					simple_format_list,
					typed_handler, 
					regression ? &repeat_count : NULL);
	DECondition_wait(de, global_cond);

	ECcancel_sink_subscribe(handle);
	sleep(2);
	EChannel_destroy(new_chan);
	DExchange_close(de);
	DExchange_free(de);
    } else {
	if (!quiet) printf("I'm a supplier\n");
	chan = EChannel_open(de, argv[1]);
	do_source_side(de, chan, NULL, -1);
    }
    return 0;
}

static
pid_t
run_subprocess(args, channel_id)
char **args;
{
#ifdef HAVE_WINDOWS_H
    int child;
    child = _spawnv(_P_NOWAIT, "./proto_test.exe", args);
    if (child == -1) {
	perror("spawnv");
    }
    return child;
#else
    pid_t child = fork();
    if (child == 0) {
	/* I'm the child */
	if (execv(args[0], args) == -1) {
	    perror("execv");
	}
    }
    return child;
#endif
}

static pid_t sink_proc = 0;

static void
fail_and_die(signal)
int signal;
{
    fprintf(stderr, "Channel test failed to complete in reasonable time\n");
    if (sink_proc != 0) {
	kill(sink_proc, 9);
    }
    exit(1);
}

#ifndef PRINTF_DEFINED
extern int printf();
#endif

static int 
local_function()
{
    printf("In local function\n");
    return 1;
}

static int
do_regression_master_test()
{
#ifndef NO_DERIVED
    DExchange de;
    ECproto proto;
    EChannel new_chan;
    ecl_parse_context proto_context;

#ifdef HAVE_WINDOWS_H
    SetTimer(NULL, 5, 1000, (TIMERPROC) fail_and_die);
#else
    struct sigaction sigact;
    sigact.sa_flags = 0;
    sigact.sa_handler = fail_and_die;
    sigemptyset(&sigact.sa_mask);
    sigaddset(&sigact.sa_mask, SIGALRM);
    sigaction(SIGALRM, &sigact, NULL);
    alarm(300);
#endif

#ifdef USE_PTHREADS
    gen_pthread_init();
#endif

    global_de = de = DExchange_create();
    DExchange_listen(de, 0);

#ifdef USE_PTHREADS
    thr_fork(poll_thread, de);
#endif

    srand48(1);
    proto_context = new_ecl_parse_context();
    ecl_assoc_externs(proto_context, externs);
    ecl_parse_for_context(extern_string, proto_context);

    proto = ECproto_create(de, proto_context);
    
    if (!quiet) printf("  proto ID is %s\n", ECproto_id(proto));

    {
	int repeat_count = REPEAT_COUNT;
	ECSinkHandle handle;
	/* local tests */

	if (!quiet) printf("filter is:\n%s", filter);
	new_chan = ECproto_derive_periodic(de, ECproto_id(proto), filter, 
				   simple_field_list, simple_format_list, 1000000);
	global_cond = DECondition_get(de, NULL);

	handle = ECsink_typed_subscribe(new_chan, simple_field_list,
					simple_format_list, typed_handler,
					&repeat_count);
	DECondition_wait(de, global_cond);

	if (repeat_count != 0) {
	    fprintf(stderr, "Not all in-process events delivered, test 1\n");
	} else {
	    if (quiet < 2) 
		fprintf(stderr, "Passed in-process protochannel tests\n");
	}	
	ECcancel_sink_subscribe(handle);
	EChannel_destroy(new_chan);
    }

    /* multiple process tests */
    {
	char *args[] = {"./proto_test", "-r", "-c", NULL, NULL};
	int wait_status;
	int exit_state;

	args[sizeof(args)/sizeof(char*) -2] = ECproto_id(proto);
	sink_proc = run_subprocess(args);

#ifndef HAVE_WINDOWS_H
	while ((wait_status = waitpid(sink_proc, &exit_state, WNOHANG)) == 0) {
#ifndef USE_PTHREADS
	    DExchange_poll_and_handle_timeout(de, 0, 100000);
#else 
	    sleep(1);
#endif
	}
	if (wait_status == -1) {
	    perror("waitpid");
	}
	if (WIFEXITED(exit_state)) {
	    if (WEXITSTATUS(exit_state) == 0) {
		if (quiet < 2) 
		    printf("Passed single remote sink test\n");
	    } else {
		printf("Single remote sink exit with status %d\n",
		       WEXITSTATUS(exit_state));
	    }
	} else if (WIFSIGNALED(exit_state)) {
	    printf("Single remote sink died with signal %d\n",
		   WTERMSIG(exit_state));
	}

#else /* windows.h */
	exit_state = STILL_ACTIVE;
	while (exit_state == STILL_ACTIVE) {
#ifndef USE_PTHREADS
	    DExchange_poll_and_handle_timeout(de, 0, 100000);
#else 
	    sleep(1);
#endif
	    GetExitCodeProcess((HANDLE)sink_proc,&exit_state);
	}
	if (exit_state == 0) {
	    if (quiet < 2) 
		printf("Passed out of process protochannel derivation test\n");
	} else {
	    printf("Single remote sink exit with status %d\n",
		   exit_state);
	}
#endif
    }
    stop_poll_thread++;
    DExchange_close(de);
    DExchange_free(de);
#endif
    return 0;
}
#else
int
main()
{
	return 0;
}
#endif
