
#include "config.h"
#include <sys/types.h>

#ifdef HAVE_WINDOWS_H
#include <windows.h>
#include <winsock.h>
#define getpid()	_getpid()
#else
#include <sys/socket.h>
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#endif
#include <stdio.h>
#include <fcntl.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <errno.h>
#include <signal.h>
#include <memory.h>

#include "udp_cli.h"
#include "DE.h"

#ifndef HAVE_WINDOWS_H
#ifndef BIND_DEFINED
extern int bind ARGS((int s, struct sockaddr * name, int namelen));
#endif
#ifndef GETSOCKNAME_DEFINED
extern int getsockname ARGS((int s, struct sockaddr * name, int *namelen));
#endif
#if defined(HAVE_GETDOMAINNAME) && !defined(GETDOMAINNAME_DEFINED)
extern int getdomainname ARGS((char *name, int namelen));
#endif
#ifndef HAVE_WINDOWS_H
extern int socket ARGS((int domain, int type, int protocol));
#endif
#ifndef GETHOSTNAME_DEFINED
extern int gethostname ARGS((char *name, int namelen));
#endif
#ifndef SENDTO_DEFINED
extern int sendto ARGS((int s, char *msg, int len, int flags, struct sockaddr * to, int to_len));
extern int recvfrom ARGS((int s, char *buf, int len, int flags, struct sockaddr * from, int *from_len));
#endif
#endif

#ifndef SOCKET_ERROR
#define SOCKET_ERROR -1
#endif

static void
get_qual_hostname(char *buf, int len)
{
    gethostname(buf, len);
    buf[len - 1] = '\0';
    if (memchr(buf, '.', strlen(buf)) == NULL) {
	/* no dots, probably not fully qualified */
#ifdef HAVE_GETDOMAINNAME
	int end = strlen(buf);
	buf[end] = '.';
	getdomainname((&buf[end]) + 1, len - strlen(buf));
#else
	/* no getdomainname, hope that gethostbyname will help */
	char *tmp_name = (gethostbyname(buf))->h_name;
	strncpy(buf, tmp_name, len);
#endif
	buf[len - 1] = '\0';
    }
}

extern int
dg_startup(de, dep, client_data_p)
DExchange de;
DEPort dep;
void **client_data_p;
{
    Client_data *cli_data = (Client_data *) * client_data_p;
    char buf[256];
    char *hostname;
    int sock_addr_len = 0;
    int sockfd;
    struct sockaddr_in sock_addr;
    /* 
     * open UDP socket
     */
    if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
	printf("dg_startup:  can't open datagram socket");
	return 1;
    }
    /* 
     * bind any local address
     */
    memset((void *) &sock_addr, 0, sizeof(sock_addr));
    sock_addr.sin_family = AF_INET;
    sock_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    sock_addr.sin_port = htons(0);
    if (bind(sockfd, (struct sockaddr *) &sock_addr,
	     sizeof(sock_addr)) < 0) {
	printf("dg_startup:  can't bind local address");
	return 1;
    }
    /* record the server's hostname */
    get_qual_hostname(buf, 128);
    hostname = (char *) strdup(buf);
    sock_addr_len = sizeof(sock_addr);
    getsockname(sockfd, (struct sockaddr *) &sock_addr, &sock_addr_len);
    printf("DataExchange local UDP port opened at Inet host/port <%s %d>\n",
	   hostname, ntohs(sock_addr.sin_port));

    cli_data->fd = sockfd;
    DExchange_add_select(de, sockfd,
		       (GenericHandlerFunc) DExchange_dg_general_handler,
			 dep, NULL);
    DExchange_dg_assignFuncs(dep, dg_read, dg_write, dg_shutdown,
			     dg_get_new_cli, dg_addrCmp);
    return 0;
}


extern int
dg_write(mesg, msg_size, client_data_p)
char *mesg;
int msg_size;
void **client_data_p;
{
    Client_data *cli_data = (Client_data *) * client_data_p;
    int sockfd = cli_data->fd;
    int sock_addr_len = 0;
    struct hostent *host_addr;

    /* fill client data's sock structure from <name,port> */
    if (cli_data->name_str != NULL) {
	memset((char *) &cli_data->sock_addr, 0, sizeof(cli_data->sock_addr));
	cli_data->sock_addr.sin_family = AF_INET;
	if ((host_addr = gethostbyname(cli_data->name_str)) == NULL) {
	    printf("dg_send:  gethostbyname error");
	    exit(1);
	}
	memcpy(&cli_data->sock_addr.sin_addr, host_addr->h_addr,
	       host_addr->h_length);
	cli_data->sock_addr.sin_port = htons((unsigned short) cli_data->port);
	sock_addr_len = sizeof(cli_data->sock_addr);

	if (sendto(sockfd, mesg, msg_size, 0,
		 (struct sockaddr *) &cli_data->sock_addr, sock_addr_len)
	    != msg_size) {
	    return 1;		/* all is not well with the send */
	}
	cli_data->name_str = NULL;	/* use sock struct now instead */
	cli_data->port = -1;
    } else {			
	/* use sock structure that is part of client data */
	sock_addr_len = sizeof(cli_data->sock_addr);
	if (sendto(sockfd, mesg, msg_size, 0,
		   (struct sockaddr *) &cli_data->sock_addr,
		   sock_addr_len)
	    != msg_size) {
	    return 1;		/* all is not well */
	}
    }
    return 0;			/* success in sending message */
}

/* modifies client_data with receiver address information */
extern int
dg_read(msg, max_buf_size, client_data_p)
char **msg;
int *max_buf_size;
void **client_data_p;
{
    /* 
     * Read msg from socket.
     */
    Client_data *cli_data = (Client_data *) * client_data_p;
    int sockfd = cli_data->fd;
    int siz, n;
    siz = sizeof(struct sockaddr_in);
    n = recvfrom(sockfd, *msg, *max_buf_size, 0,
		 (struct sockaddr *) &cli_data->sock_addr,
		 (int *) &siz);
    *max_buf_size = n;
    if (n < 0) {
	printf("dg_receive:  recvfrom error on socket");
	return 1;
    } else {
	return n;
    }
}

extern int
dg_get_new_cli(cli_data_p)
void **cli_data_p;
{
    Client_data *cli_data = (Client_data *) malloc(sizeof(Client_data));
    memset(cli_data, 0, sizeof(Client_data));
    *cli_data_p = cli_data;
    return (sizeof(Client_data));
}

extern int
dg_addrCmp(cli_data1, cli_data2)
void *cli_data1;
void *cli_data2;
{
    struct sockaddr_in *sock_addr1 = &(((Client_data *) cli_data1)->sock_addr);
    struct sockaddr_in *sock_addr2 = &(((Client_data *) cli_data2)->sock_addr);
    if (sock_addr1->sin_port != sock_addr2->sin_port) {
	return 1;		/* no match */
    } else if (sock_addr1->sin_addr.s_addr !=
	       sock_addr2->sin_addr.s_addr) {
	return 1;		/* no match */
    } else {
	return 0;		/* match on both host and port */
    }

}

extern void
dg_shutdown(cli_data)
void *cli_data;
{
    close(((Client_data *) cli_data)->fd);
}
