#include "config.h"
#include <fcntl.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <unistd.h>
#include <stdlib.h>

#include "tcl.h"
#include "io.h"
#include "io_tcl.h"
#include "useful.h"
#include "datahub.h"

extern int PbioFileCommand(ClientData clientData, Tcl_Interp *interp, int argc,
	      char *argv[]);

typedef struct {
    netserv_client nsc;
    PbioFilePtr	   file_rec;
} *DatahubPtr;

int
NetServCommand(ClientData clientData, Tcl_Interp *interp, int argc, 
	       char *argv[])
{
    DatahubPtr hub = (DatahubPtr) clientData;
    netserv_client nsc = hub->nsc;
    PbioFilePtr file_rec = hub->file_rec;

    if (strcmp(argv[1], "close") == 0) {
	/* got a read command */
	Tcl_DeleteCommand(interp, argv[0]);
	return TCL_OK;
    } else {
	return PbioFileCommand(file_rec, interp, argc, argv);
    }
}

int
NetServCreate(ClientData clientData, Tcl_Interp *interp, int argc, 
	      char *argv[])
{
    netserv ns;
    netserv_client nsc;
    int flag;
    DatahubPtr hub;

    int port;

    if (argc != 5) {
	interp->result = "Wrong # args";
	return TCL_ERROR;
    }

    if (strcmp(argv[4], "forward") == 0) {
	flag = TRUE;
    } else if (strcmp(argv[4], "block") == 0) {
	flag = FALSE;
    } else {
	sprintf(interp->result, "misunderstood forward_default argument >%s<",
		argv[4]);
	return TCL_ERROR;
    }
    if (Tcl_GetInt(interp, argv[3], &port) != TCL_OK) {
	return TCL_ERROR;
    }
    
    ns = netserv_create();
    nsc = netserv_initiate_conn(ns, argv[2], port, flag);

    if (nsc == NULL) {
	Tcl_SetErrorCode(interp, "DATAHUB", "CONNFAIL", "Connection Failed", NULL);
	interp->result = "Connection failed";
	netserv_close(ns);
	return TCL_ERROR;
    }

    hub = (DatahubPtr) malloc(sizeof(*hub));
    hub->nsc = nsc;
    hub->file_rec = TclPbioInitFileRec(netserv_from_client(nsc), interp);
    Tcl_CreateCommand(interp, argv[1], NetServCommand, (ClientData)hub, 
		      netserv_close);
    return TCL_OK;
}

	
int
HubClient_Init(interp)
Tcl_Interp *interp;
{
    
    Tcl_CreateCommand(interp, "HubClient", NetServCreate, NULL, NULL);
    return TCL_OK;
}

