#include "config.h"
#include <fcntl.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <stdlib.h>

#include "tcl.h"
#include "io.h"
#include "io_tcl.h"
#include "useful.h"
#include "DE.h"

extern int PbioFileCommand ARGS((ClientData clientData, Tcl_Interp * interp, 
				 int argc, char *argv[]));

typedef struct {
    DExchange de;
    DEPort dep;
    PbioFilePtr in_file_rec;
    PbioFilePtr out_file_rec;
} *DataExchPtr;

int
NetServCommand(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp * interp;
int argc;
char *argv[];
{
    DataExchPtr exch = (DataExchPtr) clientData;
    PbioFilePtr in_file_rec = exch->in_file_rec;
    PbioFilePtr out_file_rec = exch->out_file_rec;

    if (strcmp(argv[1], "close") == 0) {
	/* got a read close */
	Tcl_DeleteCommand(interp, argv[0]);
	DExchange_close(exch->de);
	return TCL_OK;
    } else if (strcmp(argv[1], "forward") == 0) {
	if (argc != 3) {
	    interp->result = "Wrong # args to forward";
	    return TCL_ERROR;
	}
	DEport_set_format_block(exch->dep, argv[2], FALSE);
    } else if (strcmp(argv[1], "block") == 0) {
	if (argc != 3) {
	    interp->result = "Wrong # args to block";
	    return TCL_ERROR;
	}
	DEport_set_format_block(exch->dep, argv[2], TRUE);
    } else if (strncmp(argv[1], "write", 5) == 0) {
	return PbioFileCommand(out_file_rec, interp, argc, argv);
    } else {
	return PbioFileCommand(in_file_rec, interp, argc, argv);
    }
    return TCL_OK;
}

static void
ExchFree(clientData)
ClientData clientData;
{
    DataExchPtr exch = (DataExchPtr) clientData;
    DExchange_close(exch->de);
    free(exch);
}

int
NetServCreate(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp * interp;
int argc;
char *argv[];
{
    DExchange de;
    DEPort dep;
    int flag;
    DataExchPtr exch;

    int port;

    if (argc != 5) {
	interp->result = "Wrong # args";
	return TCL_ERROR;
    }
    if (strcmp(argv[4], "forward") == 0) {
	flag = FALSE;
    } else if (strcmp(argv[4], "block") == 0) {
	flag = TRUE;
    } else {
	sprintf(interp->result, "misunderstood block_by_default argument >%s<",
		argv[4]);
	return TCL_ERROR;
    }
    if (Tcl_GetInt(interp, argv[3], &port) != TCL_OK) {
	return TCL_ERROR;
    }
    de = DExchange_create();
    dep = DExchange_initiate_conn(de, argv[2], port, flag);

    if (dep == NULL) {
	Tcl_SetErrorCode(interp, "DataExch", "CONNFAIL", "Connection Failed", NULL);
	interp->result = "Connection failed";
	DExchange_close(de);
	return TCL_ERROR;
    }
    exch = (DataExchPtr) malloc(sizeof(*exch));
    exch->de = de;
    exch->dep = dep;
    exch->in_file_rec = TclPbioInitFileRec(DEport_from_port(dep), interp);
    exch->out_file_rec = TclPbioInitFileRec(DEport_to_port(dep), interp);
    Tcl_CreateCommand(interp, argv[1], NetServCommand, (ClientData) exch,
		      (Tcl_CmdDeleteProc *) ExchFree);
    return TCL_OK;
}

int
ExchClient_Init(interp)
Tcl_Interp *interp;
{

    Tcl_CreateCommand(interp, "ExchClient", NetServCreate, NULL, NULL);
    return TCL_OK;
}
