#ifndef DOC
/* 
 * the includes below are just to get the typedefs for 
 * printf and sscanf on machines where they are not in stdio.h
 */
#include "config.h"
#include "useful.h"
#endif
#include <stdio.h>

#include "DE.h"
#ifndef DOC
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#endif

#include "comm_group.h"
static void
usage()
{
    fprintf(stderr, "exchange takes the following arguments:\n");
    fprintf(stderr, "\t-debug -- turns on local printf-style debugging output\n");
    fprintf(stderr, "\t-app_name <name>  -- use <name> as the comm group application\n\t                     name to register (default \"exchange\")\n");
    fprintf(stderr, "\t-comm_type <name>  -- use <name> as the comm group type\n\n\t                     to register (default \"exchange\")\n");
}

#endif
int
main(argc, argv)
int argc;
char **argv;
{
    DExchange de = DExchange_create();
#ifndef DOC
    int i;
    char *group_id = NULL;
    extern int de_data_debug_flag;

#ifdef NT
    /* Setup NT scroll screen */
    HANDLE hConsole = GetStdHandle(STD_OUTPUT_HANDLE);
    COORD xy;
    SMALL_RECT rect;

    xy.X = 100;
    xy.Y = 600;
    rect.Left = 0;
    rect.Top = 0;
    rect.Right = 90;
    rect.Bottom = 50;

    SetConsoleScreenBufferSize(hConsole, xy);
    SetConsoleWindowInfo(hConsole, TRUE, &rect);
#endif

    for (i = 1; i < argc; i++) {
	if (strcmp(argv[i], "-debug") == 0) {
	    de_debug_flag++;
	    de_data_debug_flag++;
	    printf("Exchange using ");
	    IOprint_version();
	    printf("Exchange is ");
	    DEprint_version();
	} else if (strcmp(argv[i], "-version") == 0) {
	    printf("Exchange using ");
	    IOprint_version();
	    printf("Exchange is ");
	    DEprint_version();
	    exit(0);
	} else if (strcmp(argv[i], "-app_name") == 0) {
	    if (argc == ++i) {
		usage();
		exit(1);
	    } else {
		comm_group_set_app_name(argv[i]);
	    }
	} else if (strcmp(argv[i], "-comm_type") == 0) {
	    if (argc == ++i) {
		usage();
		exit(1);
	    } else {
		comm_group_set_comm_type(argv[i]);
	    }
	} else {
	    fprintf(stderr, "Unknown argument \"%s\"\n", argv[i]);
	    usage();
	    exit(1);
	}
    }
    if (DExchange_listen(de, 0) == -1) {
#endif
	if (DExchange_listen(de, 12345) == -1) {
	    if (DExchange_listen(de, 0) == -1) {
		fprintf(stderr, "Unable to listen\n");
		exit(-1);
	    }
	}
#ifndef DOC
    }
    if (group_server_present()) {
	while (group_id == NULL) {
	    group_id = setup_comm_group(NULL, "exchange", "exchange", 60 * 60,
					DExchange_host_name(de),
					DExchange_inet_port(de));
	}
	printf("Registering group \"%s\"\n", group_id);
    }
#endif
    printf("DataExchange server listening at Inet host/port <%s %d>\n",
	   DExchange_host_name(de), DExchange_inet_port(de));
    while (1) {
	DExchange_poll_and_handle(de, TRUE);
    }
}
