#include "config.h"
#include "io.h"
#ifdef HAVE_GEN_THREAD_H
#include "gen_thread.h"
#else
#define gen_thr_initialized() 0
#define thr_mutex_lock(m)
#define thr_mutex_unlock(m)
#endif
#include "DE.h"
#include "de_internal.h"
#include "de_lock.h"
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <stdio.h>
#include <string.h>
#include "useful.h"
#ifndef NO_DERIVED
#include "ecl.h"
#endif
#include "channel.h"

/* message to send to arbitrator to derive a new the channel */
typedef struct _ProtoDeriveMsg {
    char *proto_str;
    int cond;
    char client_channel[8];
    char *filter;
    int  field_list_len;
    IOFieldList field_list;
    int  format_list_len;
    format_list_element *format_list;
    long usec_period;
} ProtoDeriveMsg, *ProtoDeriveMsgPtr;

IOField proto_derive_msg_flds[] =
{
    {"proto_channel", "string", sizeof(char *), 
     IOOffset(ProtoDeriveMsgPtr, proto_str)},
    {"condition", "integer", sizeof(int), 
     IOOffset(ProtoDeriveMsgPtr, cond)},
    {"client channel", "char[8]", 1, 
     IOOffset(ProtoDeriveMsgPtr, client_channel)},
    {"filter", "string", sizeof(char*), 
     IOOffset(ProtoDeriveMsgPtr, filter)},
    {"field_list_len", "integer", sizeof(int),
     IOOffset(ProtoDeriveMsgPtr, field_list_len)},
    {"field_list", "IOfield_list[field_list_len]", sizeof(IOField),
     IOOffset(ProtoDeriveMsgPtr, field_list)},
    {"format_list_len", "integer", sizeof(int),
     IOOffset(ProtoDeriveMsgPtr, format_list_len)},
    {"format_list", "DEFormatList[format_list_len]", 
     sizeof(format_list_element), IOOffset(ProtoDeriveMsgPtr, format_list)},
    {"usec_period", "integer", sizeof(long),
     IOOffset(ProtoDeriveMsgPtr, usec_period)},
    {(char *) 0, (char *) 0, 0, 0}
};

#ifndef NO_DERIVED
static EChannel
do_proto_derive ARGS((DExchange de, ECproto proto_channel, char *filter, 
			IOFieldList output_field_list, 
			DEFormatList output_format_list, int period));

typedef struct _ECproto {
    DExchange de;
    ecl_parse_context base_context;
} ECproto_struct;

extern ECproto ECproto_create(de, context)
DExchange de;
ecl_parse_context context;
{
    ECproto proto_chan = malloc(sizeof(struct _ECproto));
    proto_chan->de = de;
    proto_chan->base_context = context;
    return proto_chan;
}

extern char *ECproto_id(proto_chan)
ECproto proto_chan;
{
    int len = strlen(proto_chan->de->hostname);
    char port_str[20] =
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    char proto_str[17] =
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    unsigned char proto_char[8] =
    {0, 0, 0, 0, 0, 0, 0, 0};
    char *global_id_str;

    sprintf(port_str, "%d", proto_chan->de->port);
    memset(proto_char, 0, sizeof(proto_char));
    memcpy(proto_char, &proto_chan, sizeof(proto_chan));
    sprintf(proto_str, "%02x%02x%02x%02x%02x%02x%02x%02x",
	    (unsigned int) proto_char[0],
	    (unsigned int) proto_char[1],
	    (unsigned int) proto_char[2],
	    (unsigned int) proto_char[3],
	    (unsigned int) proto_char[4],
	    (unsigned int) proto_char[5],
	    (unsigned int) proto_char[6],
	    (unsigned int) proto_char[7]);
    len += strlen(port_str);
    len += 16 /* proto_str */  + 2 /* separators */ ;
    global_id_str = DEmalloc(len + 1);
    memset(global_id_str, 0, len + 1);
    sprintf(global_id_str, "%s@%s@%s", proto_chan->de->hostname, port_str,
	    proto_str);
    return global_id_str;
}

extern EChannel
ECproto_derive_periodic(de, proto_id, event_filter, field_list, format_list,
			period)
DExchange de;
char *proto_id;
char *event_filter;
IOFieldList field_list;
DEFormatList format_list;
int period;
{
#ifndef NO_DERIVED
    char *host_str;
    char *proto_str;
    int port_id;
    DEPort dep;
    EChannel chan;
    ECproto proto_chan;
    ProtoDeriveMsg derive_msg;
    int cond, i;

    ECtrace_out("ECproto_derive", 2);

    if (EC_break_up_triple(proto_id, &host_str, &port_id, 
			   &proto_str, (void**)&proto_chan) != 0) {
	ECtrace_out("ECproto_derive", 0);
	return NULL;
    }	
    
    if ((strcmp(host_str, DExchange_host_name(de)) == 0) &&
	(port_id == DExchange_inet_port(de))) {
	/* this proto-channel is really local */
	DEfree(host_str);
	chan = do_proto_derive(de, proto_chan, event_filter, field_list,
			       format_list, period);
	return chan;
    }

    chan = EChannel_typed_create(de, field_list, format_list);

    ECtrace_out("getting a connection, registering close handler", 3);
    dep = DExchange_get_conn(de, host_str, port_id, 0);
    DEport_register_close_handler(dep, DEChannel_close_handler);

    ECtrace_out("getting condition and setting local chan condition", 3);
    cond = DECondition_get(de, dep);
    DECondition_set_client_data(de, cond, &chan);

    memset(&derive_msg, 0, sizeof(derive_msg));
    derive_msg.proto_str = proto_str;
    derive_msg.cond = cond;
    memcpy(&derive_msg.client_channel[0], &chan, sizeof(chan));
    derive_msg.filter = event_filter;
    derive_msg.usec_period = period;
    derive_msg.field_list = field_list;
    derive_msg.field_list_len = 0;
    while(field_list[derive_msg.field_list_len].field_name != NULL) {
	derive_msg.field_list_len++;
    }
    derive_msg.field_list_len++;  /* send terminator as well */
    i = 0;
    while(format_list[i].format_name != NULL) i++;
    derive_msg.format_list = DEmalloc(i * sizeof(format_list_element));  
    derive_msg.format_list_len = i;  /* +1 because we send terminator */
    for (i=0; i<derive_msg.format_list_len; i++) {
	int j = 0;
	derive_msg.format_list[i].format_name = format_list[i].format_name;
	derive_msg.format_list[i].field_list = format_list[i].field_list;
	while (format_list[i].field_list[j].field_name != NULL) {
	    j++;
	}
	j++; /* send terminator as well */
	derive_msg.format_list[i].field_list_len = j;
    }
    DEport_write_data(dep, DE_Proto_Derive_format_id, &derive_msg);
    DEfree(derive_msg.format_list);
    DEfree(host_str);
    ECtrace_out("Sending derive msg, proto-channel %s cond %d filter %d\n", 3,
		derive_msg.proto_str, derive_msg.cond, derive_msg.filter);
    if (DECondition_wait(de, cond)) {
	chan->ready++;
	ECtrace_out("ECproto_derive", 0);
	return chan;
    } else {
	/* wait failed, dep is dead */
	EChannel_destroy(chan);
	ECtrace_out("ECproto_derive", 0);
	return NULL;
    }
#else
    printf("No derived event channels in this version of DataExchange\n");
    return NULL;
#endif
}

static ecl_code
generate_periodic_code(context, filter, output_field_list,
		     output_format_list)
ecl_parse_context context;
char *filter;
IOFieldList output_field_list;
DEFormatList output_format_list;
{
#ifndef NO_DERIVED
    sm_ref typ, output_type, output_param;
    ecl_parse_context parse_context = ecl_copy_context(context);

    while ((output_format_list != NULL) && 
	   (output_format_list->format_name != NULL)) {
	/* set through output formats */
	typ = ecl_build_type_node(output_format_list->format_name,
			      output_format_list->field_list);
	ecl_add_decl_to_parse_context(output_format_list->format_name, typ, 
				  parse_context);
	output_format_list++;
    }
    output_type = ecl_build_type_node("output_type", output_field_list);
    ecl_add_decl_to_parse_context("output_type", output_type, parse_context);

    output_param = ecl_build_param_node("output", output_type, 0);

    ecl_add_decl_to_parse_context("output", output_param, parse_context);

    return ecl_code_gen(filter, parse_context);
#else
    return NULL;
#endif
}

typedef struct _proto_generator {
    EChannel chan;
    ecl_code code;
    int event_size;
    ECSourceHandle src_handle;
    DEtask_handle task_handle;
} *proto_generator_t;

static void
run_periodic_proto_task(periodic_p, junk)
void *periodic_p;
void *junk;
{
    proto_generator_t periodic = (proto_generator_t) periodic_p;

    if (EChas_sinks(periodic->src_handle)) {
	int (*generator_func)(void *) = (int(*)(void*)) periodic->code->func;
	void *event = malloc(periodic->event_size);
	int return_value;
	ECtrace_out("ECproto running generator function for periodic %lx", 2, 
		    (long)periodic);
	memset(event, 0, periodic->event_size);
	return_value = generator_func(event);
	if (return_value != 0) {
	    ECtrace_out("ECproto submitting event to channel %lx", 0, 
			(long)periodic->chan);
	    ECsubmit_general_typed_event(periodic->src_handle,
					 event, free);
	} else {
	    ECtrace_out("ECproto generator suppressed, return was %d", 
			0, return_value, (long)periodic->chan);
	}
    }
}

static EChannel
do_proto_derive(de, proto_chan, filter, output_field_list,
		  output_format_list, period)
DExchange de;
ECproto proto_chan;
char *filter;
IOFieldList output_field_list;
DEFormatList output_format_list;
int period;
{
    EChannel chan;
    proto_generator_t periodic = malloc(sizeof(*periodic));
    ecl_code code;
    DEtask_handle task;

    chan = EChannel_typed_create(de, output_field_list, output_format_list);

    code = generate_periodic_code(proto_chan->base_context, filter, 
				  output_field_list,
				  output_format_list);
    if (code == NULL) return NULL;
    periodic->chan = chan;
    periodic->code = code;
    periodic->event_size = struct_size_field_list(output_field_list, 
						  sizeof(char*));
    periodic->src_handle = ECsource_typed_subscribe(chan, output_field_list,
						    output_format_list);
    task = DEControlList_add_periodic(de->control_list, period,
				      run_periodic_proto_task,
				      (void *)periodic, NULL);
    periodic->task_handle = task;

    chan->periodic_info = periodic;
    return chan;
}

extern void
DEperiodic_info_free(vperiodic)
void *vperiodic;
{
    proto_generator_t periodic = (proto_generator_t) vperiodic;
    DEtask_remove_periodic(periodic->task_handle);
    ecl_code_free(periodic->code);
    DEfree(periodic);
}
    
/* send derive request to all sources of the parent channel */
extern int
DEProto_Derive_handler(de, dep, attend_format_id,
			 data, data_length, client_data)
DExchange de;
DEPort dep;
int attend_format_id;
void *data;
int data_length;
void *client_data;
{
    ProtoDeriveMsgPtr derive_msg = (ProtoDeriveMsgPtr) data;
    AttendResponseMsg ret_msg;
    EChannel chan;
    ECproto proto_chan;
    int i, derive_cond, modifier_index;
    DEFormatList output_format_list;
    IOFieldList field_list;
    char *filter;

    ECtrace_out("DEProto_Derive_handler", 1);
    DEport_register_close_handler(dep, DEChannel_close_handler);

    proto_chan = (ECproto) string_to_channel_ptr(derive_msg->proto_str);


    derive_cond = derive_msg->cond;

    output_format_list = DEmalloc((derive_msg->format_list_len+1) * 
				  sizeof(DEFormat));
    for (i=0; i< derive_msg->format_list_len; i++) {
	output_format_list[i].format_name = 
	    derive_msg->format_list[i].format_name;
	output_format_list[i].field_list =
	    copy_field_list(derive_msg->format_list[i].field_list);
    }
    field_list = copy_field_list(derive_msg->field_list);
    filter = malloc(strlen(derive_msg->filter) + 2);
    strcpy(filter, derive_msg->filter);
    filter[strlen(filter) + 1] = 0; /* add extra NULL termination */

    output_format_list[derive_msg->format_list_len].format_name = NULL;
    output_format_list[derive_msg->format_list_len].field_list = NULL;
    ECtrace_out("Deriving proto with filter %s\n", 3, filter);
    chan = do_proto_derive(de, proto_chan, filter, 
			   field_list, output_format_list, 
			   derive_msg->usec_period);

    DEfree(output_format_list);
    ECtrace_out("adding modifier to  remote member list", 3);
    if (chan->rem_member_list == NULL) {
	chan->rem_member_list = DEmalloc(sizeof(struct _rem_attendr));
    }
    chan->rem_member_list = DErealloc(chan->rem_member_list,
	  sizeof(struct _rem_attendr) * (chan->rem_member_list_len + 1));
    chan->rem_member_list[chan->rem_member_list_len].dep = dep;
    memcpy(chan->rem_member_list[chan->rem_member_list_len].channel,
	   &derive_msg->client_channel[0], 8);
    modifier_index = chan->rem_member_list_len;
    chan->rem_member_list_len++;

    ECtrace_out("send sink list, local and remote to modifier", 3);
    memset(&ret_msg, 0, sizeof(ret_msg));
    ret_msg.condition = derive_cond;
    ret_msg.sink_count = 1;
    ret_msg.sinks = DEmalloc(sizeof(AttendRec));
    ret_msg.sinks[0].host = chan->global_id.home_host;
    ret_msg.sinks[0].IPport = chan->global_id.IPport;
    ret_msg.sinks[0].filter = NULL;
    memset(ret_msg.sinks[0].channel, 0, sizeof(ret_msg.sinks[0].channel));
    memcpy(ret_msg.sinks[0].channel, &chan, sizeof(chan));
    for (i = 0; i < chan->rem_sink_list_len; i++) {
	if (chan->rem_sink_list[i].dep != NULL) {
	    ret_msg.sinks = DErealloc(ret_msg.sinks,
			   (ret_msg.sink_count + 1) * sizeof(AttendRec));
	    ret_msg.sinks[ret_msg.sink_count].host =
		DEport_host_name(chan->rem_sink_list[i].dep);
	    ret_msg.sinks[ret_msg.sink_count].IPport =
		DEport_port_number(chan->rem_sink_list[i].dep);
	    memset(ret_msg.sinks[ret_msg.sink_count].channel, 0,
		   sizeof(ret_msg.sinks[0].channel));
	    ret_msg.sinks[ret_msg.sink_count].filter = NULL;
	    memcpy(ret_msg.sinks[ret_msg.sink_count].channel,
		   chan->rem_sink_list[i].channel,
		   sizeof(chan->rem_sink_list[0].channel));
	    ret_msg.sink_count++;
	}
    }
    ret_msg.member_count = 1;
    ret_msg.members = DEmalloc(sizeof(AttendRec));
    ret_msg.members[0].host = chan->global_id.home_host;
    ret_msg.members[0].IPport = chan->global_id.IPport;
    ret_msg.members[0].filter = NULL;
    memset(ret_msg.members[0].channel, 0,
	   sizeof(ret_msg.members[0].channel));
    memcpy(ret_msg.members[0].channel, &chan, sizeof(chan));
    for (i = 0; i < chan->rem_member_list_len; i++) {
	if (chan->rem_member_list[i].dep != NULL &&
	    i != modifier_index) {
	    ret_msg.members = DErealloc(ret_msg.members,
			 (ret_msg.member_count + 1) * sizeof(AttendRec));
	    ret_msg.members[ret_msg.member_count].host =
		DEport_host_name(chan->rem_member_list[i].dep);
	    ret_msg.members[ret_msg.member_count].IPport =
		DEport_port_number(chan->rem_member_list[i].dep);
	    ret_msg.members[ret_msg.member_count].filter = NULL;
	    memset(ret_msg.members[ret_msg.member_count].channel, 0,
		   sizeof(ret_msg.members[0].channel));
	    memcpy(ret_msg.members[ret_msg.member_count].channel,
		   chan->rem_member_list[i].channel, sizeof(chan));
	    ret_msg.member_count++;
	}
    }
    DEport_write_data(dep, DE_Channel_Attend_Response_format_id, &ret_msg);
    DEfree(ret_msg.sinks);
    DEfree(ret_msg.members);

    ECtrace_out("DEChannel_Derive_handler", 0);
    return 0;
}

#else
extern void
DEperiodic_info_free(vperiodic)
void *vperiodic;
{
}
extern int
DEProto_Derive_handler(de, dep, attend_format_id,
			 data, data_length, client_data)
DExchange de;
DEPort dep;
int attend_format_id;
void *data;
int data_length;
void *client_data;
{
return 0;
}
#endif
