
/* initial handshaking message */
typedef struct _ExchFirstMsg {
    char *exchange_name;
    int exch_pid;
    char *mach_name;
    int port, pid;
    char *usock_name;
    int default_accept;
} ExchFirstMsg, *ExchFirstMsgPtr;

static IOField exch_first_msg_flds[] =
{
    {"hub_name", "string", sizeof(char *), IOOffset(ExchFirstMsgPtr, exchange_name)},
    {"hub_id", "integer", sizeof(int), IOOffset(ExchFirstMsgPtr, exch_pid)},
    {"mach_name", "string", sizeof(char *), IOOffset(ExchFirstMsgPtr, mach_name)},
    {"port", "integer", sizeof(int), IOOffset(ExchFirstMsgPtr, port)},
    {"pid", "integer", sizeof(int), IOOffset(ExchFirstMsgPtr, pid)},
    {"usock_name", "string", sizeof(char *), IOOffset(ExchFirstMsgPtr, usock_name)},
    {"default_forward", "integer", sizeof(int),
     IOOffset(ExchFirstMsgPtr, default_accept)},
    {(char *) 0, (char *) 0, 0, 0}
};


/* format sign on or off msg */
typedef struct _FormatSignMsg {
    int requester_id;		/* exch_pid of requester */
    char *format_name;
} FormatSignMsg, *FormatSignMsgPtr;

static IOField format_sign_msg_flds[] =
{
    {"requester_id", "integer", sizeof(int),
     IOOffset(FormatSignMsgPtr, requester_id)},
    {"format_name", "string", sizeof(char *),
     IOOffset(FormatSignMsgPtr, format_name)},
    {(char *) 0, (char *) 0, 0, 0}
};


/* shut down system or just close a connection link */
typedef struct _ShutDownMsg {
    int whom;			/* shut down whom */
    char *message;
    char *exchange_name;
    int exch_pid;
} ShutDownMsg, *ShutDownMsgPtr;

static IOField shut_down_msg_flds[] =
{
    {"whom", "integer", sizeof(int), IOOffset(ShutDownMsgPtr, whom)},
{"message", "string", sizeof(char *), IOOffset(ShutDownMsgPtr, message)},
    {"hub name", "string", sizeof(char *), IOOffset(ShutDownMsgPtr, exchange_name)},
    {"hub id", "integer", sizeof(int), IOOffset(ShutDownMsgPtr, exch_pid)},
    {(char *) 0, (char *) 0, 0, 0}
};

typedef struct _AttendMsg {
    char *chan_str;
    int cond;
    char client_channel[8];
} AttendMsg, *AttendMsgPtr;

static IOField channel_attend_msg_flds[] = 
{
    {"channel", "string", sizeof(char*), IOOffset(AttendMsgPtr, chan_str)},
    {"condition", "integer", sizeof(int), IOOffset(AttendMsgPtr, cond)},
    {"client channel", "char[8]", 1, IOOffset(AttendMsgPtr, client_channel)},
    {(char *) 0, (char *) 0, 0, 0}
};

typedef struct _SinkSubscribeMsg {
    char server_channel[8];
    char client_channel[8];
} SinkSubscribeMsg, *SinkSubscribeMsgPtr;

static IOField sink_subscribe_msg_flds[] = 
{
    {"server_channel", "char[8]", 1, 
     IOOffset(SinkSubscribeMsgPtr, server_channel)},
    {"client_channel", "char[8]", 1, 
     IOOffset(SinkSubscribeMsgPtr, client_channel)},
    {(char *) 0, (char *) 0, 0, 0}
};

typedef struct _AttendRec {
    char *host;
    int IPport;
    char channel[8];
} AttendRec, *AttendRecPtr;

static IOField AttendRec_flds[] = 
{
    {"host", "string", sizeof(char*), IOOffset(AttendRecPtr, host)},
    {"IPport", "integer", sizeof(int), IOOffset(AttendRecPtr, IPport)},
    {"channel", "char[8]", 1, IOOffset(AttendRecPtr, channel)},
    {(char *) 0, (char *) 0, 0, 0}
};

typedef struct _AttendResponseMsg {
    int condition;
    int sink_count;
    AttendRec *sinks;
    int member_count;
    AttendRec *members;
} AttendResponseMsg, *AttendResponseMsgPtr;

static IOField channel_attend_response_msg_flds[] = 
{
    {"condition", "integer", sizeof(int), 
     IOOffset(AttendResponseMsgPtr, condition)},
    {"sink_count", "integer", sizeof(int),
     IOOffset(AttendResponseMsgPtr, sink_count)},
    {"sinks", "AttendRec[sink_count]", sizeof(AttendRec), 
     IOOffset(AttendResponseMsgPtr, sinks)},
    {"member_count", "integer", sizeof(int),
     IOOffset(AttendResponseMsgPtr, member_count)},
    {"members", "AttendRec[member_count]", sizeof(AttendRec), 
     IOOffset(AttendResponseMsgPtr, members)},
    {(char *) 0, (char *) 0, 0, 0}
};

typedef struct _MemberSubscribeMsg {
    char server_channel[8];
    char client_channel[8];
} MemberSubscribeMsg, *MemberSubscribeMsgPtr;

static IOField member_subscribe_msg_flds[] = 
{
    {"server_channel", "char[8]", 1, 
     IOOffset(MemberSubscribeMsgPtr, server_channel)},
    {"client_channel", "char[8]", 1, 
     IOOffset(MemberSubscribeMsgPtr, client_channel)},
    {(char *) 0, (char *) 0, 0, 0}
};


typedef struct _EventMsg {
    char channel[8];
    char global_chan_id[16];
    int event_len;
    char *event;
} EventMsg, *EventMsgPtr;

static IOField event_msg_flds[] = 
{
    {"channel", "char[8]", sizeof(char), 
     IOOffset(EventMsgPtr, channel)},
    {"global_chan_id", "char[16]", sizeof(char),
     IOOffset(EventMsgPtr, global_chan_id)},
    {"event_len", "integer", sizeof(int),
     IOOffset(EventMsgPtr, event_len)},
    {"event", "char[event_len]", sizeof(char), 
     IOOffset(EventMsgPtr, event)},
    {(char *) 0, (char *) 0, 0, 0}
};

/***** EOF *****/
