#ifndef DOC
#include "config.h"
#include "io.h"
#include "DE.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

typedef struct _dyn_rec {
    char        *string;
    long        icount;
    double      *double_array;
} dyn_rec, *dyn_rec_ptr;

IOField dyn_field_list[] = {
    {"string field", "string", sizeof(char *), 
      IOOffset(dyn_rec_ptr, string)},
    {"icount", "integer", sizeof(long), 
      IOOffset(dyn_rec_ptr, icount)},
    {"double_array", "float[icount]", sizeof(double), 
      IOOffset(dyn_rec_ptr, double_array)},
    { NULL, NULL, 0, 0}
};
#endif
void main(argc, argv)
int argc;
char **argv;
{
    DExchange de = DExchange_create();
    EChannel chan;
    ECSourceHandle handle;
    IOContext src_context = create_IOcontext();
    IOFormat rec_ioformat;
    dyn_rec rec;
    long a = time(NULL) % 100;

    DExchange_listen(de, 0);
    chan = EChannel_open(de, argv[1]);
    handle = ECsource_subscribe(chan);

    rec_ioformat = register_IOcontext_format("dynamic format", dyn_field_list, src_context);
    rec.string = "Hi Mom!";
    rec.icount = time(NULL) % 10 + 1;
    rec.double_array = (double*) malloc(sizeof(double) * rec.icount);

    while (1) {
	int i, buf_size;
	char *encoded_buffer;
	for (i=0; i<rec.icount; i++) rec.double_array[i] = (a + i) * 2.717;
	encoded_buffer = encode_IOcontext_buffer(src_context, rec_ioformat, &rec, &buf_size);
	printf("I'm submitting\n");
	ECsubmit_event(handle, encoded_buffer, buf_size);
	DExchange_poll_and_handle_timeout(de, 1, 0);
	a++;
    }
}
