#ifndef DOC
#include "config.h"
#include "io.h"
#include "DE.h"
#include "gen_thread.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#endif
typedef struct _dyn_rec {
    char        *string;
    long        icount;
    double      *double_array;
} dyn_rec, *dyn_rec_ptr;

IOField dyn_field_list[] = {
    {"string field", "string", sizeof(char *), 
      IOOffset(dyn_rec_ptr, string)},
    {"icount", "integer", sizeof(long), 
      IOOffset(dyn_rec_ptr, icount)},
    {"double_array", "float[icount]", sizeof(double), 
      IOOffset(dyn_rec_ptr, double_array)},
    { NULL, NULL, 0, 0}
};

#endif

void handler(event, length, client_data)
void *event;
int length;
void *client_data;
{
    static IOContext dest_context = NULL;
    IOFormat dyn_rec_ioformat;
    dyn_rec rec;
    int i;

    if (dest_context == NULL) dest_context = create_IOcontext();
    dyn_rec_ioformat = get_format_IOcontext(dest_context, event);
    if (!has_conversion_IOformat(dyn_rec_ioformat)) {
	set_conversion_IOcontext(dest_context, dyn_rec_ioformat, dyn_field_list, sizeof(dyn_rec));
    }
    decode_IOcontext(dest_context, event, &rec);
    printf("event data is ->  string = \"%s\"\n", rec.string);
    printf("                  icount = %d\n", rec.icount);
    for (i=0; i< rec.icount; i++) {
	printf("                  double_array[%d] = %g\n", i, rec.double_array[i]);
    }
}

void main(argc, argv)
int argc;
char **argv;
{
    DExchange de = DExchange_create();
    EChannel chan;

    DExchange_listen(de, 0);
    chan = EChannel_open(de, argv[1]);
    (void) ECsink_subscribe(chan, handler, NULL);
    while(1) DExchange_poll_and_handle(de, 1);
}
