/* $Id: hubcli.c,v 1.10 1995/05/31 15:48:19 vetter Exp $ */

/***** Includes *****/
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>

#include "config.h"
#include "useful.h"
#include "dll.h"
#include "hash.h"
#include "io.h"
#include "hubcli.h"
#include "datahub.h"
#include "ioformats.h"

/***** Functions *****/

netcli
netcli_open (serverName, serverPort)
     char *serverName;
     int serverPort;
{
  netcli nc;
  assert (serverName != NULL);
  assert (serverPort != 0);

  nc = (netcli) malloc (sizeof (netcli_s));
  assert (nc != NULL);

  /* create socket */
  if ((nc->sock = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    {
      perror ("opening stream socket");
      return (NULL);
    }

  /* connect socket using name specified by command line. */
  nc->sockAddr.sin_family = AF_INET;
  nc->serverAddr = gethostbyname (serverName);
  if (nc->serverAddr == 0)
    {
      fprintf (stderr, "%s: unknown host", serverName);
      return (NULL);
    }
  nc->serverName = (char *) strdup (serverName);
  bcopy ((char *) nc->serverAddr->h_addr, (char *) &(nc->sockAddr.sin_addr),
	 nc->serverAddr->h_length);
  nc->sockAddr.sin_port = htons (serverPort);
  nc->serverPort = serverPort;

  /* connect to the server through the recently opened socket.  */
  if (connect (nc->sock, (struct sockaddr *) &(nc->sockAddr),
	       sizeof (nc->sockAddr)) < 0)
    {
      perror ("connection stream socket");
      return (NULL);
    }

  switch (nc->sock)
    {
    case -1:
      perror ("connect");
      break;

    default:
      {
	char buf[256], buf2[128];
	hub_trash trash;
	extern IOField hub_trash_flds[];

	mID vmID;
	IOFormat mID_fmt;
	extern IOField mID_flds[];
	struct linger linger_val =
	{1, 60};
	int junk = sizeof (struct linger);

	DBG ("Connection opened", nc->sock);

	if (setsockopt (nc->sock, SOL_SOCKET, SO_LINGER, (char *) &linger_val,
			sizeof (struct linger)) != 0)
	  {
	    perror ("set SO_LINGER");
	  }
	if (getsockopt (nc->sock, SOL_SOCKET, SO_LINGER, (char *) &linger_val,
			&junk) != 0)
	  {
	    perror ("get SO_LINGER");
	  }
	printf ("Linger value is on/off %d, linger %d\n", linger_val.l_onoff,
		linger_val.l_linger);

	/* --- Open for writing to the server --- */
	nc->toServer = open_IOfd (nc->sock, O_WRONLY | O_CREAT | O_TRUNC);
	assert (nc->toServer != NULL);
	mID_fmt = register_IOrecord_format ("mID",
					    IONumber (mID_flds),
					    mID_flds,
					    nc->toServer);
	gethostname (buf, 128);
	getdomainname (buf2, 128);
	strcat (buf, ".");
	strcat (buf, buf2);
	vmID.name = (char *) strdup (buf);
	vmID.port = 0;
	write_IOfile (nc->toServer, mID_fmt, &vmID);	/* write */
	free (vmID.name);

	/* --- open for receiving from server --- */
	nc->fromServer = open_IOfd (nc->sock, O_RDONLY);
	assert (nc->fromServer != NULL);
	set_IOconversion (nc->fromServer,
			  "hub:trash",
			  IONumber (hub_trash_flds),
			  hub_trash_flds,
			  sizeof (hub_trash));
	read_IOfile (nc->fromServer, &trash);
	printf ("Client: received init message.\ttype=%d\ttag=%d\n",
		trash.type, trash.tag);
      }
    }
  return nc;
}

IOFile
IOfile_to_net (nc)
     netcli nc;
{
  assert (nc != NULL);
  return nc->toServer;
}

IOFile
IOfile_from_net (nc)
     netcli nc;
{
  assert (nc != NULL);
  return nc->fromServer;
}

void
netcli_close (nc)
     netcli nc;
{
  assert (nc != NULL);
  shutdown (nc->sock, 1);
  free (nc->serverName);
  free (nc);
  DBG ("connection closed", 0);
}


int
netcli_forward (nc, fname)
     netcli nc;
     char *fname;
{
  assert (nc != NULL);
  assert (fname != NULL);

  /* load and send a pbio message to do this. */
  return SUCCESS;
}


int
netcli_unforward (nc, fname)
     netcli nc;
     char *fname;
{
  assert (nc != NULL);
  assert (fname != NULL);

  /* load and send a pbio message to do this. */
  return SUCCESS;
}


/***** EOF *****/
