#define PORT 8646

typedef struct _setup_group_msg {
    char *user_name;
    char *application_name;
    char *group_type;
    int expiration;		/* in seconds, 0=never */
    char *host;
    int port;
} setup_group_msg, *setup_group_msg_ptr;

typedef struct _init_contact_msg {
    char *group_id;		/* specifies one particular group */
    char *user_name;		/* first level differentiator */
    char *application_name;	/* second level differentiator */
    char *group_type;		/* third level differentiator */
} init_contact_msg, *init_contact_msg_ptr;

typedef struct _return_contact_msg {
    char *host;
    int port;
    char *group_id;
} return_contact_msg, *return_contact_msg_ptr;

typedef struct _remove_group_msg {
    char *host;
    int port;
    char *group_id;
} remove_group_msg, *remove_group_msg_ptr;

typedef struct _find_matching_msg {
    char *user_name;
    char *app_list;
    char *type_list;
} find_matching_msg, *find_matching_msg_ptr;

typedef struct _assoc_group_info_msg {
    char *group_name;
    int data_len;
    void *data;
} assoc_group_info_msg, *assoc_group_info_msg_ptr;

typedef struct _provisional_use_msg {
    char *domain;
    long time;
} provisional_use_msg, *provisional_use_msg_ptr;

extern IOField setup_group_msg_flds[];
extern IOField init_contact_msg_flds[];
extern IOField return_contact_msg_flds[];
extern IOField remove_group_msg_flds[];
extern IOField comm_group_struct_flds[];
extern IOField return_matching_msg_flds[];
extern IOField find_matching_msg_flds[];
extern IOField assoc_group_info_msg_flds[];
extern IOField provisional_use_msg_flds[];
