
#include "config.h"

#include "io.h"
#include "DE.h"
#include "comm_group.h"
#include "group_formats.h"

IOField setup_group_msg_flds[] =
{
    {"user name", "string", sizeof(char *), IOOffset(setup_group_msg_ptr,
						     user_name)},
    {"application name", "string", sizeof(char *),
     IOOffset(setup_group_msg_ptr, application_name)},
    {"group type", "string", sizeof(char *),
     IOOffset(setup_group_msg_ptr, group_type)},
    {"expiration", "integer", sizeof(int),
     IOOffset(setup_group_msg_ptr, expiration)},
    {"host", "string", sizeof(char *),
     IOOffset(setup_group_msg_ptr, host)},
    {"port", "integer", sizeof(int),
     IOOffset(setup_group_msg_ptr, port)},

    {(char *) 0, (char *) 0, 0, 0}
};

IOField init_contact_msg_flds[] =
{
    {"group id", "string", sizeof(char *), IOOffset(init_contact_msg_ptr,
						    group_id)},
    {"user name", "string", sizeof(char *), IOOffset(init_contact_msg_ptr,
						     user_name)},
    {"application name", "string", sizeof(char *),
     IOOffset(init_contact_msg_ptr, application_name)},
    {"group type", "string", sizeof(char *),
     IOOffset(init_contact_msg_ptr, group_type)},
    {(char *) 0, (char *) 0, 0, 0}
};

IOField return_contact_msg_flds[] =
{
    {"host", "string", sizeof(char *), IOOffset(return_contact_msg_ptr,
						host)},
    {"port", "integer", sizeof(int), IOOffset(return_contact_msg_ptr,
					      port)},
  {"group id", "string", sizeof(char *), IOOffset(return_contact_msg_ptr,
						  group_id)},
    {(char *) 0, (char *) 0, 0, 0}
};

IOField remove_group_msg_flds[] =
{
    {"host", "string", sizeof(char *), IOOffset(return_contact_msg_ptr,
						host)},
    {"port", "integer", sizeof(int), IOOffset(return_contact_msg_ptr,
					      port)},
  {"group id", "string", sizeof(char *), IOOffset(return_contact_msg_ptr,
						  group_id)},
    {(char *) 0, (char *) 0, 0, 0}
};

IOField find_matching_msg_flds[] =
{
  {"user_name", "string", sizeof(char *), IOOffset(find_matching_msg_ptr,
						   user_name)},
    {"app_list", "string", sizeof(char *), IOOffset(find_matching_msg_ptr,
						    app_list)},
  {"type_list", "string", sizeof(char *), IOOffset(find_matching_msg_ptr,
						   type_list)},
    {(char *) 0, (char *) 0, 0, 0}
};

IOField comm_group_struct_flds[] =
{
    {"user_name", "string", sizeof(char *),
     IOOffset(comm_group_list, user_name)},
    {"application_name", "string", sizeof(char *),
     IOOffset(comm_group_list, application_name)},
    {"group_type", "string", sizeof(char *),
     IOOffset(comm_group_list, group_type)},
    {"group_id", "string", sizeof(char *),
     IOOffset(comm_group_list, group_id)},
    {"host", "string", sizeof(char *),
     IOOffset(comm_group_list, host)},
    {"port", "integer", sizeof(int),
     IOOffset(comm_group_list, port)},
    {"info_len", "integer", sizeof(int),
     IOOffset(comm_group_list, info_len)},
    {"info[info_len]", "char[info_len]", 1,
     IOOffset(comm_group_list, info)},
    {(char *) 0, (char *) 0, 0, 0,}
};

IOField return_matching_msg_flds[] =
{
    {"count", "integer", sizeof(int), IOOffset(comm_group_return, count)},
    {"list", "comm_group_struct[count]", sizeof(comm_group_struct),
     IOOffset(comm_group_return, list)},
    {(char *) 0, (char *) 0, 0, 0,}
};

IOField assoc_group_info_msg_flds[] =
{
    {"group name", "string", sizeof(char *),
     IOOffset(assoc_group_info_msg_ptr, group_name)},
    {"data_len", "integer", sizeof(int),
     IOOffset(assoc_group_info_msg_ptr, data_len)},
    {"data", "char[data_len]", sizeof(char),
     IOOffset(assoc_group_info_msg_ptr, data)},
    {(char *) 0, (char *) 0, 0, 0,}
};

IOField provisional_use_msg_flds[] =
{
    {"domain", "string", sizeof(char *),
     IOOffset(provisional_use_msg_ptr, domain)},
    {"time", "integer", sizeof(int),
     IOOffset(provisional_use_msg_ptr, time)},
    {(char *) 0, (char *) 0, 0, 0,}
};
