
extern "C"
{
#include <DE.h>
}
#include <stdlib.h>
#include <stream.h>
#include <string.h>

#include "oodeStringMsg.h"

//=============================================================================

static IOField oodeStringMsg_Field_List[] = {
  { "str", "string", sizeof( char* ),
    IOOffset( oodeStringMsg_Struct*, str ) },
  { (char*)0, (char*)0, 0, 0 }
};

static OODEMessage_Static_Info_Struct
oodeStringMsg_Info = {
  sizeof( oodeStringMsg_Struct ),
  "dataexchange_examples_oodeStringMsg",
  oodeStringMsg_Field_List,
  -1, (OODE_Enabled_Messages_Array*)0, (OODE_Enabled_Messages_Array*)0
};

//-----------------------------------------------------------------------------

static char*  oodeStringMsg_str_buffer = 0;
static size_t oodeStringMsg_str_length = 0;

oodeStringMsg::oodeStringMsg()
{
  __data = NULL;
  __info = &oodeStringMsg_Info;
}

#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION

extern "C" {

JNIEXPORT jboolean JNICALL Java_dataexchange_examples_oodeStringMsg_create
  ( JNIEnv* env, jobject obj )
{
  jboolean result = JNI_TRUE;
  oodeStringMsg* cxxjdemessage = new oodeStringMsg();
  if ( ! cxxjdemessage ) {
    cerr << "error: oodeStringMsg.create: can't malloc c++ object!" << endl;
    result = JNI_FALSE;
  } else {
    OODEMessage_Java_Enabled::__set__cxxjdemessage( env, obj, cxxjdemessage );
    result = JNI_TRUE;
  }
  return result;
}

JNIEXPORT void JNICALL Java_dataexchange_examples_oodeStringMsg_destroy
  ( JNIEnv* env, jobject obj )
{
  oodeStringMsg* cxxjdemessage
    = (oodeStringMsg*)
          OODEMessage_Java_Enabled::__get__cxxjdemessage( env, obj,
                      &oodeStringMsg_Info );
  if ( ! cxxjdemessage ) {
    cerr << "error: oodeStringMsg.destroy: can't find c++ object!" << endl;
  } else {
    OODEMessage_Java_Enabled::__zap__cxxjdemessage( env, obj, cxxjdemessage );
    delete cxxjdemessage;
  }
}

JNIEXPORT jstring JNICALL Java_dataexchange_examples_oodeStringMsg_get_1str
  ( JNIEnv* env, jobject obj )
{
  jstring result;
  oodeStringMsg* cxxjdemessage
    = (oodeStringMsg*)
          OODEMessage_Java_Enabled::__get__cxxjdemessage( env, obj,
                      &oodeStringMsg_Info );
  if ( ! cxxjdemessage ) {
    cerr << "error: oodeStringMsg.get_str: can't find c++ object!" << endl;
    result = env->NewStringUTF( "" );
  } else {
    result = env->NewStringUTF( cxxjdemessage->str() );
  }
  return result;
}

JNIEXPORT void JNICALL Java_dataexchange_examples_oodeStringMsg_set_1str
  ( JNIEnv* env, jobject obj, jstring val )
{
  oodeStringMsg* cxxjdemessage
    = (oodeStringMsg*)
          OODEMessage_Java_Enabled::__get__cxxjdemessage( env, obj,
                      &oodeStringMsg_Info );
  if ( ! cxxjdemessage ) {
    cerr << "error: oodeStringMsg.set_str: can't find c++ object!" << endl;
  } else {
    const char* const utf = env->GetStringUTFChars( val, (jboolean*)NULL );
    size_t len = strlen( utf );
    if ( len > oodeStringMsg_str_length ) {
      oodeStringMsg_str_length = len;
      oodeStringMsg_str_buffer
	= (char*)realloc( oodeStringMsg_str_buffer, oodeStringMsg_str_length + 1 );
      if ( ! oodeStringMsg_str_buffer ) {
	cerr << "error: oodeStringMsg.set_str: can't malloc str buffer!" << endl;
	goto cleanup;
      }
    }
    strcpy( oodeStringMsg_str_buffer, utf );
  cleanup:
    env->ReleaseStringUTFChars( val, utf );
    cxxjdemessage->str() = oodeStringMsg_str_buffer;
  }
}

}

#endif

//=============================================================================

