
package examples;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;

import dataexchange.*;

public class oodeClient
implements java.lang.Runnable
{
  public void run()
    {
      OODE lib = new OODE();
      OODExchange exch = new OODExchange( lib );
      OODEPort port = new OODEPort( exch );
      oodeMyMessage msg = new oodeMyMessage();

      BufferedReader br
	= new BufferedReader( new InputStreamReader( System.in ) );

      try {

	System.out.print( "Enter host: " );
	String host_name = br.readLine();

	System.out.print( "Enter port: " );
	long inet_port = Long.parseLong( br.readLine(), 10 );

	if ( lib.create( OODE.DE_WRAPPERS ) ) {

	  if ( exch.create() )

	    if ( port.connect( host_name, inet_port ) )
	      {
		msg.create();
		msg.register_format( exch );
		msg.enable_processing( exch );
		msg.allocate_buffer();

		try {
		  System.out.print( "Enter text: " );
		  String text = br.readLine();
		  while ( text != null ) {
		    if ( text.length() > 0 ) {
		      msg.set_str( text );
		      msg.send( port );
		    }
		    exch.poll_and_handle( false );
		    System.out.print( "Enter text: " );
		    text = br.readLine();
		  }
		} catch ( IOException e ) {
		}

		msg.free_buffer();
		msg.disable_processing( exch );
		msg.destroy();
	      }

	  lib.close();
	}

      } catch ( IOException e ) {
	System.err.println( "Caught IOException: " + e.getMessage() );
      } catch ( NumberFormatException e ) {
	System.err.println( "Caught NumberFormatException: " + e.getMessage() );
      }
    }
  public static void main( String[] args )
    {
      oodeClient client = new oodeClient();
      client.run();
    }
};

