
#include <OODE.h>

#include "oodeStringMsg.h"

#include <stdlib.h>
#include <stream.h>
#include <unistd.h>
#include <string.h>

#ifdef OODE_INHIBIT_JAVA_IMPLEMENTATION
#ifdef OODE_JDE
#undef OODE_JDE
#endif
#endif

//=============================================================================

#ifdef OODE_JDE

#define ParentDE         OODE_Java_Enabled
#define ParentDExchange  OODExchange_Java_Enabled
#define ParentDEPort     OODEPort_Java_Enabled

#else

#define ParentDE         OODE
#define ParentDExchange  OODExchange
#define ParentDEPort     OODEPort

#endif

//=============================================================================

class oodeMyPort : public ParentDEPort
{
public:
  oodeMyPort( OODExchange* exch ) : ParentDEPort( exch ) {}

#ifdef OODE_CXXDE
#ifndef OODE_JDE
protected:
  virtual void open_callback( int )  { cout << '(' << flush; }
  virtual void close_callback( int ) { cout << ')' << flush; }
#endif
#endif
};

//-----------------------------------------------------------------------------

class oodeMyExchange : public ParentDExchange
{
public:
  oodeMyExchange( OODE* lib ) : ParentDExchange( lib ) {}
protected:
  virtual OODEPort* port_factory() { return new oodeMyPort( this ); }
};

//-----------------------------------------------------------------------------

class oodeMyDE : public ParentDE
{
protected:
  virtual OODExchange* exchange_factory()
    { return new oodeMyExchange( this ); }
};

//-----------------------------------------------------------------------------

class oodeMyMessage : public oodeStringMsg
{
protected:
  virtual int filter_callback( OODEPort* )
    { cout << '<' << str() << '>' << flush; return 1; }
  virtual void process_callback( OODEPort* )
    { cout << '"' << str() << '"' << flush; }
};

//#############################################################################

#ifdef OODE_CXXDE

void serve()
{
  oodeMyDE lib;
  oodeMyExchange de( &lib );
  oodeMyMessage msg;

  lib.create( OODE::DE_WRAPPERS );
  de.create();
  msg.enable_filtering( &de );

  de.listen();
  cout << "listening at: "
       << de.host_name() << ' ' << de.inet_port()
       << endl;

  while( de.poll_and_handle( 1 ) ) {
    cout << '#' << flush;
    if ( de.num_ports() == 0 ) cout << endl;
  }

  msg.disable_filtering( &de );
  lib.close();
  cout << endl;
}

//=============================================================================

void connect( char* host, int port, int argc, char** argv )
{
  oodeMyDE lib;
  oodeMyExchange de( &lib );
  oodeMyPort dep( &de );
  oodeMyMessage msg;

  lib.create( OODE::DE_WRAPPERS );
  de.create();
  msg.register_format( &de );
  msg.enable_processing( &de );
  msg.allocate_buffer();

  dep.connect( host, port );

  if ( de.poll_and_handle( 1, 0 ) )
    cout << '*' << flush;
  for ( ; argc > 0; --argc, ++argv ) {
    cout << ' ' << *argv << " #" << flush;
    msg.str() = *argv;
    msg.send( &dep );
    if ( de.poll_and_handle( 1, 0 ) ) {
      cout << '*' << flush;
      sleep( 1 );
    }
  }
  while ( de.poll_and_handle( 1, 0 ) )
    cout << '*' << flush;

  msg.free_buffer();
  msg.disable_processing( &de );
  lib.close();
  cout << endl;
}

#endif

//=============================================================================

#ifdef OODE_JDE

void javavm( char* classname )
{
  JavaVM *jvm;
  JNIEnv *env;
  JDK1_1InitArgs vm_args;

  jclass cls;
  jmethodID mid;
  jclass OODE;
  jclass OODExchange;
  jclass OODEPort;
  jclass OODEMessage;
  jobject obj;
  jthrowable err;
  
  oodeMyDE lib;
  lib.create( OODE::DE_WRAPPERS );

  for ( char* ptr = classname; *ptr; ++ptr )
    if ( *ptr == '.' )
      *ptr = '/';

  JNI_GetDefaultJavaVMInitArgs( &vm_args );
  vm_args.classpath = getenv( "CLASSPATH" );

  if ( JNI_CreateJavaVM( &jvm, &env, &vm_args ) != 0 ) {
    cerr << "couldn't create java virtual machine" << endl;
    return;
  }

  cls = env->FindClass( classname );
  if ( ! cls ) {
    cerr << "couldn't find class " << classname << endl;
    goto java_error;
  }

  mid = env->GetMethodID( cls, "run", "()V" );
  if ( ! mid ) {
    cerr << "couldn't find run method" << endl;
    goto java_error;
  }

  OODE = env->FindClass( "dataexchange/OODE" );
  if ( ! OODE ) {
    cerr << "couldn't find class OODE" << endl;
    goto java_error;
  }

  if ( env->RegisterNatives( OODE,
			     OODE_Java_Enabled::native_methods,
			     OODE_Java_Enabled::num_methods ) != 0 ) {
    cerr << "couldn't register OODE native methods" << endl;
    goto java_error;
  }

  OODExchange = env->FindClass( "dataexchange/OODExchange" );
  if ( ! OODExchange ) {
    cerr << "couldn't find class OODExchange" << endl;
    goto java_error;
  }

  if ( env->RegisterNatives( OODExchange,
			     OODExchange_Java_Enabled::native_methods,
			     OODExchange_Java_Enabled::num_methods ) != 0 ) {
    cerr << "couldn't register OODExchange native methods" << endl;
    goto java_error;
  }

  OODEPort = env->FindClass( "dataexchange/OODEPort" );
  if ( ! OODEPort ) {
    cerr << "couldn't find class OODEPort" << endl;
    goto java_error;
  }

  if ( env->RegisterNatives( OODEPort,
			     OODEPort_Java_Enabled::native_methods,
			     OODEPort_Java_Enabled::num_methods ) != 0 ) {
    cerr << "couldn't register OODEPort native methods" << endl;
    goto java_error;
  }

  OODEMessage = env->FindClass( "dataexchange/OODEMessage" );
  if ( ! OODEMessage ) {
    cerr << "couldn't find class OODEMessage" << endl;
    goto java_error;
  }

  if ( env->RegisterNatives( OODEMessage,
			     OODEMessage_Java_Enabled::native_methods,
			     OODEMessage_Java_Enabled::num_methods ) != 0 ) {
    cerr << "couldn't register OODEMessage native methods" << endl;
    goto java_error;
  }

  obj = env->AllocObject( cls );
  if ( ! obj ) {
    cerr << "couldn't create object of class " << classname << endl;
    goto java_error;
  }

  env->CallVoidMethod( obj, mid );

 java_error:

  err = env->ExceptionOccurred();
  if ( err ) {
    env->ExceptionDescribe();
  }

  jvm->DestroyJavaVM();

  lib.close();
}

#endif

//#############################################################################

int main( int argc, char** argv )
{
  if ( argc == 1 ) {

  usage:

    cerr << "usage:" << endl
#ifdef OODE_CXXDE
	 << "\t for server:\t" << argv[0] << " server" << endl
	 << "\t to connect:\t" << argv[0] << " <hostname> <portnumber>" << endl
#endif
#ifdef OODE_JDE
	 << "\tto run java:\t" << argv[0] << " <classname>" << endl
#endif
      ;

  } else if ( argc == 2 ) {

#ifdef OODE_CXXDE

    if ( strcmp( argv[1], "server" ) == 0 ) {

      serve();

    } else {

#endif
#ifdef OODE_JDE

      javavm( argv[1] );

#else
      goto usage;
#endif
#ifdef OODE_CXXDE
    }
#endif

  } else if ( argc >= 3 ) {

#ifdef OODE_CXXDE
    connect( argv[1], atoi( argv[2] ), argc-3, argv+3 );
#else
    goto usage;
#endif

  }

  return 0;
}

//#############################################################################

