#include "config.h"
#include <stdio.h>
#include <errno.h>

#include <stdlib.h>
#include "useful.h"
#include "io.h"

#include "DE.h"
#ifdef HAVE_GEN_THREAD_H
#include "gen_thread.h"
#endif
#include "de_internal.h"
#include "de_monitor.h"


typedef struct _data_format_name {
    char *format_name;
} data_format_name, *data_format_name_ptr;

typedef struct _register_filter {
    char *format_name;
    int which_filter;
} register_filter, *register_filter_ptr;

typedef struct _register_func {
    char *format_name;
    int which_func;
} register_func, *register_func_ptr;


typedef struct _signon_mesg {
    int which_port;
    char *name;
} signon_mesg, *signon_mesg_ptr;

typedef struct _signoff_mesg {
    int which_port;
    char *name;
} signoff_mesg, *signoff_mesg_ptr;

typedef struct _forward_record {
    char *format_name;
    int which_port;
} forward_record, *forward_record_ptr;

typedef struct _DExchange_data {
    char *exchange_name;	/* my exchange_name */
    int exch_pid;		/* my exch_pid */
    int port;			/* server port as announced to world */
    char *hostname;		/* server's hostname */
    int conn_sock_inet;		/* public sock for IP socket connection */
    char *usock_name;		/* file name for unix socket connection */
    int default_block;		/* flag: how other guys forward data to me */
    DEForwardStyle forward_default;	/* default how we forward things */
    int conn_sock_unix;		/* public sock for Unix socket connection */
    int enable_debug;		/* false if this is an internal hub for
				 * debug output or group server */
    int debug_hub;		/* is there a debug hub enabled ? */
    int portCount;		/* number of current ports */
    DEPort *ports;		/* array of ports index by socket fd */
    int max_formatID;
} DExchange_data, *DExchange_data_ptr;


typedef struct _deport {
    char *port_name;		/* port's exchange_name */
    int exch_pid;		/* port's exch_pid */
    int port;			/* port's port number */
    char *hostname;		/* port's host name */
    char *usock_name;		/* port's unix socket name */
    int fd;
    int notify_on_shutdown;
    int forward_comments;
    int block_by_default;
    int num_local_formats;
} deport_data, *deport_data_ptr;

static IOField data_format_name_field_list[] =
{
    {"format_name", "string", sizeof(char *),
     IOOffset(data_format_name_ptr, format_name)},
    {(char *) 0, (char *) 0, 0, 0}
};

static IOField register_filter_field_list[] =
{
    {"format_name", "string", sizeof(char *),
     IOOffset(register_filter_ptr, format_name)},
    {"which_filter", "integer", sizeof(int),
     IOOffset(register_filter_ptr, which_filter)},
    {(char *) 0, (char *) 0, 0, 0}
};

static IOField register_func_field_list[] =
{
    {"format_name", "string", sizeof(char *),
     IOOffset(register_func_ptr, format_name)},
    {"which_func", "integer", sizeof(int),
     IOOffset(register_func_ptr, which_func)},
    {(char *) 0, (char *) 0, 0, 0}
};

static IOField signon_mesg_field_list[] =
{
    {"name", "string", sizeof(char *),
     IOOffset(signon_mesg_ptr, name)},
    {"which_port", "integer", sizeof(int),
     IOOffset(signon_mesg_ptr, which_port)},
    {(char *) 0, (char *) 0, 0, 0}
};

static IOField signoff_mesg_field_list[] =
{
    {"name", "string", sizeof(char *),
     IOOffset(signoff_mesg_ptr, name)},
    {"which_port", "integer", sizeof(int),
     IOOffset(signoff_mesg_ptr, which_port)},
    {(char *) 0, (char *) 0, 0, 0}
};

static IOField forward_record_field_list[] =
{
    {"format_name", "string", sizeof(char *),
     IOOffset(forward_record_ptr, format_name)},
    {"which_port", "integer", sizeof(int),
     IOOffset(forward_record_ptr, which_port)},
    {(char *) 0, (char *) 0, 0, 0}
};

static IOField DExchange_data_field_list[] =
{
    {"exchange_name", "string", sizeof(char *),
     IOOffset(DExchange_data_ptr, exchange_name)},
    {"exch_pid", "integer", sizeof(int),
     IOOffset(DExchange_data_ptr, exch_pid)},
    {"port", "integer", sizeof(int),
     IOOffset(DExchange_data_ptr, port)},
    {(char *) 0, (char *) 0, 0, 0}
};

static IOField deport_data_field_list[] =
{
    {"portname", "string", sizeof(char *),
     IOOffset(deport_data_ptr, port_name)},
    {"exch_pid", "integer", sizeof(int),
     IOOffset(deport_data_ptr, exch_pid)},
    {"port", "integer", sizeof(int),
     IOOffset(deport_data_ptr, port)},
    {"hostname", "string", sizeof(char *),
     IOOffset(deport_data_ptr, hostname)},
    {"usock_name", "string", sizeof(char *),
     IOOffset(deport_data_ptr, usock_name)},
    {"fd", "integer", sizeof(int),
     IOOffset(deport_data_ptr, fd)},
    {"notify_on_shutdown", "integer", sizeof(int),
     IOOffset(deport_data_ptr, notify_on_shutdown)},
    {"forward_comments", "integer", sizeof(int),
     IOOffset(deport_data_ptr, forward_comments)},
    {"block_by_default", "integer", sizeof(int),
     IOOffset(deport_data_ptr, block_by_default)},
    {"num_local_formats", "integer", sizeof(int),
     IOOffset(deport_data_ptr, num_local_formats)},
    {(char *) 0, (char *) 0, 0, 0}
};



/* 
 *  Sample DE debugging related code below.
 */
typedef struct _DEmonitor_info {
    int data_format_name_sensor_formatID;
    int dexchange_create_sensor_formatID;
    int deport_create_sensor_formatID;
    int signon_msg_sensor_formatID;
    int signoff_msg_sensor_formatID;
    int forward_record_sensor_formatID;
    int register_func_sensor_formatID;
    int register_filter_sensor_formatID;
} *DEmonitor_info;

void *
DEMon_private_info_create()
{
    DEmonitor_info info = DEmalloc(sizeof(struct _DEmonitor_info));
    info->data_format_name_sensor_formatID = -1;
    info->dexchange_create_sensor_formatID = -1;
    info->deport_create_sensor_formatID = -1;
    info->signon_msg_sensor_formatID = -1;
    info->signoff_msg_sensor_formatID = -1;
    info->forward_record_sensor_formatID = -1;
    info->register_func_sensor_formatID = -1;
    info->register_filter_sensor_formatID = -1;
    return info;
}

void
DEMon_data_format_name_sensor(de, format_name)
DExchange de;
char *format_name;
{
    data_format_name tmp_rec;
    DEmonitor_info info;

    if (de->debug_hub == NULL)
	return;
    if (de->debug_hub->portCount == 0)
	return;
    info = (DEmonitor_info) de->debug_hub->monitor_info;

    if (info->data_format_name_sensor_formatID == -1) {
	DExchange_register_format(de->debug_hub, "data_format_name",
				  data_format_name_field_list);
	info->data_format_name_sensor_formatID = DEget_format_id(de->debug_hub,
						     "data_format_name");
    }
    tmp_rec.format_name = format_name;
    DExchange_forward_data(de->debug_hub, NULL,
		       info->data_format_name_sensor_formatID, &tmp_rec);
}


void
DEMon_dexchange_create_sensor(de)
DExchange de;
{
    DExchange_data tmp_rec;
    DEmonitor_info info;

    if (de->debug_hub == NULL)
	return;
    if (de->debug_hub->portCount == 0)
	return;
    info = (DEmonitor_info) de->debug_hub->monitor_info;

    if (info->dexchange_create_sensor_formatID == -1) {
	DExchange_register_format(de->debug_hub, "dexchange_create",
				  DExchange_data_field_list);
	info->dexchange_create_sensor_formatID = DEget_format_id(de->debug_hub,
						     "dexchange_create");
    }
    tmp_rec.port = de->port;
    tmp_rec.exchange_name = "debug exchange";
    tmp_rec.exch_pid = de->exch_pid;
    DExchange_forward_data(de->debug_hub, NULL,
		       info->dexchange_create_sensor_formatID, &tmp_rec);
}


void
DEMon_deport_create_sensor(de, dep)
DExchange de;
DEPort dep;
{
    deport_data tmp_rec;
    DEmonitor_info info;

    if (de->debug_hub == NULL)
	return;
    if (de->debug_hub->portCount == 0)
	return;
    info = (DEmonitor_info) de->debug_hub->monitor_info;

    if (info->deport_create_sensor_formatID == -1) {
	DExchange_register_format(de->debug_hub, "deport_create",
				  deport_data_field_list);
	info->deport_create_sensor_formatID = DEget_format_id(de->debug_hub,
							"deport_create");
    }
    tmp_rec.port_name = strdup(DEport_name(dep));
    tmp_rec.exch_pid = de->exch_pid;
    tmp_rec.port = DEport_port_number(dep);
    tmp_rec.hostname = strdup(DEport_host_name(dep));
    tmp_rec.usock_name = NULL;	/* GSE    = strdup( de->usock_name ); */
    tmp_rec.fd = -1;		/* GSE dep->fd; no longer simple fds */
    tmp_rec.notify_on_shutdown = dep->notify_on_shutdown;
    tmp_rec.forward_comments = dep->forward_comments;
    tmp_rec.block_by_default = dep->block_by_default;
    tmp_rec.num_local_formats = dep->num_local_formats;
    DExchange_forward_data(de->debug_hub, NULL,
			   info->deport_create_sensor_formatID, &tmp_rec);
}




void
DEMon_signon_msg_sensor(de, dep, name)
DExchange de;
DEPort dep;
char *name;
{
    signon_mesg tmp_rec;
    DEmonitor_info info;

    if (de->debug_hub == NULL)
	return;
    if (de->debug_hub->portCount == 0)
	return;
    info = (DEmonitor_info) de->debug_hub->monitor_info;

    if (info->signon_msg_sensor_formatID == -1) {
	DExchange_register_format(de->debug_hub, "signon_message",
				  signon_mesg_field_list);
	info->signon_msg_sensor_formatID = DEget_format_id(de->debug_hub,
						       "signon_message");
    }
    tmp_rec.which_port = -1;	/* GSE dep->fd no longer simple fds */
    tmp_rec.name = name;
    DExchange_forward_data(de->debug_hub, NULL,
			   info->signon_msg_sensor_formatID, &tmp_rec);
}


void
DEMon_signoff_msg_sensor(de, dep, name)
DExchange de;
DEPort dep;
char *name;
{
    signoff_mesg tmp_rec;
    DEmonitor_info info;

    if (de->debug_hub == NULL)
	return;
    if (de->debug_hub->portCount == 0)
	return;
    info = (DEmonitor_info) de->debug_hub->monitor_info;

    if (info->signoff_msg_sensor_formatID == -1) {
	DExchange_register_format(de->debug_hub, "signoff_message",
				  signoff_mesg_field_list);
	info->signoff_msg_sensor_formatID = DEget_format_id(de->debug_hub,
						      "signoff_message");
    }
    tmp_rec.which_port = -1;	/* GSE  no longer simple fds dep->fd; */
    tmp_rec.name = name;
    DExchange_forward_data(de->debug_hub, NULL,
			   info->signoff_msg_sensor_formatID, &tmp_rec);
}


void
DEMon_forward_record_sensor(de, format_name, port)
DExchange de;
char *format_name;
int port;
{
    forward_record tmp_rec;
    DEmonitor_info info;

    if (de->debug_hub == NULL)
	return;
    if (de->debug_hub->portCount == 0)
	return;
    info = (DEmonitor_info) de->debug_hub->monitor_info;

    if (info->forward_record_sensor_formatID == -1) {
	DExchange_register_format(de->debug_hub, "forward_record",
				  forward_record_field_list);
	info->forward_record_sensor_formatID = DEget_format_id(de->debug_hub,
						       "forward_record");
    }
    tmp_rec.which_port = port;
    tmp_rec.format_name = format_name;
    DExchange_forward_data(de->debug_hub, NULL,
			 info->forward_record_sensor_formatID, &tmp_rec);

}


void
DEMon_register_func_sensor(de, format_name, which_func)
DExchange de;
char *format_name;
int which_func;
{
    register_func tmp_rec;
    DEmonitor_info info;

    if (de->debug_hub == NULL)
	return;
    if (de->debug_hub->portCount == 0)
	return;
    info = (DEmonitor_info) de->debug_hub->monitor_info;

    if (info->register_func_sensor_formatID == -1) {
	DExchange_register_format(de->debug_hub, "register_function",
				  register_func_field_list);
	info->register_func_sensor_formatID = DEget_format_id(de->debug_hub,
						    "register_function");
    }
    tmp_rec.which_func = which_func;
    tmp_rec.format_name = format_name;
    DExchange_forward_data(de->debug_hub, NULL,
			   info->register_func_sensor_formatID, &tmp_rec);
}


void
DEMon_register_filter_sensor(de, format_name, which_filter)
DExchange de;
char *format_name;
int which_filter;
{
    register_filter tmp_rec;
    DEmonitor_info info;

    if (de->debug_hub == NULL)
	return;
    if (de->debug_hub->portCount == 0)
	return;
    info = (DEmonitor_info) de->debug_hub->monitor_info;

    if (info->register_filter_sensor_formatID == -1) {
	DExchange_register_format(de->debug_hub, "register_filter",
				  register_filter_field_list);
	info->register_filter_sensor_formatID = DEget_format_id(de->debug_hub,
						      "register_filter");
    }
    tmp_rec.which_filter = which_filter;
    tmp_rec.format_name = format_name;
    DExchange_forward_data(de->debug_hub, NULL,
			info->register_filter_sensor_formatID, &tmp_rec);
}
