#include "config.h"
#include "io.h"
#include "DE.h"
#include "assert.h"
#ifdef HAVE_GEN_THREAD_H
#include "gen_thread.h"
#else
#define gen_thr_initialized() 0
#define thr_mutex_lock(m)
#define thr_mutex_unlock(m)
#endif
#include "de_internal.h"
#include <stdio.h>
#include "useful.h"

extern void
DExchange_context_lock(de)
DExchange de;
{
    if (!gen_thr_initialized())
	return;

    if (de->context_lock) {
	thr_mutex_lock(de->context_lock);
    }
}

extern void
DExchange_context_unlock(de)
DExchange de;
{
    if (!gen_thr_initialized())
	return;

    if (de->context_lock) {
	thr_mutex_unlock(de->context_lock);
    }
}

extern void
DExchange_lock(de)
DExchange de;
{
    if (gen_thr_initialized() && de->exchange_lock) {
	thr_mutex_lock(de->exchange_lock);
    }
    de->locked++;
}

extern void
DExchange_unlock(de)
DExchange de;
{
    de->locked--;
    if (gen_thr_initialized() && de->exchange_lock) {
	thr_mutex_unlock(de->exchange_lock);
    }
}

extern void
DExchange_assert_lock(de)
DExchange de;
{
    assert(de->locked == 1);
}

extern void
DEControlList_lock(cl)
DEControlList cl;
{
    if (!gen_thr_initialized())
	return;

    if (cl->control_list_lock) {
	thr_mutex_lock(cl->control_list_lock);
    }
}

extern void
DEControlList_unlock(cl)
DEControlList cl;
{
    if (!gen_thr_initialized())
	return;

    if (cl->control_list_lock) {
	thr_mutex_unlock(cl->control_list_lock);
    }
}

extern void
DEPort_write_lock(de, dep)
DExchange de;
DEPort dep;
{
    if (!gen_thr_initialized())
	return;

    if (dep->write_lock) {
	thr_mutex_lock(dep->write_lock);
    }
}

extern void
DEPort_write_unlock(de, dep)
DExchange de;
DEPort dep;
{
    if (!gen_thr_initialized())
	return;

    if (dep->write_lock) {
	thr_mutex_unlock(dep->write_lock);
    }
}

extern void
DEPort_read_lock(de, dep)
DExchange de;
DEPort dep;
{
    if (!gen_thr_initialized())
	return;

    if (dep->read_lock) {
	thr_mutex_lock(dep->read_lock);
    }
}

extern void
DEPort_read_unlock(de, dep)
DExchange de;
DEPort dep;
{
    if (!gen_thr_initialized())
	return;

    if (dep->read_lock) {
	thr_mutex_unlock(dep->read_lock);
    }
}
