#define is_system_format(de, i) ((de)->format_list[(i)].system_format)
#define is_fixed_format(de, i) ((de)->format_list[(i)].fixed_format)

#ifndef GEN_THREAD_H
#define thr_mutex_t void*
#define thr_thread_t void *
#endif

typedef struct _ioformat_data {
    char *format_name;		/* pbio name of the format */
    DEForwardStyle forward_policy;
    int system_format;
    int fixed_format;
    /* field list for writing this record */
    IOFieldList internal_field_list;

    int internal_pointer_size;
    int filter_count;
    DataHandlingFunc *filter;
    void **filter_data;
    int funct_count;
    DataHandlingFunc *funct;
    void **funct_data;
    int thr_funct_count;
    DataHandlingFunc *thr_funct;
    void **thr_funct_data;
} ioformat_data;

typedef struct _port_format_info {
    /* whether or not to forward records of this  format to this port */
    int forward_data;
    /* the local output format handle for this port */
    IOFormat output_format;	
    /* the local input format handle for this port */
    IOFormat input_format;	
} port_format_info;

typedef struct _DEPort {
    DExchange de;		/* this port's server */
    char *exchange_name;	/* port's exchange_name */
    int exch_pid;		/* port's exch_pid */
    int port;			/* port's IP port number */
    char *hostname;		/* port's host name */
    IOFile to_port;
    thr_mutex_t write_lock;
    IOFile from_port;
    thr_mutex_t read_lock;
    /* whether or not to notify this  port of shutdown */
    int notify_on_shutdown;	
    int closed;

    /* 
     * array maps local (incoming) format IDs to the corresponding 
     * global formatID 
     */
    int *local_to_global_formatID;
    int forward_comments;
    /* block_by_default is true if the default is to block new data */
    int block_by_default;	
    int num_local_formats;
    /* port-specific info on global formats indexed by global formatID */
    port_format_info *formats;	
    OpenCloseHandlingFunc port_close_handler;

    int childPortCount;		/* number of child DEport structs */
    DEPort *childPorts;		/* one child per possible receiver */
    DEPort parentPort;		/* pointer back to parent port */
   /* used for connectionless protocols to hold sender information */
    void *client_data;		
    ReadFunc dg_read;
    WriteFunc dg_write;
    ShutdownFunc dg_shutdown;
    GetNewCliFunc dg_get_cli;	/* returns new client_data */
    AddrCmpFunc dg_addrCmp;	/* compares two addresses for match */

} DEPort_s, *DEPort_s_ptr;


typedef struct _DESavedRec {
    int format_id;
    char *data;
    int length;
    DEPort dep;
    struct _DESavedRec *prev;
    struct _DESavedRec *next;
} DESavedRec;

typedef enum {
    unknown_type, integer_type, unsigned_type, float_type,
    char_type, string_type, enumeration_type
} IOdata_type;

typedef struct _DERecField {
    IOFieldPtr io_field_ptr;
    IOdata_type get_type;
    int get_size;
    DExchange de;
    struct _DERecField *prev;
    struct _DERecField *next;
} DERecField;

typedef struct FunctionListElement {
    GenericHandlerFunc func;
    void *dep;
    void *arg;
} FunctionListElement;

typedef struct PendingConnElement {
    char *host;
    int port;
    int *notify_list;
} *PendingConnList;

typedef struct buffer_data_s {
    char *data_buffer;		/* buffer for data */
    int buffer_size;
    int buffer_taken;
} *buffer_data_p;

typedef struct _DExchange {
    char *exchange_name;	/* my exchange_name */
    int exch_pid;		/* my exch_pid */
    int port;			/* server port as announced to world */
    char *hostname;		/* server's hostname */
    int default_block;		/* flag: how other guys forward data to me 
				 * 
				 */
    DEForwardStyle forward_default;	/* how we forward things by
					 * default. */
    int enable_debug;		/* false if this is an internal hub  for
				 * debug output or group server */
    int debug_flag;		/* flags for de-specific debugging output */
    int data_debug_flag;
    int no_debug_flag;
    DExchange debug_hub;	/* the debug hub for this DE */
    void *monitor_info;		/* internal used by de_monitor.c */
    DEControlList control_list;	/* the control list for this DE */
    int portCount;		/* number of current ports */
    DEPort *ports;		/* array of ports index by count */
    PendingConnList pending_conns;
    ioformat_data *format_list;
    int max_formatID;
    int max_handler_level;
    int handler_level;
    buffer_data_p buffer_data;
    FormatHandlingFunc format_handler;
    CommentHandlingFunc comment_handler;
    OpenCloseHandlingFunc port_close_handler;
    OpenCloseHandlingFunc open_handler;
    FunctionListElement *close_callbacks;
    thr_mutex_t exchange_lock;
    int locked;
    int closed;

    InitiateConnFunc init_conn_func;
    ListenFunc listen_func;

    DESavedRecPtr queued_records;
    DERecFieldPtr active_fields;

    IOContext context;		/* pbio context for connectionless comm */
    thr_mutex_t context_lock;

    int channel_count;
    EChannel *channel_list;
} DExchange_s;

#define BUF_SIZE(de) de->buffer_data[de->handler_level].buffer_size
#define DATA_BUF(de) de->buffer_data[de->handler_level].data_buffer
#define BUF_TAKEN(de) de->buffer_data[de->handler_level].buffer_taken
typedef struct _DECondition *DECondition;


typedef struct free_block_rec {
    int ref_count;
    DExchange de;
    void *block;
    EventFreeFunction free_func;
    DExchange locking_de;
} *free_block_rec_p;

typedef struct _event_item {
    struct _event_item *next;
    struct _event_item *prev;
    EChannel chan;
    int sink_index;
    void *event;
    int event_len;
    IOEncodeVector eventv;
    free_block_rec_p block_rec;
} event_item, *event_queue;

typedef struct _DEControlList {
    void *fdset;		/* bitmap of the fds for read select */
    int sel_item_max;		/* number of current select_items */
    /* array of func(arg1,arg2) indexed by fd to select on */
    FunctionListElement *select_items;

    int poll_item_count;	/* number of current poll items */
    /* array of func(arg1,args) to be called at each select point */
    FunctionListElement *poll_items;
    int select_consistency_number;

    /* 
     * CLs can be used by multiple DEs, close it when ref count reaches
     * zero 
     */
    int reference_count;
    int free_reference_count;

    /* the control style used by this program */
    DEControlStyle control_style;
    thr_thread_t server_thread;

    /* fds used to wake server threads when we need to */
    int wake_read_fd;
    int wake_write_fd;

    thr_mutex_t control_list_lock;

    DECondition condition_list;
    int next_condition_num;

    event_queue event_queue_head;
    event_queue event_queue_tail;

    DEtask_handle periodic_task_list;
    int closed;
} DEControlList_s;

extern void *(*DEmalloc) ARGS((int size));
extern void *(*DErealloc) ARGS((void *block, int size));
extern void (*DEfree) ARGS((void *block));

extern void
DErewrite_queued_data ARGS((DExchange de, int format_id,
			    IOFieldList old_field_list,
			    int old_struct_size, int old_pointer_size,
			    IOFieldList new_field_list,
			    int new_struct_size, int new_pointer_size));

extern int
DEChannel_Attend_handler ARGS((DExchange de, DEPort dep,
			       int attend_format_id, void *data,
			       int data_length, void *client_data));

extern int
DEChannel_Attend_Response_handler ARGS((DExchange de, DEPort dep,
					int attend_response_format_id,
					void *data, int data_length,
					void *client_data));
extern int
DEChannel_Exists_Attend_Response_handler ARGS((DExchange de, DEPort dep,
					int exists_attend_response_format_id,
					void *data, int data_length,
					void *client_data));

extern int
DEChannel_Derive_handler ARGS((DExchange de, DEPort dep,
			       int attend_format_id, void *data,
			       int data_length, void *client_data));

extern int
DEChannel_Source_Derive_handler ARGS((DExchange de, DEPort dep,
				      int attend_format_id, void *data,
				      int data_length, void *client_data));

extern int
DEProto_Derive_handler ARGS((DExchange de, DEPort dep,
			     int format_id, void *data,
			     int data_length, void *client_data));

extern int
DEChannel_Source_Derive_Resp_handler ARGS((DExchange de, DEPort dep,
					int attend_format_id, void *data,
				    int data_length, void *client_data));

extern int
DEChannel_Event_handler ARGS((DExchange de, DEPort dep,
			      int event_format_id,
			      void *data, int data_length,
			      void *client_data));

extern int
DEChannel_EventV_handler ARGS((DExchange de, DEPort dep,
			       int event_format_id,
			       void *data, int data_length,
			       void *client_data));

extern int
DEData_Update_handler ARGS((DExchange de, DEPort dep,
			    int data_update_format_id, void *data,
			    int data_length, void *client_data));

extern int
DEChannel_SinkSubscribe_handler ARGS((DExchange de, DEPort dep,
				      int sink_subscribe_format_id,
				      void *data, int data_length,
				      void *client_data));
extern int
DEChannel_SinkUnsubscribe_handler ARGS((DExchange de, DEPort dep,
					int sink_subscribe_format_id,
					void *data, int data_length,
					void *client_data));

extern int
DEChannel_SourceSubscribe_handler ARGS((DExchange de, DEPort dep,
					int source_subscribe_format_id,
					void *data, int data_length,
					void *client_data));
extern int
DEChannel_SourceUnsubscribe_handler ARGS((DExchange de, DEPort dep,
					  int source_subscribe_format_id,
					  void *data, int data_length,
					  void *client_data));

extern int
DEChannel_RequestEvent_handler ARGS((DExchange de, DEPort dep, 
				     int event_format_id, 
				     void *data, int data_length,
				     void *client_data));

/* fabianb - end */

extern int
DEChannel_MemberSubscribe_handler ARGS((DExchange de, DEPort dep,
					int member_subscribe_format_id,
					void *data, int data_length,
					void *client_data));

extern int DExchange_inet_listen ARGS((DExchange de, int int_port_num));
extern DEPort DExchange_inet_initiate_conn ARGS((DExchange de, char *name_str,
						 int int_port_num,
						 int block_by_default));
void wake_DE_server ARGS((DExchange de));
extern void DEControlList_event_flush ARGS((DEControlList control_list));
extern void DEport_fail_conditions ARGS((DEPort dep));
extern int EC_break_up_triple ARGS((char *chan_id, char **host_ptr,
				    int *port_ptr, char **chan_str,
				    void **addr_ptr));

extern int DE_Channel_Attend_Response_format_id;
extern int DE_Channel_Attend_format_id;
extern int DE_Channel_Derive_format_id;
extern int DE_Channel_Exists_Attend_Response_format_id;
extern int DE_Channel_Source_Derive_Resp_format_id;
extern int DE_Channel_Source_Derive_format_id;
extern int DE_Data_Update_Message_format_id;
extern int DE_EventV_Message_format_id;
extern int DE_Event_Message_format_id;
extern int DE_Member_Subscribe_format_id;
extern int DE_Proto_Derive_format_id;
extern int DE_Request_Event_format_id;
extern int DE_Sink_Subscribe_format_id;
extern int DE_Sink_Unsubscribe_format_id;
extern int DE_Source_Subscribe_format_id;
extern int DE_Source_Unsubscribe_format_id;
extern int DE_format_signoff_message_format_id;
extern int DE_format_signon_message_format_id;
extern int DE_shut_down_message_format_id;
