typedef int (*FilterFunc) ARGS((void *, void *, void*));

typedef struct _ECID {
    char *home_host;
    int IPport;
    unsigned char channel[16];
} ECID;

typedef struct _rem_attendr {
    DEPort dep;
    unsigned char channel[8];
} *rem_attendr_list;

typedef struct _local_sink {
    void *client_data;
    ECHandlerFunction func;
    DExchange de;
    IOContext context;
    IOFieldList field_list;
    DEFormatList format_list;
    IOFormat format;  
    int cond;
} *local_sink_ptr;

typedef struct _derived_source {
    FilterFunc filter;
    int has_output_param;
    int target_type_len;
#ifndef NO_DERIVED
    ecl_code code_struct;
#endif
    EChannel derived_chan;
    ECSourceHandle source_handle;
} *derived_source;

typedef struct _local_source {
    void *client_data;
    ECRequestHandlerFunction func;
    ECSourceHandle source_handle;
} *local_source_ptr;

typedef struct _derived_chan {
    char *filter;
    int has_output_param;
    EChannel derived_chan;
} *derived_chan;

typedef struct _EChannel {
    int sink_count;
    int source_count;
    ECID global_id;

    int rem_sink_list_len;
    rem_attendr_list rem_sink_list;

    int rem_source_list_len;
    rem_attendr_list rem_source_list;

    int rem_member_list_len;
    rem_attendr_list rem_member_list;
    int local_sink_list_len;
    local_sink_ptr local_sink_list;
    int local_source_list_len;
    local_source_ptr local_source_list;

    int der_list_len;
    derived_chan der_chan_list;

    int parent_list_len;
    EChannel *parent_chan_list;

    /* type info */
    IOContext subcontext;
    IOFormat type_format;
    void *filter_data;
    IOFieldList data_field_list;
    DEFormatList data_format_list;

    thr_mutex_t lock;
    ECSubscribeFunction subscribe_func;
    void *subscribe_client_data;
    
    void *periodic_info;
    DExchange de;
    int ready;
} EChannel_struct;

typedef struct _ECSinkHandle {
    EChannel chan;
    int sink_num;
} ECSinkStruct;

typedef struct _ECSourceHandle {
    EChannel chan;
    IOFormat ioformat;
    int source_num;
    int der_list_len;
    derived_source der_source_list;
} ECSourceStruct;

typedef struct _AttendMsg {
    char *chan_str;
    int cond;
    char client_channel[8];
} AttendMsg, *AttendMsgPtr;

typedef struct _SinkSubscribeMsg {
    char server_channel[8];
    char client_channel[8];
} SinkSubscribeMsg, *SinkSubscribeMsgPtr;

/* basically the same but still ... */
typedef struct _SourceSubscribeMsg {
    char server_channel[8];
    char client_channel[8];
} SourceSubscribeMsg, *SourceSubscribeMsgPtr;

typedef struct _ExistsAttendResponseMsg {
    int condition;
    unsigned char channel[8];
} ExistsAttendResponseMsg, *ExistsAttendResponseMsgPtr;

typedef struct _AttendRec {
    char *host;
    int IPport;
    unsigned char channel[8];
    char *filter;
    int filter_has_output_param;
} AttendRec, *AttendRecPtr;

typedef struct _AttendResponseMsg {
    int condition;
    char *type_name;
    int sink_count;
    AttendRec *sinks;
    int source_count;
    AttendRec *sources;
    int member_count;
    AttendRec *members;
    int der_count;
    AttendRec *derivatives;
} AttendResponseMsg, *AttendResponseMsgPtr;

typedef struct _MemberSubscribeMsg {
    char server_channel[8];
    char client_channel[8];
} MemberSubscribeMsg, *MemberSubscribeMsgPtr;

typedef struct _RequestEventMsg {
    char channel[8];
} RequestEventMsg, *RequestEventMsgPtr;

typedef struct _EventMsg {
    char channel[8];
    char global_chan_id[16];
    int event_len;
    char *event;
} EventMsg, *EventMsgPtr;

typedef struct _EventVMsg {
    char channel[8];
    char global_chan_id[16];
    int eventv_len;
    IOEncodeVector eventv;
} EventVMsg, *EventVMsgPtr;

typedef struct _FormatListElement {
    char *format_name;
    int field_list_len;
    IOFieldList field_list;
} format_list_element;

#ifdef STDC_HEADERS
extern void ECtrace_out ARGS((char *format, int direction, ...));
#else
extern void ECtrace_out();
#endif
extern void dump_EChannel ARGS((EChannel chan));
extern void DEChannel_close_handler ARGS((DExchange de, DEPort dep));
extern EChannel string_to_channel_ptr ARGS((char *chan_id));
extern int channel_verbose;
extern int do_internal_source_derive ARGS((ECSourceHandle src,
					   EChannel der_chan, 
					   char *filter, 
					   IOFieldList input_field_list,
					   DEFormatList input_format_list,
					   IOFieldList output_field_list,
					   DEFormatList output_format_list,
					   IOFieldList data_field_list,
					   DEFormatList data_format_list));
extern void
remove_derived_channel ARGS((EChannel parent_chan, EChannel der_chan));

extern void DEperiodic_info_free ARGS((void *vperiodic));
extern void EChannel_register_subformats ARGS((IOContext context,
					       IOFieldList field_list,
					       DEFormatList format_list));
extern void EChannel_lock ARGS((EChannel chan));
extern void EChannel_unlock ARGS((EChannel chan));
