/*-*- c++ -*-*/

#ifndef OODE__H__
#define OODE__H__

#include "config.h"
#include <sys/types.h>

//#############################################################################
//##                                                       FORWARD DECLARATIONS
//-----------------------------------------------------------------------------
//-- public declarations

class OODE;
class OODExchange;
class OODEPort;
class OODEMessage;

#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION

class OODE_Java_Enabled;
class OODExchange_Java_Enabled;
class OODEPort_Java_Enabled;
class OODEMessage_Java_Enabled;

#endif

//-----------------------------------------------------------------------------
//-- internal declarations

class OODExchange_Array;
class OODEPort_Array;
class OODEMessage_Array;
class OODE_Enabled_Messages_Array;

typedef struct _DExchange *DExchange;
typedef struct _DEPort *DEPort;
typedef struct _IOField *IOFieldList;

//=============================================================================
//== jni function declarations

#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION

#define OODE_JNI_EXTERN_C_OPEN     extern "C" {
#define OODE_JNI_FRIEND
#define OODE_JNI_EXTERN_C_CLOSE    }

#include <jni.h>

// forward declare all jni functions
#include "OODEJNI.h"

#undef OODE_JNI_EXTERN_C_OPEN
#undef OODE_JNI_FRIEND
#undef OODE_JNI_EXTERN_C_CLOSE

#endif

//=============================================================================
//== setup macros for friend declarations

#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION

#define OODE_JNI_EXTERN_C_OPEN
#define OODE_JNI_FRIEND            friend
#define OODE_JNI_EXTERN_C_CLOSE

#endif

//#############################################################################
//##                                                                       OODE

class OODE
{
  public: OODE();
  public: virtual ~OODE();

  public: enum { NOT_RUNNING = 0,
		 DE_WRAPPERS = 1 };

  public: int   create( int configuration );
  public: int   configuration();
  public: void  close();

  public:        void  init_block_check();
  public: static void  print_version();

  public: short         num_exchanges();
  public: OODExchange*  get_exchange( short index );

  protected: virtual OODExchange* exchange_factory();

  public: enum { NEVER_FORWARD  = 0,
		 ALL_BUT_SENDER = 1,
		 FORWARD_TO_ALL = 2 };

  public: enum { CONNECTION = 0,
		 INPUT      = 1,
		 OUTPUT     = 2,
		 ALL        = 3,
		 ALL_INPUT  = 4,
		 ALL_OUTPUT = 5,
		 SYSTEM     = 7 };

  //---------------------------------------------------------------------------

  private: int                __configuration;
  private: OODExchange_Array* __exchange_array;

  private: static void __comment_callback( DExchange, DEPort, char* );
  private: static void __open_callback( DExchange, DEPort );
  private: static void __close_callback( DExchange, DEPort );

  private: static OODE* __the_running_oode;

  private: int __java_enabled;

  friend class OODExchange;
  friend class OODEPort;
  friend class OODEMessage;
  friend class OODExchange_Array;
  friend class OODEPort_Array;
  friend class OODEMessage_Array;
#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION
  friend class OODE_Java_Enabled;
  friend class OODExchange_Java_Enabled;
  friend class OODEPort_Java_Enabled;
  friend class OODEMessage_Java_Enabled;
  // make all jni functions friends
#include "OODEJNI.h"
#endif
};

//=============================================================================
//==                                                          OODE_Java_Enabled

#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION

class OODE_Java_Enabled : public OODE
{
  public: OODE_Java_Enabled();
  public: virtual ~OODE_Java_Enabled();

  protected: virtual OODExchange* exchange_factory();

  public: enum { num_methods = 9 };
  public: static JNINativeMethod native_methods[num_methods];

  //---------------------------------------------------------------------------

  private: jobject __java_this;
  private: int __java_created;

  friend class OODE;
  friend class OODExchange;
  friend class OODEPort;
  friend class OODEMessage;
  friend class OODExchange_Array;
  friend class OODEPort_Array;
  friend class OODEMessage_Array;
#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION
  friend class OODExchange_Java_Enabled;
  friend class OODEPort_Java_Enabled;
  friend class OODEMessage_Java_Enabled;
  // make all jni functions friends
#include "OODEJNI.h"
#endif
};

#endif

//#############################################################################
//##                                                                OODExchange

class OODExchange
{
  public: OODExchange( OODE* );
  public: virtual ~OODExchange();

  public: int   create();
  public: int   running();
  public: void  close();

  public: void  change_default_blocking( int block );
  public: void  change_default_forwarding( int style );

  public: void  set_format_forwarding( char* format, int style );
  public: void  set_format_fixed( char* format, int flag );

  public: char* listen( char* user, char* app, char* group, int timeout );
  public: int   listen( char* unix_socket );
  public: int   listen( int inet_port );
  public: int   listen();

  public: void  enable_comment_handling();

  public: int   poll_and_handle( int block );
  public: int   poll_and_handle( int timeout_seconds, int micro_seconds );

  public: char* exchange_name();
  public: char* host_name();
  public: long  inet_port();

  public: int        num_ports();
  public: OODEPort*  get_port( int index );

  protected: virtual OODEPort* port_factory();

  //---------------------------------------------------------------------------

  private: OODE* __cxxde;
  private: DExchange __dexchange;
  private: int __running;
  private: int __default_blocking;
  private: OODEPort_Array* __port_array;

  private: int __java_enabled;

  friend class OODE;
  friend class OODEPort;
  friend class OODEMessage;
  friend class OODExchange_Array;
  friend class OODEPort_Array;
  friend class OODEMessage_Array;
#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION
  friend class OODE_Java_Enabled;
  friend class OODExchange_Java_Enabled;
  friend class OODEPort_Java_Enabled;
  friend class OODEMessage_Java_Enabled;
  // make all jni functions friends
#include "OODEJNI.h"
#endif
};

//=============================================================================
//==                                                   OODExchange_Java_Enabled

#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION

class OODExchange_Java_Enabled : public OODExchange
{
  public: OODExchange_Java_Enabled( OODE* );
  public: virtual ~OODExchange_Java_Enabled();

  protected: virtual OODEPort* port_factory();

  public: enum { num_methods = 21 };
  public: static JNINativeMethod native_methods[num_methods];

  //---------------------------------------------------------------------------

  private: jobject __java_this;
  private: int __java_created;

  private: static unsigned int __java_obj_count;

  private: static JNIEnv* __polling_env;
  private: static jobject __polling_obj;

  friend class OODE;
  friend class OODExchange;
  friend class OODEPort;
  friend class OODEMessage;
  friend class OODExchange_Array;
  friend class OODEPort_Array;
  friend class OODEMessage_Array;
#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION
  friend class OODE_Java_Enabled;
  friend class OODEPort_Java_Enabled;
  friend class OODEMessage_Java_Enabled;
  // make all jni functions friends
#include "OODEJNI.h"
#endif
};

#endif

//#############################################################################
//##                                                                   OODEPort

class OODEPort
{
  public: OODEPort( OODExchange* );
  public: virtual ~OODEPort();

  public: int connect( char* user, char* app, char* group );
  public: int connect( char* host_name, long inet_port );
  public: int connect( char* unix_socket );
  public: int read( char* file_name );
  public: int write( char* file_name );
  protected: virtual void open_callback( int accepted );

  public: int attached();

  public: void close();
  protected: virtual void close_callback( int accepted );

  public: void comment( char* msg );
  protected: virtual void comment_callback( char* comment );

  public: int shutdown( int flag, char* message );

  public: int set_format_blocking( char* format, int block );

  public: char* port_name();
  public: char* host_name();
  public: long  port_number();

  public: OODExchange* exchange();

  //---------------------------------------------------------------------------

  private: OODExchange* __cxxdexchange;
  private: int __lib_created;
  private: int __attached;
  private: DEPort __deport;

  private: int __java_enabled;

  friend class OODE;
  friend class OODExchange;
  friend class OODEMessage;
  friend class OODExchange_Array;
  friend class OODEPort_Array;
  friend class OODEMessage_Array;
#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION
  friend class OODE_Java_Enabled;
  friend class OODExchange_Java_Enabled;
  friend class OODEPort_Java_Enabled;
  friend class OODEMessage_Java_Enabled;
  // make all jni functions friends
#include "OODEJNI.h"
#endif
};

//=============================================================================
//==                                                      OODEPort_Java_Enabled

#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION

class OODEPort_Java_Enabled : public OODEPort
{
  public: OODEPort_Java_Enabled( OODExchange* );
  public: virtual ~OODEPort_Java_Enabled();

  protected: virtual void open_callback( int accepted );
  protected: virtual void close_callback( int accepted );
  protected: virtual void comment_callback( char* comment );

  public: enum { num_methods = 16 };
  public: static JNINativeMethod native_methods[num_methods];

  //---------------------------------------------------------------------------

  private: jobject __java_this;
  private: int __java_created;

  private: static unsigned int __java_obj_count;

  friend class OODE;
  friend class OODExchange;
  friend class OODEPort;
  friend class OODEMessage;
  friend class OODExchange_Array;
  friend class OODEPort_Array;
  friend class OODEMessage_Array;
#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION
  friend class OODE_Java_Enabled;
  friend class OODExchange_Java_Enabled;
  friend class OODEMessage_Java_Enabled;
  // make all jni functions friends
#include "OODEJNI.h"
#endif
};

#endif

//#############################################################################
//##                                                                OODEMessage

class OODEMessage
{
  public: OODEMessage();
  public: virtual ~OODEMessage();

  public: virtual int allocate_buffer();
  public: virtual void free_buffer();

  public: void enable_filtering( OODExchange* );
  public: void disable_filtering( OODExchange* );
  protected: virtual int filter_callback( OODEPort* from_port );

  public: void enable_processing( OODExchange* );
  public: void disable_processing( OODExchange* );
  protected: virtual void process_callback( OODEPort* from_port );

  public: int  send( OODEPort* to_port );
  public: void forward( OODEPort* as_if_from_port );

  public: void register_format( OODExchange* exch );
  public: void set_format_fixed( OODExchange* exch, int flag );
  public: void set_format_forwarding( OODExchange* exch, int style );
  public: int  set_format_blocking( OODEPort* port, int block );

  public: void take_buffer();

  //---------------------------------------------------------------------------

  protected: void* __data;
  private: static void* __tmp_data;
  private: static DExchange __tmp_de;
  protected: struct OODEMessage_Static_Info_Struct* __info;

  //---------------------------------------------------------------------------

  private: static struct OODEMessage_Static_Info_Struct* __null_message_info;
  private: static int __filter_callback( DExchange, DEPort,
					 int, void*, int, void* );
  private: static int __process_callback( DExchange, DEPort,
					  int, void*, int, void* );

  private: int __java_enabled;

  friend class OODE;
  friend class OODExchange;
  friend class OODEPort;
  friend class OODExchange_Array;
  friend class OODEPort_Array;
  friend class OODEMessage_Array;
#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION
  friend class OODE_Java_Enabled;
  friend class OODExchange_Java_Enabled;
  friend class OODEPort_Java_Enabled;
  friend class OODEMessage_Java_Enabled;
  // make all jni functions friends
#include "OODEJNI.h"
#endif
};

struct OODEMessage_Static_Info_Struct {
//  size_t __size;
  int __size;
  char* __name;
  IOFieldList __field_list;
  int __format_ID;
  OODE_Enabled_Messages_Array*  __filtering_array;
  OODE_Enabled_Messages_Array*  __processing_array;
};

//=============================================================================
//==                                                   OODEMessage_Java_Enabled

#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION

class OODEMessage_Java_Enabled : public OODEMessage
{
  public: OODEMessage_Java_Enabled();
  public: virtual ~OODEMessage_Java_Enabled();

  protected: virtual int filter_callback( OODEPort* from_port );
  protected: virtual void process_callback( OODEPort* from_port );

  public: enum { num_methods = 15 };
  public: static JNINativeMethod native_methods[num_methods];

  //---------------------------------------------------------------------------

  public: static OODEMessage_Java_Enabled*
     __get__cxxjdemessage( JNIEnv*, jobject, OODEMessage_Static_Info_Struct* );
  public: static void
     __set__cxxjdemessage( JNIEnv*, jobject, OODEMessage_Java_Enabled* );
  public: static void
     __zap__cxxjdemessage( JNIEnv*, jobject, OODEMessage_Java_Enabled* );

  private: jobject __java_this;
  private: int __java_created;

  private: static unsigned int __java_obj_count;

  friend class OODE;
  friend class OODExchange;
  friend class OODEPort;
  friend class OODEMessage;
  friend class OODExchange_Array;
  friend class OODEPort_Array;
  friend class OODEMessage_Array;
#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION
  friend class OODE_Java_Enabled;
  friend class OODExchange_Java_Enabled;
  friend class OODEPort_Java_Enabled;
  // make all jni functions friends
#include "OODEJNI.h"
#endif
};

#endif

#ifndef OODE_INHIBIT_JAVA_IMPLEMENTATION
typedef OODEMessage_Java_Enabled OODEMessage_Parent;
#else
typedef OODEMessage OODEMessage_Parent;
#endif

//#############################################################################

#endif

