/* $Id: DE.h,v 1.57 2000/11/12 19:12:49 eisen Exp $ */
/* This is the include file for dataexchange */


#ifndef __DATAEXCHANGE__H__
#define __DATAEXCHANGE__H__

#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus)
#ifndef ARGS
#define ARGS(args) args
#endif
#else
#ifndef ARGS
#define ARGS(args) (/*args*/)
#endif
#endif

#include "io.h"
extern int DE_debug_flag;

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define MAX_DG_BUF_SIZ 65536

typedef enum _ShutDownFlag {
    SHUTDOWN_CONNECTION,	/* shutdown both in and out connection */
    SHUTDOWN_CONNECTION_INPUT,	/* shutdown input connection */
    SHUTDOWN_CONNECTION_OUTPUT,	/* shutdown output connection */
    SHUTDOWN_ALL_CONNECTION,	/* shutdown all connection & server */
    SHUTDOWN_ALL_INPUT,		/* shutdown all input connections */
    SHUTDOWN_ALL_OUTPUT,	/* shutdown all output connections */
    SHUTDOWN_SERVER,		/* shutdown this server */
    SHUTDOWN_SYSTEM		/* shutdown whole system */
} ShutDownFlag;

typedef struct _DEformat_list {
    char *format_name;
    IOFieldList field_list;
}DEFormat, *DEFormatList;

struct _DEControlList;
struct _DExchange;
struct _DEPort;
struct _DESavedRec;
typedef int (*DataHandlingFunc) ARGS((struct _DExchange *, struct _DEPort *,
				      int, void *, int, void *));
typedef void (*FormatHandlingFunc) ARGS((struct _DExchange *,
					 struct _DEPort *, char *));
typedef void (*CommentHandlingFunc) ARGS((struct _DExchange *,
					  struct _DEPort *, char *));
typedef void (*OpenCloseHandlingFunc) ARGS((struct _DExchange *,
					    struct _DEPort *));

typedef struct _DEControlList *DEControlList;
typedef struct _DExchange *DExchange;
typedef struct _DEPort *DEPort;
typedef struct _DESavedRec *DESavedRecPtr;

typedef enum _DEForwardStyle {
    DENever_Forward, DEAll_But_Sender, DEForward_To_All
} DEForwardStyle;

typedef enum _DEControlStyle {
    DESingleThreaded, DEDedicatedServerThread, DEOccasionalPolling
} DEControlStyle;

extern DExchange DExchange_create();
extern DEControlList DEControlList_create();
extern DEControlList DExchange_get_control_list ARGS((DExchange));
extern void DEControlList_associate ARGS((DEControlList cl, DExchange de));

extern void DEControlList_close ARGS((DEControlList cl));
extern void DEControlList_free ARGS((DEControlList cl));
extern void DEControlList_set_control_style ARGS((DEControlList cl,
						  DEControlStyle style));
extern DEControlStyle DEControlList_get_control_style ARGS((DEControlList cl));
extern void DExchange_set_forward ARGS((DExchange, DEForwardStyle));
extern void DExchange_set_format_forward ARGS((DExchange, char *, DEForwardStyle));
extern void DExchange_set_block_default ARGS((DExchange, int));
extern int DEport_set_format_block ARGS((DEPort, char *, int));
extern void DExchange_close ARGS((DExchange));
extern void DExchange_free ARGS((DExchange));
extern void DEport_close ARGS((DEPort));
extern int DExchange_open_inet ARGS((DExchange));
extern int DExchange_listen ARGS((DExchange, int));
extern int DExchange_open_unix ARGS((DExchange, char *));
extern DEPort DExchange_initiate_conn ARGS((DExchange, char *, int, int block_by_default));
extern DEPort DExchange_get_conn ARGS((DExchange, char *, int, int block_by_default));
extern DEPort DExchange_accept_conn_sock ARGS((DExchange, int));
extern DEPort DExchange_accept_conn_file ARGS((DExchange, char *, char *));
extern int DExchange_poll_and_handle ARGS((DExchange, int block));
extern int DExchange_poll_and_handle_timeout ARGS((DExchange de,
						   int timeout_sec,
						   int timeout_usec));

extern int DEControlList_poll_and_handle ARGS((DEControlList cl, int block));
extern int DEControlList_poll_and_handle_timeout ARGS((DEControlList cl,
						       int timeout_sec,
						       int timeout_usec));
extern void DExchange_register_format ARGS((DExchange, char *, IOFieldList));
extern int DExchange_shutdown_connection ARGS((DExchange, DEPort,
					       ShutDownFlag, char *));
extern void DExchange_set_format_fixed ARGS((DExchange, char *, int));

extern void DExchange_register_function ARGS((DExchange, char *, DataHandlingFunc, void *user_data));
extern void DExchange_register_threaded_function ARGS((DExchange, char *, DataHandlingFunc, void *user_data));
extern int DExchange_unregister_function ARGS((DExchange, char *, DataHandlingFunc, void *user_data));
extern void DExchange_register_filter ARGS((DExchange, char *, DataHandlingFunc, void *user_data));
extern int DExchange_unregister_filter ARGS((DExchange, char *, DataHandlingFunc, void *user_data));

extern int DEport_write_data ARGS((DEPort, int, void *));
extern int DEport_write_data_by_name ARGS((DEPort, char *, void *));
extern void DExchange_forward_data ARGS((DExchange, DEPort, int, void *));
extern char *DEport_read_data ARGS((DEPort, int *));
extern IOFile DEport_from_port ARGS((DEPort));
extern IOFile DEport_to_port ARGS((DEPort));
extern DExchange DExchange_of_port ARGS((DEPort));
extern char *DExchange_host_name ARGS((DExchange));
extern char *DExchange_name ARGS((DExchange));
extern int DExchange_inet_port ARGS((DExchange));
extern char *DEport_name ARGS((DEPort));
extern char *DEport_host_name ARGS((DEPort));
extern int DEport_port_number ARGS((DEPort));
extern void DEget_qual_hostname ARGS((char *buf, int len));

extern void DEinit_block_check();

extern int DExchange_register_format_handler ARGS((DExchange,
					      FormatHandlingFunc funct));
extern int DExchange_register_comment_handler ARGS((DExchange,
					     CommentHandlingFunc funct));
extern int DExchange_register_close_handler ARGS((DExchange,
					   OpenCloseHandlingFunc funct));
extern int DEport_register_close_handler ARGS((DEPort,
					   OpenCloseHandlingFunc funct));

extern int DExchange_register_open_handler ARGS((DExchange,
					   OpenCloseHandlingFunc funct));

extern int DEget_format_id ARGS((DExchange de, char *name));

extern char *DEget_format_name ARGS((DExchange de, int format_id));

extern DESavedRecPtr DEqueue_data ARGS((DExchange, DEPort, void *, int, int));
extern void DErelease_data ARGS((DESavedRecPtr));
extern void DEtake_buffer ARGS((DExchange, void *));
extern void DEreturn_buffer ARGS((DExchange, void *));
extern void *DESavedRec_get_data_ptr ARGS((DESavedRecPtr rec));
extern int DESavedRec_format_id ARGS((DESavedRecPtr rec));

struct _DERecField;
typedef struct _DERecField *DERecFieldPtr;

typedef enum _DEDataResult {
    DEData_OK, DEData_Too_Small, DEData_Truncate
} DEDataResult;

extern void DEget_field_info ARGS((DExchange de, char *format_name,
				   char *field_name, int *size,
				   const char **field_type_p));
extern DERecFieldPtr DEmake_field_ptr ARGS((DExchange de, char *format_name,
					  char *field_name, int get_size,
					    char *get_type));
extern DEDataResult DEget_data ARGS((DExchange de, void *data, void *record,
				     DERecFieldPtr field));
typedef enum _DEDebugFlag {
    DEData_Debug, DEOther_Debug, DENo_Debug
} DEDebugFlag;

extern void DEset_debug_flags ARGS((DExchange de, DEDebugFlag flag, int value));

extern int DExchange_debugging_on ARGS((DExchange de));

extern void
 DEprint_version();

/* the following function prototypes are used with DataExchange *
 * conditions. */
int DECondition_get ARGS((DExchange de, DEPort dep));
int DECondition_wait ARGS((DExchange de, int condition));
void DECondition_signal ARGS((DExchange de, int condition));
void DECondition_set_client_data ARGS((DExchange de, int condition,
				       void *client_data));
void *DECondition_get_client_data ARGS((DExchange de, int condition));

/* The following function prototypes and function type declarations * are
 * * specific to connectionless DE */

typedef int (*StartUpFunc) ARGS((struct _DExchange *, struct _DEPort *, void **));
typedef int (*ReadFunc) ARGS((char **, int *, void **));
typedef int (*WriteFunc) ARGS((char *, int, void **));
typedef void (*ShutdownFunc) ARGS((void *));
typedef int (*GetNewCliFunc) ARGS((void **));
typedef int (*AddrCmpFunc) ARGS((void *, void *));

extern DEPort DExchange_dg_accept_conn_setup ARGS((DExchange, StartUpFunc,
						   void *));
extern DEPort DExchange_dg_init_conn ARGS((DExchange, int block_by_default,
					   StartUpFunc, void *));
extern int DExchange_dg_general_handler ARGS((void *, void *));
extern void DExchange_dg_assignFuncs ARGS((DEPort, ReadFunc,
					   WriteFunc, ShutdownFunc,
					   GetNewCliFunc, AddrCmpFunc));

/* The functions below are used for customizing network interfaces */

extern DEPort DEPort_create ARGS((DExchange de));

extern int
DExchange_accept_port_init ARGS((DEPort dep, IOFile from_port,
				 IOFile to_port));

extern int
DExchange_initiate_port_init ARGS((DEPort dep, IOFile from_port,
				   IOFile to_port, int block_by_default));

extern void
DExchange_set_port_number ARGS((DExchange de, int port_num));

typedef void (*GenericHandlerFunc) ARGS((void *, void *));

extern void
DEPort_add_general_select ARGS((DEPort dep, int fd));

extern void
DExchange_add_select ARGS((DExchange de, int fd, GenericHandlerFunc func,
			   void *arg1, void *arg2));

extern void
DExchange_remove_select ARGS((DExchange de, int fd));

extern void
DEPort_add_general_poll ARGS((DEPort dep));

extern void
DExchange_add_poll ARGS((DExchange de, GenericHandlerFunc func,
			 void *arg1, void *arg2));

typedef struct _DEtask_handle *DEtask_handle;

extern DEtask_handle
DExchange_add_periodic ARGS((DExchange de, long period, 
			     GenericHandlerFunc func,
			     void *arg1, void *arg2));

extern DEtask_handle
DEControlList_add_periodic ARGS((DEControlList cl, long period,
				 GenericHandlerFunc func,
				 void *arg1, void *arg2));

extern void
DEtask_remove_periodic ARGS((DEtask_handle handle));

extern void DExchange_add_close ARGS((DExchange de, GenericHandlerFunc func,
				      void *arg1, void *arg2));

/* Network Interface functions */

typedef
DEPort(*InitiateConnFunc) ARGS((DExchange de, char *name_str,
				int int_port_num,
				int block_by_default));

typedef int (*ListenFunc) ARGS((DExchange de, int int_port_num));

extern void DExchange_set_interface ARGS((DExchange de,
					  InitiateConnFunc init_conn_func,
					  ListenFunc listen_func));

DEPort
DExchange_inet_initiate_conn ARGS((DExchange de, char *name_str,
				int int_port_num, int block_by_default));

extern int
DExchange_inet_listen ARGS((DExchange de, int int_port_num));

/* Channel functions */

struct _EChannel;
struct _ECSourceHandle;
struct _ECSinkHandle;

typedef struct _EChannel *EChannel;
typedef struct _ECSourceHandle *ECSourceHandle;
typedef struct _ECSinkHandle *ECSinkHandle;
typedef struct _ECDataHandle *ECDataHandle;

typedef void (*ECHandlerFunction) ARGS((void *event, int length,
					void *client_data));

typedef void (*ECTypedHandlerFunction) ARGS((void *event, void *client_data));

typedef void (*ECSubscribeFunction) ARGS((int subscribe, int subscriber_count,
					  void *client_data));

typedef void (*EventFreeFunction) ARGS((void *event_data));

typedef void (*ECRequestHandlerFunction) ARGS((ECSourceHandle handle, 
					       void *client_data));

extern EChannel
 EChannel_create ARGS((DExchange de));

extern void
 EChannel_destroy ARGS((EChannel chan));

extern EChannel
EChannel_typed_create ARGS((DExchange de, IOFieldList field_list,
			    DEFormatList format_list));

extern EChannel
 EChannel_open ARGS((DExchange de, char *global_name));

extern EChannel
EChannel_derive ARGS((DExchange de, char *chan_id, char *event_filter));

extern EChannel
EChannel_typed_derive ARGS((DExchange de, char *chan_id, char *event_filter,
			    IOFieldList field_list, DEFormatList format_list));

extern char *ECglobal_id ARGS((EChannel chan));

extern void
EChannel_subscribe_handler ARGS((EChannel chan, ECSubscribeFunction func,
				 void *client_data));

extern void
ECsubmit_event ARGS((ECSourceHandle handle, void *event, int event_length));

extern void
ECsubmit_typed_event ARGS((ECSourceHandle handle, void *event));

extern void
ECrequest_event ARGS((ECSinkHandle handle, int req_try));

extern void
ECsubmit_eventV ARGS((ECSourceHandle handle, IOEncodeVector eventv));

extern void
ECsubmit_general_event ARGS((ECSourceHandle handle, void *event,
			     int event_len, EventFreeFunction free_func));

extern void
ECsubmit_general_typed_event ARGS((ECSourceHandle handle, void *event,
				   EventFreeFunction free_func));

extern void
ECsubmit_general_eventV ARGS((ECSourceHandle handle, IOEncodeVector eventV,
			      EventFreeFunction free_func));

extern ECSinkHandle
 ECsink_subscribe ARGS((EChannel chan, ECHandlerFunction func, void *client_data));

extern ECSinkHandle
 ECsink_subscribe_context ARGS((EChannel chan, ECHandlerFunction func,
				void *client_data, DExchange de));

extern ECSinkHandle
 ECsink_typed_subscribe ARGS((EChannel chan, IOFieldList field_list,
			      DEFormatList format_list,
			      ECTypedHandlerFunction func, void *client_data));

extern ECSinkHandle
 ECsink_typed_subscribe_context ARGS((EChannel chan, IOFieldList field_list,
				      DEFormatList format_list,
				      ECTypedHandlerFunction func,
				      void *client_data, DExchange de));

extern ECSourceHandle
 ECsource_subscribe ARGS((EChannel chan));

extern ECSourceHandle
 ECsource_typed_subscribe ARGS((EChannel chan, IOFieldList field_list,
				DEFormatList format_list));

extern ECSourceHandle
 ECPsource_subscribe ARGS((EChannel chan, 
			   ECRequestHandlerFunction func, void *client_data));

extern ECSourceHandle 
  ECPsource_typed_subscribe ARGS((EChannel chan, IOFieldList field_list, 
				  DEFormatList format_list, 
				  ECRequestHandlerFunction func, void *client_data));

extern void
ECcancel_sink_subscribe ARGS((ECSinkHandle handle));

extern void
ECcancel_source_subscribe ARGS((ECSourceHandle handle));

extern int EChas_sinks ARGS((ECSourceHandle handle));

extern IOFieldList EChannel_get_field_list ARGS((EChannel chan));
extern DEFormatList EChannel_get_format_list ARGS((EChannel chan));

typedef struct _ECdata_struct {
    IOFieldList data_field_list;
    DEFormatList data_subformat_list;
    void *initial_value;
}ECdata_struct, *ECdata_spec;

typedef struct _ECproto *ECproto;

#ifdef __ECL__H__
extern ECproto ECproto_create ARGS((DExchange de, ecl_parse_context context));
#endif
extern char *ECproto_id ARGS((ECproto proto_chan));

extern EChannel 
ECproto_derive_periodic ARGS((DExchange de, char *proto_id, 
			      char *filter_function,
			      IOFieldList field_list, DEFormatList format_list,
			      int microsec_period));

extern EChannel 
EChannel_derive_data ARGS((DExchange de, char *chan_id, 
			   char *filter_function, 
			   ECdata_spec data_spec));
extern EChannel 
EChannel_typed_derive_data ARGS((DExchange de, char *chan_id,
				 char *filter_function,
				 IOFieldList field_list, 
				 DEFormatList format_list,
				 ECdata_spec data_spec));

extern ECDataHandle 
EChannel_data_open ARGS((EChannel channel, IOFieldList data_field_list,
			 DEFormatList data_subformat_list));
extern void 
EChannel_data_update ARGS((ECDataHandle data_handle, void *data));

extern void
EChannel_data_close ARGS((ECDataHandle handle));

extern void DEControlList_event_dispatch ARGS((DEControlList control_list));

typedef void *(*DEMallocFunction) ARGS((int size));
typedef void *(*DEReallocFunction) ARGS((void *block, int size));
typedef void (*DEFreeFunction) ARGS((void *block));

extern void DE_set_allocators ARGS((DEMallocFunction malloc_func,
				    DEReallocFunction realloc_func,
				    DEFreeFunction free_func));
#endif
