#include "io.h"
#include "DE.h"
#include "otl.h"
#include "ball_mon.h"

extern void update_position(int x, int y);

extern CORBA_void   
impl_ball_position_mon_update(ball_position_mon object, CORBA_Environment *ev)
{
    position_t cur_pos = ball_position_mon__get_position(object, ev);
    update_position(cur_pos.x, cur_pos.y);
}

static ball_direction_mon bd = NULL;
static ball_size_mon bz = NULL;
static ball_speed_mon bs = NULL;

extern int dial_min, dial_max;
extern int set_dial(int dial_value);
extern void outside_change_size(int size_val);
extern void outside_change_speed(int speed_val);

extern CORBA_void   
impl_ball_direction_mon_update(ball_direction_mon object, CORBA_Environment *ev)
{
    int dial_value;
    float angle = ball_direction_mon__get_direction(object, ev);
    if (bd == NULL) {
	bd = object;
    }
    
    angle += 90.0;
    if (angle > 360.0) angle -= 360.0;
    dial_value = angle / (360.0) * (dial_max -dial_min) 
	+ dial_min;
    set_dial(dial_value);
}

extern CORBA_void   
impl_ball_speed_mon_update(ball_speed_mon object, CORBA_Environment *ev)
{
    if (bs == NULL) {
	bs = object;
    }
    outside_change_speed(ball_speed_mon__get_speed(object, ev));
}

extern CORBA_void   
impl_ball_size_mon_update(ball_size_mon object, CORBA_Environment *ev)
{
    if (bz == NULL) {
	bz = object;
    }
    outside_change_size(ball_size_mon__get_size(object, ev));
}

void
set_ball_direction(float angle)
{
    static CORBA_Environment *ev = NULL;
    
    if (bd != NULL) {
	/* Don't create ev until everything is initialized and we have 
	 * created a ball_direction_mon object.
	 */
	if (ev == NULL) {
	    COBS_create_Environment_object(&ev);
	}
	ball_direction_mon_set_ball_direction(bd, angle, ev);
    }
}
void
set_ball_size(int size)
{
    static CORBA_Environment *ev = NULL;
    
    if (bz != NULL) {
	if (ev == NULL) {
	    COBS_create_Environment_object(&ev);
	}
	if (ball_size_mon__get_size(bz, ev) != size) {
	    ball_size_mon_set_ball_size(bz, size, ev);
	}
    }
}

void
set_ball_speed(int speed)
{
    static CORBA_Environment *ev = NULL;
    
    if (bs != NULL) {
	if (ev == NULL) {
	    COBS_create_Environment_object(&ev);
	}
	if (ball_speed_mon__get_speed(bs, ev) != speed) {
	    ball_speed_mon_set_ball_speed(bs, speed, ev);
	}
    }
}
