/*
 * This file is part of the Picasso Visualization Environment
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * CONFIDENTIAL INFORMATION. Distribution
 * restricted under license agreement.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613 and by grants from the Digital Equipment Corporation
 * External Research Program and Apple Computer.
 *
 */
/*
 *	$Header: /users/c/chaos/CVSmaster/bounce_demo/gui/DialP.h,v 1.2 1999/01/10 15:54:21 chaos Exp $
 */

#ifndef _XtDialP_h
#define _XtDialP_h

#include "Dial.h"
#include <X11/CoreP.h>

#define PADDING			2
#define PI			3.14159265358979
#define PIHALF			(3.14159265358979 / 2)
#define TWOPI			(2. * PI)
#define NEEDLE_FRACTION		0.85
#define NEEDLE_WIDTH		6
#define NEEDLE_WIDTH_FRACTION	0.1
#define NEEDLE_POINTS		4
#define MAXTICKS		20
#define MAJOR_TICK		5
#define MIN_SIZE		150

typedef struct {
  /* public */
  Boolean	show_value;		/* show digital value		*/
  int		begin_degree;		/* beginning degree (0-360)	*/
  int		end_degree;		/* ending degree (0-360)	*/
  int		min_value, max_value;	/* minimum and maximum value	*/
  int		value;			/* dial value			*/
  Pixel		face_border_color;	/* color for dial face border	*/
  Pixel		face_color;		/* color for dial face		*/
  Pixel		needle_color;		/* color for needle		*/
  Pixel		needle_border_color;	/* color for needle border	*/
  Pixel		tick_color;		/* color for tick marks		*/
  XtCallbackList select;		/* callback for select		*/
  /* private */
  int		value_select;		/* selected value		*/
  int		backing_store;		/* backing store type		*/
  Dimension	radius;			/* radius factor		*/
  Dimension	needle_length;
  Dimension	needle_width;
  GC		face_borderGC;		/* face border GC		*/
  GC		faceGC;			/* face GC			*/
  GC		eraseGC;		/* erase GC			*/
  GC		needleGC;		/* needle GC			*/
  GC		needle_borderGC;	/* needle GC			*/
  GC		tickGC;			/* tick GC			*/
  Position	centerX;		/* dial center x position	*/
  Position	centerY;		/* dial center y position	*/
  XPoint	needle[NEEDLE_POINTS];	/* needle points		*/
  XSegment	ticks[MAXTICKS];	/* tick segments		*/
} DialPart;

typedef struct _DialRec {
   CorePart core;
   DialPart dial;
   } DialRec;

typedef struct {int dummy;} DialClassPart;

typedef struct _DialClassRec {
   CoreClassPart core_class;
   DialClassPart dial_class;
   } DialClassRec;

extern DialClassRec dialClassRec;

#endif
