/*
 * This file is part of the Picasso Visualization Environment
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * CONFIDENTIAL INFORMATION. Distribution
 * restricted under license agreement.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613 and by grants from the Digital Equipment Corporation
 * External Research Program and Apple Computer.
 *
 */
/*
 *	$Header: /users/c/chaos/CVSmaster/bounce_demo/gui/Dial.h,v 1.2 1999/01/09 14:45:34 chaos Exp $
 */

#include <X11/Xmu/Xmu.h>

#ifndef _XtDial_h
#define _XtDial_h

/************************************************************************/
/* dial resources							*/
/************************************************************************/
/* XtNbeginDegree	int		beginning degree		*/
/* XtNfaceBorderColor	Pixel		face border color		*/
/* XtNfaceColor		Pixel		face color			*/
/* XtNendDegree		int		endgin degree			*/
/* XtNminValue		int		minimum value			*/
/* XtNmaxValue		int		maximum value			*/
/* XtNneedleColor	Pixel		needle color			*/
/* XtNneedleBorderColor	Pixel		needle border color		*/
/* XtNtickColor		Pixel		tick color			*/
/* XtNvalue		int		needle value			*/
/* XtNdialSelect	XtCallbackList	callback pointer		*/
/************************************************************************/

#define XtNfaceBorderColor	"faceBorderColor"
#define XtNfaceColor		"faceColor"
#define XtNbeginDegree		"beginDegree"
#define XtNendDegree		"endDegree"
#define XtNneedleColor		"needleColor"
#define XtNneedleBorderColor	"needleBorderColor"
#define XtNtickColor		"tickColor"
#define XtNminValue		"minValue"
#define XtNmaxValue		"maxValue"
#define XtNselect		"select"

#define XtCFaceBorderColor	"FaceBorderColor"
#define XtCFaceColor		"FaceColor"
#define XtCBeginDegree		"BeginDegree"
#define XtCEndDegree		"EndDegree"
#define XtCNeedleColor		"NeedleColor"
#define XtCNeedleBorderColor	"NeedleBorderColor"
#define XtCTickColor		"TickColor"
#define XtCMinValue		"MinValue"
#define XtCMaxValue		"MaxValue"

typedef struct _DialRec		*DialWidget;
typedef struct _DialClassRec	*DialWidgetClass;

extern WidgetClass dialWidgetClass;

/****************/
/* dial methods */
/****************/
extern void	DialSetValue();
extern void	DialSetHistoryColors();

#endif
