/*
 * IDLtoC.h
 *
 * This file contains definitions for basic CORBA types
 */

#ifndef IDLtoC_H
#define IDLtoC_H

#define NULL 0

/* Definition of basic types */
#define CORBA_short               short
#define CORBA_unsigned_short      unsigned short
#define CORBA_long                long
#define CORBA_unsigned_long       unsigned long
#define CORBA_float               float
#define CORBA_double              double
#define CORBA_boolean             char
#define CORBA_char                char
#define CORBA_octet               int
#define CORBA_enum                long

#define CORBA_void   void


/* Definition of CORBA_object */
typedef void *any_t;

typedef struct {
  any_t attrib_struct;
  any_t state;
} *CORBA_Object, CORBA_Object_struct;

typedef struct {
  char nothing;          /* for now we don't have anything ... */
} CORBA_Environment;


#define RESULT int
#define T_SUCCEED		0
#define T_NOMEMORY		1

typedef	    void *memory_t;
extern RESULT CORBA_alloc(memory_t *ptr, int size);
extern RESULT CORBA_realloc(memory_t *ptr, int size);
extern CORBA_free (memory_t mem);

extern void error(char *mst);


#endif
