#include "be_classes.hh"

//#############################################################################

//=============================================================================
/*
 * Prepare an argument for a BE
 */
void
BE_prep_arg( char*, idl_bool )
{
}

//=============================================================================
/*
 * Print out a version string for the BE
 */
void
BE_version()
{
	cerr << GTDEVEL("Generic BE, version 1.0.0") << endl;
}

//=============================================================================
/*
 * Do the work of this BE. 
 */
void
BE_produce()
{
	idl_global->root()->dump( cout );
}

//=============================================================================
/*
 * Abort this run of the BE
 */
void
BE_abort()
{
	cerr << GTDEVEL("Aborting execution.") << endl;
	BE_Root::abort();
	exit(1);
}

//=============================================================================

#define BE_WARN(str) \
	do { \
      idl_global->err()->back_end_warning( line(), file_name() ); \
		cerr << GTDEVEL(str) << endl; \
	} while ( 0 )

#define BE_ERROR(str) \
	do { \
		idl_global->err()->back_end( line(), file_name() ); \
		cerr << GTDEVEL(str) << endl; \
	} while ( 0 )

#define BE_ABORT(str) \
	do { BE_ERROR(str); BE_abort(); } while( 0 )

//#############################################################################

void
BE_Scope::dump( ostream& )
{
   idl_global->err()->back_end_warning( line_hack(), file_name_hack() );
}

//=============================================================================

void
BE_Expression::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_UnionLabel::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Decl::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Constant::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_EnumVal::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Field::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Argument::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Attribute::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_UnionBranch::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Module::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Root::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Operation::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Type::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_ConcreteType::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Array::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Enum::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_PredefinedType::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Sequence::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_String::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Structure::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Exception::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Union::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Interface::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_InterfaceFwd::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//=============================================================================

void
BE_Typedef::dump( ostream& )
{
	BE_WARN( DUMP_NOT_IMPLEMENTED );
}

//#############################################################################

