/*-*- C++ -*-*/
//#############################################################################
//## File: IDLtoC/be_generic/be_classes.cc
//## Author: Jeremy Heiner
//## Organization: Georgia Institute of Technology
//## Copyright: see below
//## Purpose: implements all the generic back end classes
//#############################################################################
//## History: the front end was developed by SunSoft, see their copyright
//## message below.  Dilma Silva, also here at gatech, developed the code
//## into an idl2c compiler to support the COBS project.  i'm starting with
//## dilma's code.

/*

COPYRIGHT

Copyright 1992, 1993, 1994 Sun Microsystems, Inc.  Printed in the United
States of America.  All Rights Reserved.

This product is protected by copyright and distributed under the following
license restricting its use.

The Interface Definition Language Compiler Front End (CFE) is made
available for your use provided that you include this license and copyright
notice on all media and documentation and the software program in which
this product is incorporated in whole or part. You may copy and extend
functionality (but may not remove functionality) of the Interface
Definition Language CFE without charge, but you are not authorized to
license or distribute it to anyone else except as part of a product or
program developed by you or with the express written consent of Sun
Microsystems, Inc. ("Sun").

The names of Sun Microsystems, Inc. and any of its subsidiaries or
affiliates may not be used in advertising or publicity pertaining to
distribution of Interface Definition Language CFE as permitted herein.

This license is effective until terminated by Sun for failure to comply
with this license.  Upon termination, you shall destroy or return all code
and documentation for the Interface Definition Language CFE.

INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES OF
ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS
FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A COURSE OF
DEALING, USAGE OR TRADE PRACTICE.

INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED WITH NO SUPPORT AND WITHOUT
ANY OBLIGATION ON THE PART OF Sun OR ANY OF ITS SUBSIDIARIES OR AFFILIATES
TO ASSIST IN ITS USE, CORRECTION, MODIFICATION OR ENHANCEMENT.

SUN OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL HAVE NO LIABILITY WITH
RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
INTERFACE DEFINITION LANGUAGE CFE OR ANY PART THEREOF.

IN NO EVENT WILL SUN OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE FOR
ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL, INDIRECT AND CONSEQUENTIAL
DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

Use, duplication, or disclosure by the government is subject to
restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in
Technical Data and Computer Software clause at DFARS 252.227-7013 and FAR
52.227-19.

Sun, Sun Microsystems and the Sun logo are trademarks or registered
trademarks of Sun Microsystems, Inc.

SunSoft, Inc.  
2550 Garcia Avenue 
Mountain View, California  94043

NOTE:

SunOS, SunSoft, Sun, Solaris, Sun Microsystems or the Sun logo are
trademarks or registered trademarks of Sun Microsystems, Inc.

 */

//#############################################################################

#include "be_classes.hh"

//#############################################################################

const char* BE_Argument::DUMP_NOT_IMPLEMENTED
							= "argument not supported in this context";

const char* BE_Array::DUMP_NOT_IMPLEMENTED
							= "array not supported in this context";

const char* BE_Attribute::DUMP_NOT_IMPLEMENTED
							= "attribute not supported in this context";

const char* BE_ConcreteType::DUMP_NOT_IMPLEMENTED
							= "concrete type not supported in this context";

const char* BE_Constant::DUMP_NOT_IMPLEMENTED
							= "constant not supported in this context";

const char* BE_Decl::DUMP_NOT_IMPLEMENTED
							= "declaration not supported in this context";

const char* BE_Enum::DUMP_NOT_IMPLEMENTED
							= "enum not supported in this context";

const char* BE_EnumVal::DUMP_NOT_IMPLEMENTED
							= "enumeration value not supported in this context";

const char* BE_Exception::DUMP_NOT_IMPLEMENTED
							= "exception not supported in this context";

const char* BE_Expression::DUMP_NOT_IMPLEMENTED
							= "expression not supported in this context";

const char* BE_Field::DUMP_NOT_IMPLEMENTED
							= "field not supported in this context";

const char* BE_Interface::DUMP_NOT_IMPLEMENTED
							= "interface not supported in this context";

const char* BE_InterfaceFwd::DUMP_NOT_IMPLEMENTED
							= "interface declaration not supported in this context";

const char* BE_Module::DUMP_NOT_IMPLEMENTED
							= "module not supported in this context";

const char* BE_Operation::DUMP_NOT_IMPLEMENTED
							= "operation not supported in this context";

const char* BE_PredefinedType::DUMP_NOT_IMPLEMENTED
							= "predefined type not supported in this context";

const char* BE_Root::DUMP_NOT_IMPLEMENTED
							= "module not supported in this context";

const char* BE_Scope::DUMP_NOT_IMPLEMENTED
							= "scope not supported in this context";

const char* BE_Sequence::DUMP_NOT_IMPLEMENTED
							= "sequence not supported in this context";

const char* BE_String::DUMP_NOT_IMPLEMENTED
							= "string not supported in this context";

const char* BE_Structure::DUMP_NOT_IMPLEMENTED
							= "structure not supported in this context";

const char* BE_Type::DUMP_NOT_IMPLEMENTED
							= "type not supported in this context";

const char* BE_Typedef::DUMP_NOT_IMPLEMENTED
							= "typedef not supported in this context";

const char* BE_Union::DUMP_NOT_IMPLEMENTED
							= "union not supported in this context";

const char* BE_UnionBranch::DUMP_NOT_IMPLEMENTED
							= "union branch not supported in this context";

const char* BE_UnionLabel::DUMP_NOT_IMPLEMENTED
							= "union label not supported in this context";

//#############################################################################
//=============================================================================
// Constructor

BE_Scope::BE_Scope( AST_Decl::NodeType t )
	: UTL_Scope( t )
{
}

BE_Scope::~BE_Scope()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS1( BE_Scope, UTL_Scope );
IMPL_NARROW_FROM_SCOPE( BE_Scope );

//=============================================================================
// hacks for be_errors macros
long BE_Scope::line_hack()
{
	AST_Decl* d = ScopeAsDecl(this);
	if ( d ) return d->line();
	else     return -1;
}

String *BE_Scope::file_name_hack()
{
	AST_Decl* d = ScopeAsDecl(this);
	if ( d ) return d->file_name();
	else     return new String((char*)"");
}

//#############################################################################
//=============================================================================
// Constructor

BE_Expression::BE_Expression( AST_Expression* v, ExprType t )
	: AST_Expression( v, t )
{
}


BE_Expression::BE_Expression( ExprComb c, AST_Expression* v1,
                              AST_Expression* v2 )
	: AST_Expression( c, v1, v2 )
{
}


BE_Expression::BE_Expression( short s )
	: AST_Expression( s )
{
}


BE_Expression::BE_Expression( unsigned short us )
	: AST_Expression( us )
{
}


BE_Expression::BE_Expression( long l )
	: AST_Expression( l )
{
}


BE_Expression::BE_Expression( long l, ExprType t )
	: AST_Expression( l, t )
{
}


BE_Expression::BE_Expression( unsigned long ul )
	: AST_Expression( ul )
{
}


BE_Expression::BE_Expression( float f )
	: AST_Expression( f )
{
}


BE_Expression::BE_Expression( double d )
	: AST_Expression( d )
{
}


BE_Expression::BE_Expression( char c )
	: AST_Expression( c )
{
}


BE_Expression::BE_Expression( unsigned char uc )
	: AST_Expression( uc )
{
}


BE_Expression::BE_Expression( String* s )
	: AST_Expression( s )
{
}


BE_Expression::BE_Expression( UTL_ScopedName* n )
	: AST_Expression( n )
{
}


BE_Expression::~BE_Expression()
{
}

//#############################################################################
//=============================================================================
// Constructor

BE_UnionLabel::BE_UnionLabel( AST_UnionLabel::UnionLabel l, AST_Expression* v )
	: AST_UnionLabel( l, v )
{
}

BE_UnionLabel::~BE_UnionLabel()
{
}

//#############################################################################
//=============================================================================
// Constructor

BE_Decl::BE_Decl( AST_Decl::NodeType t, UTL_ScopedName* n, UTL_StrList* p )
	: AST_Decl( t, n, p )
{
}

BE_Decl::~BE_Decl()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS1( BE_Decl, AST_Decl );
IMPL_NARROW_FROM_DECL( BE_Decl );

//#############################################################################
//=============================================================================
// Constructor

BE_Constant::BE_Constant( AST_Expression::ExprType e, AST_Expression* v,
                          UTL_ScopedName* n, UTL_StrList* p )
	: AST_Constant( e, v, n, p ),
	  BE_Decl( AST_Decl::NT_const, n, p ),
	  AST_Decl( AST_Decl::NT_const, n, p )
{
}

BE_Constant::BE_Constant( AST_Expression::ExprType e, AST_Decl::NodeType t,
                          AST_Expression* v,
                          UTL_ScopedName* n, UTL_StrList* p )
	: AST_Constant( e, v, n, p ),
	  BE_Decl( t, n, p ),
	  AST_Decl( t, n, p )
{
}

BE_Constant::~BE_Constant()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_Constant, BE_Decl, AST_Constant );
IMPL_NARROW_FROM_DECL( BE_Constant );

//#############################################################################
//=============================================================================
// Constructor

BE_EnumVal::BE_EnumVal( unsigned long v, UTL_ScopedName* n, UTL_StrList* p )
	: AST_EnumVal( v, n, p ),
	  BE_Constant( AST_Expression::EV_ulong, AST_Decl::NT_enum_val,
	               new AST_Expression(v), n, p ),
	  AST_Constant( AST_Expression::EV_ulong, AST_Decl::NT_enum_val,
	                new AST_Expression(v), n, p ),
	  BE_Decl( AST_Decl::NT_enum_val, n, p ),
	  AST_Decl( AST_Decl::NT_enum_val, n, p )
{
}

BE_EnumVal::~BE_EnumVal()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_EnumVal, BE_Constant, AST_EnumVal );
IMPL_NARROW_FROM_DECL( BE_EnumVal );

//#############################################################################
//=============================================================================
// Constructor

BE_Field::BE_Field( AST_Type* f, UTL_ScopedName* n, UTL_StrList* p )
	: AST_Field( f, n, p ),
	  BE_Decl( AST_Decl::NT_field, n, p ),
	  AST_Decl( AST_Decl::NT_field, n, p )
{
}

BE_Field::BE_Field( AST_Decl::NodeType t, AST_Type *f,
                    UTL_ScopedName *n, UTL_StrList *p)
	: AST_Field( t, f, n, p ),
	  BE_Decl( t, n, p ),
	  AST_Decl( t, n, p )
{
}

BE_Field::~BE_Field()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_Field, BE_Decl, AST_Field );
IMPL_NARROW_FROM_DECL( BE_Field );

//#############################################################################
//=============================================================================
// Constructor

BE_Argument::BE_Argument( AST_Argument::Direction d, AST_Type* f,
								  UTL_ScopedName* n, UTL_StrList* p )
	: AST_Argument( d, f, n, p ),
	  BE_Field( AST_Decl::NT_argument, f, n, p ),
	  AST_Field( AST_Decl::NT_argument, f, n, p ),
	  BE_Decl( AST_Decl::NT_argument, n, p ),
	  AST_Decl( AST_Decl::NT_argument, n, p )
{
}

BE_Argument::~BE_Argument()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_Argument, BE_Field, AST_Argument );
IMPL_NARROW_FROM_DECL( BE_Argument );

//#############################################################################
//=============================================================================
// Constructor

BE_Attribute::BE_Attribute(idl_bool r, AST_Type* f,
                           UTL_ScopedName* n, UTL_StrList* p)
	: AST_Attribute( r, f, n, p ),
	  BE_Field( AST_Decl::NT_attr, f, n, p ),
	  AST_Field( AST_Decl::NT_attr, f, n, p ),
	  BE_Decl( AST_Decl::NT_attr, n, p ),
	  AST_Decl( AST_Decl::NT_attr, n, p )
{
}

BE_Attribute::~BE_Attribute()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_Attribute, BE_Field, AST_Attribute );
IMPL_NARROW_FROM_DECL( BE_Attribute );

//#############################################################################
//=============================================================================
// Constructor

BE_UnionBranch::BE_UnionBranch( AST_UnionLabel* l, AST_Type* f,
                                UTL_ScopedName* n, UTL_StrList* p)
	: AST_UnionBranch( l, f, n, p ),
	  BE_Field( AST_Decl::NT_union_branch, f, n, p ),
	  AST_Field( AST_Decl::NT_union_branch, f, n, p ),
	  BE_Decl( AST_Decl::NT_union_branch, n, p ),
	  AST_Decl( AST_Decl::NT_union_branch, n, p )
{
}

BE_UnionBranch::~BE_UnionBranch()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_UnionBranch, BE_Field, AST_UnionBranch );
IMPL_NARROW_FROM_DECL( BE_UnionBranch );


//#############################################################################
//=============================================================================
// Constructor

BE_Module::BE_Module( UTL_ScopedName* n, UTL_StrList* p )
	: BE_Decl( AST_Decl::NT_module, n, p ),
	  AST_Decl( AST_Decl::NT_module, n, p ),
	  BE_Scope( AST_Decl::NT_module ),
	  UTL_Scope( AST_Decl::NT_module )
{
}

BE_Module::~BE_Module()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS3( BE_Module, BE_Decl, BE_Scope, AST_Module );
IMPL_NARROW_FROM_DECL( BE_Module );
IMPL_NARROW_FROM_SCOPE( BE_Module );

//#############################################################################
//=============================================================================
// Constructor

BE_Root::BE_Root( UTL_ScopedName* n, UTL_StrList* p )
	: BE_Module( n, p ),
	  AST_Module( n, p ),
	  BE_Decl( AST_Decl::NT_module, n, p ),
	  AST_Decl( AST_Decl::NT_module, n, p ),
	  BE_Scope( AST_Decl::NT_module ),
	  UTL_Scope( AST_Decl::NT_module )
{
}

BE_Root::~BE_Root()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_Root, BE_Module, AST_Root );
IMPL_NARROW_FROM_DECL( BE_Root );
IMPL_NARROW_FROM_SCOPE( BE_Root );

//#############################################################################
//=============================================================================
// Constructor

BE_Operation::BE_Operation( AST_Type* r, AST_Operation::Flags f,
                            UTL_ScopedName* n, UTL_StrList* p )
	: AST_Operation( r, f, n, p ),
	  BE_Decl( AST_Decl::NT_op, n, p ),
	  AST_Decl( AST_Decl::NT_op, n, p ),
	  BE_Scope( AST_Decl::NT_op ),
	  UTL_Scope( AST_Decl::NT_op )
{
}

BE_Operation::~BE_Operation()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS3( BE_Operation, BE_Decl, BE_Scope, AST_Operation );
IMPL_NARROW_FROM_DECL( BE_Operation );
IMPL_NARROW_FROM_SCOPE( BE_Operation );

//#############################################################################
//=============================================================================
// Constructor

BE_Type::BE_Type( AST_Decl::NodeType t, UTL_ScopedName* n, UTL_StrList* p )
	: AST_Type( t, n, p ),
	  BE_Decl( t, n, p ),
	  AST_Decl( t, n, p )
{
}

BE_Type::~BE_Type()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_Type, BE_Decl, AST_Type );
IMPL_NARROW_FROM_DECL( BE_Type );

//#############################################################################
//=============================================================================
// Constructor

BE_ConcreteType::BE_ConcreteType( AST_Decl::NodeType t,
                                  UTL_ScopedName* n, UTL_StrList* p )
	: AST_ConcreteType( t, n, p ),
	  BE_Type( t, n, p ),
	  AST_Type( t, n, p ),
	  BE_Decl( t, n, p ),
	  AST_Decl( t, n, p )
{
}

BE_ConcreteType::~BE_ConcreteType()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_ConcreteType, BE_Decl, AST_ConcreteType );
IMPL_NARROW_FROM_DECL( BE_ConcreteType );

//#############################################################################
//=============================================================================
// Constructor

BE_Array::BE_Array( UTL_ScopedName* n, unsigned long i, UTL_ExprList* d )
	: AST_Array( n, i, d ),
	  BE_ConcreteType( AST_Decl::NT_array, n, NULL ),
	  AST_ConcreteType( AST_Decl::NT_array, n, NULL ),
	  BE_Type( AST_Decl::NT_array, n, NULL ),
	  AST_Type( AST_Decl::NT_array, n, NULL ),
	  BE_Decl( AST_Decl::NT_array, n, NULL ),
	  AST_Decl( AST_Decl::NT_array, n, NULL )
{
}

BE_Array::~BE_Array()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_Array, BE_ConcreteType, AST_Array );
IMPL_NARROW_FROM_DECL( BE_Array );

//#############################################################################
//=============================================================================
// Constructor

BE_Enum::BE_Enum( UTL_ScopedName* n, UTL_StrList *p )
	: AST_Enum( n, p ),
	  BE_ConcreteType( AST_Decl::NT_enum, n, p ),
	  AST_ConcreteType( AST_Decl::NT_enum, n, p ),
	  BE_Type( AST_Decl::NT_enum, n, p ),
	  AST_Type( AST_Decl::NT_enum, n, p ),
	  BE_Decl( AST_Decl::NT_enum, n, p ),
	  AST_Decl( AST_Decl::NT_enum, n, p ),
	  BE_Scope( AST_Decl::NT_enum ),
	  UTL_Scope( AST_Decl::NT_enum )
{
}

BE_Enum::~BE_Enum()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS3( BE_Enum, BE_ConcreteType, BE_Scope, AST_Enum );
IMPL_NARROW_FROM_DECL( BE_Enum );
IMPL_NARROW_FROM_SCOPE( BE_Enum );

//#############################################################################
//=============================================================================
// Constructor

BE_PredefinedType::BE_PredefinedType( AST_PredefinedType::PredefinedType t,
                                      UTL_ScopedName* n, UTL_StrList* p )
	: AST_PredefinedType( t, n, p ),
	  BE_ConcreteType( AST_Decl::NT_pre_defined, n, p ),
	  AST_ConcreteType( AST_Decl::NT_pre_defined, n, p ),
	  BE_Type( AST_Decl::NT_pre_defined, n, p ),
	  AST_Type( AST_Decl::NT_pre_defined, n, p ),
	  BE_Decl( AST_Decl::NT_pre_defined, n, p ),
	  AST_Decl( AST_Decl::NT_pre_defined, n, p )
{
}

BE_PredefinedType::~BE_PredefinedType()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_PredefinedType, BE_ConcreteType, AST_PredefinedType );
IMPL_NARROW_FROM_DECL( BE_PredefinedType );

//#############################################################################
//=============================================================================
// Constructor

BE_Sequence::BE_Sequence( AST_Expression* m, AST_Type* t )
	: AST_Sequence( m, t ),
	  BE_ConcreteType( AST_Decl::NT_sequence, NULL, NULL ),
	  AST_ConcreteType( AST_Decl::NT_sequence, NULL, NULL ),
	  BE_Type( AST_Decl::NT_sequence, NULL, NULL ),
	  AST_Type( AST_Decl::NT_sequence, NULL, NULL ),
	  BE_Decl( AST_Decl::NT_sequence, NULL, NULL ),
	  AST_Decl( AST_Decl::NT_sequence, NULL, NULL )
{
}

BE_Sequence::~BE_Sequence()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_Sequence, BE_ConcreteType, AST_Sequence );
IMPL_NARROW_FROM_DECL( BE_Sequence );

//#############################################################################
//=============================================================================
// Constructor

BE_String::BE_String( AST_Expression* m )
	: AST_String( m ),
	  BE_ConcreteType( AST_Decl::NT_string, NULL, NULL ),
	  AST_ConcreteType( AST_Decl::NT_string, NULL, NULL ),
	  BE_Type( AST_Decl::NT_string, NULL, NULL ),
	  AST_Type( AST_Decl::NT_string, NULL, NULL ),
	  BE_Decl( AST_Decl::NT_string, NULL, NULL ),
	  AST_Decl( AST_Decl::NT_string, NULL, NULL )
{
}

BE_String::BE_String( AST_Expression* m, long w )
	: AST_String( m, w ),
	  BE_ConcreteType( AST_Decl::NT_string, NULL, NULL ),
	  AST_ConcreteType( AST_Decl::NT_string, NULL, NULL ),
	  BE_Type( AST_Decl::NT_string, NULL, NULL ),
	  AST_Type( AST_Decl::NT_string, NULL, NULL ),
	  BE_Decl( AST_Decl::NT_string, NULL, NULL ),
	  AST_Decl( AST_Decl::NT_string, NULL, NULL )
{
}

BE_String::~BE_String()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_String, BE_ConcreteType, AST_String );
IMPL_NARROW_FROM_DECL( BE_String );

//#############################################################################
//=============================================================================
// Constructor

BE_Structure::BE_Structure( UTL_ScopedName* n, UTL_StrList* p )
	: AST_Structure( n, p ),
	  BE_ConcreteType( AST_Decl::NT_struct, n, p ),
	  AST_ConcreteType( AST_Decl::NT_struct, n, p ),
	  BE_Type( AST_Decl::NT_struct, n, p ),
	  AST_Type( AST_Decl::NT_struct, n, p ),
	  BE_Decl( AST_Decl::NT_struct, n, p ),
	  AST_Decl( AST_Decl::NT_struct, n, p ),
	  BE_Scope( AST_Decl::NT_struct ),
	  UTL_Scope( AST_Decl::NT_struct )
{
}

BE_Structure::BE_Structure(AST_Decl::NodeType t, UTL_ScopedName* n,
                           UTL_StrList* p)
	: AST_Structure( t, n, p ),
	  BE_ConcreteType( t, n, p ),
	  AST_ConcreteType( t, n, p ),
	  BE_Type( t, n, p ),
	  AST_Type( t, n, p ),
	  BE_Decl( t, n, p ),
	  AST_Decl( t, n, p ),
	  BE_Scope( t ),
	  UTL_Scope( t )
{
}

BE_Structure::~BE_Structure()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS3( BE_Structure, BE_ConcreteType, BE_Scope, AST_Structure );
IMPL_NARROW_FROM_DECL( BE_Structure );
IMPL_NARROW_FROM_SCOPE( BE_Structure );

//#############################################################################
//=============================================================================
// Constructor

BE_Exception::BE_Exception( UTL_ScopedName* n, UTL_StrList* p )
	: AST_Exception( n, p ),
	  BE_Structure( AST_Decl::NT_except, n, p ),
	  AST_Structure( AST_Decl::NT_except, n, p ),
	  BE_ConcreteType( AST_Decl::NT_except, n, p ),
	  AST_ConcreteType( AST_Decl::NT_except, n, p ),
	  BE_Type( AST_Decl::NT_except, n, p ),
	  AST_Type( AST_Decl::NT_except, n, p ),
	  BE_Decl( AST_Decl::NT_except, n, p ),
	  AST_Decl( AST_Decl::NT_except, n, p ),
	  BE_Scope( AST_Decl::NT_except ),
	  UTL_Scope( AST_Decl::NT_except )
{
}

BE_Exception::~BE_Exception()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_Exception, BE_Structure, AST_Exception );
IMPL_NARROW_FROM_DECL( BE_Exception );
IMPL_NARROW_FROM_SCOPE( BE_Exception );

//=============================================================================
// Scope Management Protocol

AST_Field*
BE_Exception::fe_add_field(AST_Field *f)
{ return AST_Exception::fe_add_field(f); }

AST_Union*
BE_Exception::fe_add_union(AST_Union *u)
{ return AST_Exception::fe_add_union(u); }

AST_Structure*
BE_Exception::fe_add_structure(AST_Structure *s)
{ return AST_Exception::fe_add_structure(s); }

AST_Enum*
BE_Exception::fe_add_enum(AST_Enum *e)
{ return AST_Exception::fe_add_enum(e); }

AST_EnumVal*
BE_Exception::fe_add_enum_val(AST_EnumVal *v)
{ return AST_Exception::fe_add_enum_val(v); }

//#############################################################################
//=============================================================================
// Constructor

BE_Union::BE_Union( AST_ConcreteType* d, UTL_ScopedName* n, UTL_StrList* p )
	: AST_Union( d, n, p ),
	  BE_Structure( AST_Decl::NT_union, n, p ),
	  AST_Structure( AST_Decl::NT_union, n, p ),
	  BE_ConcreteType( AST_Decl::NT_union, n, p ),
	  AST_ConcreteType( AST_Decl::NT_union, n, p ),
	  BE_Type( AST_Decl::NT_union, n, p ),
	  AST_Type( AST_Decl::NT_union, n, p ),
	  BE_Decl( AST_Decl::NT_union, n, p ),
	  AST_Decl( AST_Decl::NT_union, n, p ),
	  BE_Scope( AST_Decl::NT_union ),
	  UTL_Scope( AST_Decl::NT_union )
{
}

BE_Union::~BE_Union()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_Union, BE_Structure, AST_Union );
IMPL_NARROW_FROM_DECL( BE_Union );
IMPL_NARROW_FROM_SCOPE( BE_Union );

//=============================================================================
// Scope Management Protocol

AST_Union*
BE_Union::fe_add_union(AST_Union			*u)
{ return AST_Union::fe_add_union(u); }

AST_Structure*
BE_Union::fe_add_structure(AST_Structure		*s)
{ return AST_Union::fe_add_structure(s); }

AST_Enum*
BE_Union::fe_add_enum(AST_Enum			*e)
{ return AST_Union::fe_add_enum(e); }

AST_EnumVal*
BE_Union::fe_add_enum_val(AST_EnumVal		*v)
{ return AST_Union::fe_add_enum_val(v); }

//#############################################################################
//=============================================================================
// Constructor

BE_Interface::BE_Interface( UTL_ScopedName* n, AST_Interface** h,
                            long i, UTL_StrList* p )
	: AST_Interface( n, h, i, p ),
	  BE_Type( AST_Decl::NT_interface, n, p ),
	  AST_Type( AST_Decl::NT_interface, n, p ),
	  BE_Decl( AST_Decl::NT_interface, n, p ),
	  AST_Decl( AST_Decl::NT_interface, n, p ),
	  BE_Scope( AST_Decl::NT_interface ),
	  UTL_Scope( AST_Decl::NT_interface )
{
}

BE_Interface::~BE_Interface()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS3( BE_Interface, BE_Type, BE_Scope, AST_Interface );
IMPL_NARROW_FROM_DECL( BE_Interface );
IMPL_NARROW_FROM_SCOPE( BE_Interface );

//#############################################################################
//=============================================================================
// Constructor

BE_InterfaceFwd::BE_InterfaceFwd( UTL_ScopedName* n, UTL_StrList* p )
	: AST_InterfaceFwd( n, p ),
	  BE_Type( AST_Decl::NT_interface_fwd, n, p ),
	  AST_Type( AST_Decl::NT_interface_fwd, n, p ),
	  BE_Decl( AST_Decl::NT_interface_fwd, n, p ),
	  AST_Decl( AST_Decl::NT_interface_fwd, n, p )
{
}

BE_InterfaceFwd::~BE_InterfaceFwd()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_InterfaceFwd, BE_Type, AST_InterfaceFwd );
IMPL_NARROW_FROM_DECL( BE_InterfaceFwd );

//#############################################################################
//=============================================================================
// Constructor

BE_Typedef::BE_Typedef( AST_Type *t, UTL_ScopedName* n, UTL_StrList* p )
	: AST_Typedef( t, n, p),
	  BE_Type( AST_Decl::NT_typedef, n, p ),
	  AST_Type( AST_Decl::NT_typedef, n, p ),
	  BE_Decl( AST_Decl::NT_typedef, n, p ),
	  AST_Decl( AST_Decl::NT_typedef, n, p )
{
}

BE_Typedef::~BE_Typedef()
{
}

//=============================================================================
// Narrowing

IMPL_NARROW_METHODS2( BE_Typedef, BE_Type, AST_Typedef );
IMPL_NARROW_FROM_DECL( BE_Typedef );

//#############################################################################

